/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.netex.mapping;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.opentripplanner.common.model.T2;
import org.opentripplanner.graph_builder.DataImportIssueStore;
import org.opentripplanner.graph_builder.Issue;
import org.opentripplanner.netex.index.api.ReadOnlyHierarchicalVersionMapById;
import org.opentripplanner.netex.issues.StopPlaceWithoutQuays;
import org.opentripplanner.netex.mapping.QuayMapper;
import org.opentripplanner.netex.mapping.StationMapper;
import org.opentripplanner.netex.mapping.StopPlaceTypeMapper;
import org.opentripplanner.netex.mapping.TariffZoneMapper;
import org.opentripplanner.netex.mapping.WheelChairMapper;
import org.opentripplanner.netex.mapping.support.FeedScopedIdFactory;
import org.opentripplanner.netex.mapping.support.StopPlaceVersionAndValidityComparator;
import org.opentripplanner.transit.model.basic.Accessibility;
import org.opentripplanner.transit.model.basic.TransitMode;
import org.opentripplanner.transit.model.site.FareZone;
import org.opentripplanner.transit.model.site.RegularStop;
import org.opentripplanner.transit.model.site.Station;
import org.rutebanken.netex.model.Quay;
import org.rutebanken.netex.model.Quays_RelStructure;
import org.rutebanken.netex.model.StopPlace;
import org.rutebanken.netex.model.TariffZoneRef;

class StopAndStationMapper {
    private final ReadOnlyHierarchicalVersionMapById<Quay> quayIndex;
    private final StationMapper stationMapper;
    private final QuayMapper quayMapper;
    private final TariffZoneMapper tariffZoneMapper;
    private final StopPlaceTypeMapper stopPlaceTypeMapper = new StopPlaceTypeMapper();
    private final DataImportIssueStore issueStore;
    private final Set<String> quaysAlreadyProcessed = new HashSet<String>();
    final List<RegularStop> resultStops = new ArrayList<RegularStop>();
    final List<Station> resultStations = new ArrayList<Station>();
    final Multimap<String, Station> resultStationByMultiModalStationRfs = ArrayListMultimap.create();

    StopAndStationMapper(FeedScopedIdFactory idFactory, ReadOnlyHierarchicalVersionMapById<Quay> quayIndex, TariffZoneMapper tariffZoneMapper, ZoneId defaultTimeZone, DataImportIssueStore issueStore, boolean noTransfersOnIsolatedStops) {
        this.stationMapper = new StationMapper(issueStore, idFactory, defaultTimeZone, noTransfersOnIsolatedStops);
        this.quayMapper = new QuayMapper(idFactory, issueStore);
        this.tariffZoneMapper = tariffZoneMapper;
        this.quayIndex = quayIndex;
        this.issueStore = issueStore;
    }

    void mapParentAndChildStops(Collection<StopPlace> stopPlaces) {
        List<StopPlace> stopPlaceAllVersions = this.sortStopPlacesByValidityAndVersionDesc(stopPlaces);
        StopPlace selectedStopPlace = StopAndStationMapper.first(stopPlaceAllVersions);
        Station station = this.mapStopPlaceAllVersionsToStation(selectedStopPlace);
        Collection<FareZone> fareZones = this.mapTariffZones(selectedStopPlace);
        T2<TransitMode, String> transitMode = this.stopPlaceTypeMapper.map(selectedStopPlace);
        for (StopPlace stopPlace : stopPlaceAllVersions) {
            for (Quay quay : this.listOfQuays(stopPlace)) {
                this.addStopToParentIfNotPresent(quay, station, fareZones, transitMode, selectedStopPlace);
            }
        }
    }

    private static StopPlace first(List<StopPlace> stops) {
        return stops.get(0);
    }

    private Station mapStopPlaceAllVersionsToStation(StopPlace stopPlace) {
        Station station = this.stationMapper.map(stopPlace);
        if (stopPlace.getParentSiteRef() != null) {
            this.resultStationByMultiModalStationRfs.put((Object)stopPlace.getParentSiteRef().getRef(), (Object)station);
        }
        this.resultStations.add(station);
        return station;
    }

    private Collection<FareZone> mapTariffZones(StopPlace stopPlace) {
        if (stopPlace.getTariffZones() == null) {
            return List.of();
        }
        return stopPlace.getTariffZones().getTariffZoneRef().stream().map(ref -> this.findTariffZone(stopPlace, (TariffZoneRef)ref)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private FareZone findTariffZone(StopPlace stopPlace, TariffZoneRef ref) {
        if (ref == null) {
            return null;
        }
        FareZone result = this.tariffZoneMapper.findAndMapTariffZone(ref);
        if (result == null) {
            this.issueStore.add(Issue.issue("StopPlaceMissingFareZone", "StopPlace %s has unsupported tariff zone reference: %s", stopPlace.getId(), ref));
        }
        return result;
    }

    private List<StopPlace> sortStopPlacesByValidityAndVersionDesc(Collection<StopPlace> stopPlaces) {
        return stopPlaces.stream().sorted(new StopPlaceVersionAndValidityComparator()).collect(Collectors.toList());
    }

    private void addStopToParentIfNotPresent(Quay quay, Station station, Collection<FareZone> fareZones, T2<TransitMode, String> transitMode, StopPlace stopPlace) {
        if (!this.quayIndex.isNewerOrSameVersionComparedWithExistingValues(quay)) {
            return;
        }
        if (this.quaysAlreadyProcessed.contains(quay.getId())) {
            return;
        }
        Accessibility wheelchair = this.wheelchairAccessibilityFromQuay(quay, stopPlace);
        RegularStop stop = this.quayMapper.mapQuayToStop(quay, station, fareZones, transitMode, wheelchair);
        if (stop == null) {
            return;
        }
        this.resultStops.add(stop);
        this.quaysAlreadyProcessed.add(quay.getId());
    }

    private List<Quay> listOfQuays(StopPlace stopPlace) {
        Quays_RelStructure quays = stopPlace.getQuays();
        if (quays == null) {
            this.issueStore.add(new StopPlaceWithoutQuays(stopPlace.getId()));
            return Collections.emptyList();
        }
        ArrayList<Quay> result = new ArrayList<Quay>();
        for (Object it : quays.getQuayRefOrQuay()) {
            if (it instanceof Quay) {
                result.add((Quay)it);
                continue;
            }
            this.issueStore.add(Issue.issue("StopPlaceWithoutQuays", "StopPlace %s has unsupported quay reference: %s", stopPlace.getId(), it));
        }
        return result;
    }

    private Accessibility wheelchairAccessibilityFromQuay(Quay quay, StopPlace stopPlace) {
        Accessibility defaultWheelChairBoarding = Accessibility.NO_INFORMATION;
        if (stopPlace != null) {
            defaultWheelChairBoarding = WheelChairMapper.wheelchairAccessibility(stopPlace.getAccessibilityAssessment(), Accessibility.NO_INFORMATION);
        }
        return WheelChairMapper.wheelchairAccessibility(quay.getAccessibilityAssessment(), defaultWheelChairBoarding);
    }
}

