/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.netex.mapping;

import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.opentripplanner.graph_builder.DataImportIssueStore;
import org.opentripplanner.model.impl.OtpTransitServiceBuilder;
import org.opentripplanner.model.transfer.ConstrainedTransfer;
import org.opentripplanner.netex.mapping.TransferMapper;
import org.opentripplanner.netex.mapping.support.FeedScopedIdFactory;
import org.rutebanken.netex.model.ServiceJourneyInterchange;

class GroupNetexMapper {
    private final FeedScopedIdFactory idFactory;
    private final DataImportIssueStore issueStore;
    private final OtpTransitServiceBuilder transitBuilder;
    private final List<ServiceJourneyInterchange> interchanges = new ArrayList<ServiceJourneyInterchange>();
    final ArrayListMultimap<String, String> scheduledStopPointsIndex = ArrayListMultimap.create();

    GroupNetexMapper(FeedScopedIdFactory idFactory, DataImportIssueStore issueStore, OtpTransitServiceBuilder transitBuilder) {
        this.idFactory = idFactory;
        this.issueStore = issueStore;
        this.transitBuilder = transitBuilder;
    }

    void addInterchange(Collection<ServiceJourneyInterchange> interchanges) {
        this.interchanges.addAll(interchanges);
    }

    void mapGroupEntries() {
        this.mapInterchanges();
    }

    private void mapInterchanges() {
        TransferMapper mapper = new TransferMapper(this.idFactory, this.issueStore, this.scheduledStopPointsIndex, this.transitBuilder.getTripsById());
        for (ServiceJourneyInterchange it : this.interchanges) {
            ConstrainedTransfer result = mapper.mapToTransfer(it);
            if (result == null) continue;
            this.transitBuilder.getTransfers().add(result);
        }
    }
}

