/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.netex.mapping;

import java.util.Collection;
import java.util.Optional;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.opentripplanner.common.geometry.HashGridSpatialIndex;
import org.opentripplanner.netex.mapping.OpenGisMapper;
import org.opentripplanner.netex.mapping.support.FeedScopedIdFactory;
import org.opentripplanner.transit.model.basic.NonLocalizedString;
import org.opentripplanner.transit.model.site.AreaStop;
import org.opentripplanner.transit.model.site.GroupStop;
import org.opentripplanner.transit.model.site.GroupStopBuilder;
import org.opentripplanner.transit.model.site.RegularStop;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.util.geometry.GeometryUtils;
import org.rutebanken.netex.model.FlexibleArea;
import org.rutebanken.netex.model.FlexibleStopPlace;
import org.rutebanken.netex.model.KeyValueStructure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FlexStopsMapper {
    private static final Logger LOG = LoggerFactory.getLogger(FlexStopsMapper.class);
    private static final String FLEXIBLE_STOP_AREA_TYPE_KEY = "FlexibleStopAreaType";
    private static final String UNRESTRICTED_PUBLIC_TRANSPORT_AREAS_VALUE = "UnrestrictedPublicTransportAreas";
    private final FeedScopedIdFactory idFactory;
    private final HashGridSpatialIndex<RegularStop> stopsSpatialIndex;

    FlexStopsMapper(FeedScopedIdFactory idFactory, Collection<RegularStop> stops) {
        this.idFactory = idFactory;
        this.stopsSpatialIndex = new HashGridSpatialIndex();
        for (RegularStop stop : stops) {
            Envelope env = new Envelope(stop.getCoordinate().asJtsCoordinate());
            this.stopsSpatialIndex.insert(env, (Object)stop);
        }
    }

    StopLocation map(FlexibleStopPlace flexibleStopPlace) {
        Object area = flexibleStopPlace.getAreas().getFlexibleAreaOrFlexibleAreaRefOrHailAndRideArea().get(0);
        if (!(area instanceof FlexibleArea)) {
            LOG.warn("FlexibleStopPlace {} not mapped. Hail and ride areas are not currently supported.", (Object)flexibleStopPlace.getId());
            return null;
        }
        Optional<Object> flexibleAreaType = Optional.empty();
        if (flexibleStopPlace.getKeyList() != null) {
            flexibleAreaType = flexibleStopPlace.getKeyList().getKeyValue().stream().filter(k -> k.getKey().equals(FLEXIBLE_STOP_AREA_TYPE_KEY)).findFirst();
        }
        if (flexibleAreaType.isPresent() && ((KeyValueStructure)flexibleAreaType.get()).getValue().equals(UNRESTRICTED_PUBLIC_TRANSPORT_AREAS_VALUE)) {
            return this.mapStopsInFlexArea(flexibleStopPlace, (FlexibleArea)area);
        }
        return this.mapFlexArea(flexibleStopPlace, (FlexibleArea)area);
    }

    AreaStop mapFlexArea(FlexibleStopPlace flexibleStopPlace, FlexibleArea area) {
        NonLocalizedString name = new NonLocalizedString(flexibleStopPlace.getName().getValue());
        return (AreaStop)AreaStop.of(this.idFactory.createId(flexibleStopPlace.getId())).withName(name).withGeometry(OpenGisMapper.mapGeometry(area.getPolygon())).build();
    }

    GroupStop mapStopsInFlexArea(FlexibleStopPlace flexibleStopPlace, FlexibleArea area) {
        GroupStopBuilder result = GroupStop.of(this.idFactory.createId(flexibleStopPlace.getId())).withName(new NonLocalizedString(flexibleStopPlace.getName().getValue()));
        Geometry geometry = OpenGisMapper.mapGeometry(area.getPolygon());
        for (RegularStop stop : this.stopsSpatialIndex.query(geometry.getEnvelopeInternal())) {
            Point p = GeometryUtils.getGeometryFactory().createPoint(stop.getCoordinate().asJtsCoordinate());
            if (!geometry.contains((Geometry)p)) continue;
            result.addLocation(stop);
        }
        return (GroupStop)result.build();
    }
}

