/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.netex.index;

import java.util.Collection;
import org.opentripplanner.netex.index.api.NetexEntityIndexReadOnlyView;
import org.opentripplanner.netex.index.api.ReadOnlyHierarchicalMap;
import org.opentripplanner.netex.index.api.ReadOnlyHierarchicalMapById;
import org.opentripplanner.netex.index.api.ReadOnlyHierarchicalVersionMapById;
import org.opentripplanner.netex.index.hierarchy.HierarchicalElement;
import org.opentripplanner.netex.index.hierarchy.HierarchicalMap;
import org.opentripplanner.netex.index.hierarchy.HierarchicalMapById;
import org.opentripplanner.netex.index.hierarchy.HierarchicalMultimap;
import org.opentripplanner.netex.index.hierarchy.HierarchicalVersionMapById;
import org.rutebanken.netex.model.Authority;
import org.rutebanken.netex.model.Branding;
import org.rutebanken.netex.model.DatedServiceJourney;
import org.rutebanken.netex.model.DayType;
import org.rutebanken.netex.model.DayTypeAssignment;
import org.rutebanken.netex.model.DestinationDisplay;
import org.rutebanken.netex.model.FlexibleLine;
import org.rutebanken.netex.model.FlexibleStopPlace;
import org.rutebanken.netex.model.GroupOfLines;
import org.rutebanken.netex.model.GroupOfStopPlaces;
import org.rutebanken.netex.model.JourneyPattern;
import org.rutebanken.netex.model.Line;
import org.rutebanken.netex.model.Network;
import org.rutebanken.netex.model.Notice;
import org.rutebanken.netex.model.NoticeAssignment;
import org.rutebanken.netex.model.OperatingDay;
import org.rutebanken.netex.model.OperatingPeriod;
import org.rutebanken.netex.model.Operator;
import org.rutebanken.netex.model.Quay;
import org.rutebanken.netex.model.Route;
import org.rutebanken.netex.model.ServiceJourney;
import org.rutebanken.netex.model.ServiceJourneyInterchange;
import org.rutebanken.netex.model.ServiceLink;
import org.rutebanken.netex.model.StopPlace;
import org.rutebanken.netex.model.TariffZone;

public class NetexEntityIndex {
    private final NetexEntityIndex parent;
    public final HierarchicalMapById<Authority> authoritiesById;
    public final HierarchicalMapById<DatedServiceJourney> datedServiceJourneys;
    public final HierarchicalMapById<DayType> dayTypeById;
    public final HierarchicalMultimap<String, DayTypeAssignment> dayTypeAssignmentByDayTypeId;
    public final HierarchicalMapById<DestinationDisplay> destinationDisplayById;
    public final HierarchicalMapById<FlexibleStopPlace> flexibleStopPlaceById;
    public final HierarchicalMapById<GroupOfLines> groupOfLinesById;
    public final HierarchicalMapById<GroupOfStopPlaces> groupOfStopPlacesById;
    public final HierarchicalMapById<JourneyPattern> journeyPatternsById;
    public final HierarchicalMapById<FlexibleLine> flexibleLineByid;
    public final HierarchicalMapById<Line> lineById;
    public final HierarchicalMapById<StopPlace> multiModalStopPlaceById;
    public final HierarchicalMapById<Network> networkById;
    public final HierarchicalMapById<Notice> noticeById;
    public final HierarchicalMapById<NoticeAssignment> noticeAssignmentById;
    public final HierarchicalMapById<OperatingDay> operatingDayById;
    public final HierarchicalMapById<OperatingPeriod> operatingPeriodById;
    public final HierarchicalMapById<Operator> operatorsById;
    public final HierarchicalVersionMapById<Quay> quayById;
    public final HierarchicalMap<String, String> flexibleStopPlaceByStopPointRef;
    public final HierarchicalMap<String, String> quayIdByStopPointRef;
    public final HierarchicalMapById<Route> routeById;
    public final HierarchicalMapById<ServiceJourney> serviceJourneyById;
    public final HierarchicalMapById<ServiceJourneyInterchange> serviceJourneyInterchangeById;
    public final HierarchicalMapById<ServiceLink> serviceLinkById;
    public final HierarchicalVersionMapById<StopPlace> stopPlaceById;
    public final HierarchicalVersionMapById<TariffZone> tariffZonesById;
    public final HierarchicalMapById<Branding> brandingById;
    public final HierarchicalMap<String, String> networkIdByGroupOfLineId;
    public final HierarchicalElement<String> timeZone;

    public NetexEntityIndex() {
        this.parent = null;
        this.authoritiesById = new HierarchicalMapById();
        this.dayTypeById = new HierarchicalMapById();
        this.dayTypeAssignmentByDayTypeId = new HierarchicalMultimap();
        this.datedServiceJourneys = new HierarchicalMapById();
        this.destinationDisplayById = new HierarchicalMapById();
        this.flexibleStopPlaceById = new HierarchicalMapById();
        this.groupOfLinesById = new HierarchicalMapById();
        this.groupOfStopPlacesById = new HierarchicalMapById();
        this.journeyPatternsById = new HierarchicalMapById();
        this.flexibleLineByid = new HierarchicalMapById();
        this.lineById = new HierarchicalMapById();
        this.multiModalStopPlaceById = new HierarchicalMapById();
        this.networkById = new HierarchicalMapById();
        this.networkIdByGroupOfLineId = new HierarchicalMap();
        this.noticeById = new HierarchicalMapById();
        this.noticeAssignmentById = new HierarchicalMapById();
        this.operatingDayById = new HierarchicalMapById();
        this.operatingPeriodById = new HierarchicalMapById();
        this.operatorsById = new HierarchicalMapById();
        this.quayById = new HierarchicalVersionMapById();
        this.flexibleStopPlaceByStopPointRef = new HierarchicalMap();
        this.quayIdByStopPointRef = new HierarchicalMap();
        this.routeById = new HierarchicalMapById();
        this.serviceJourneyById = new HierarchicalMapById();
        this.serviceLinkById = new HierarchicalMapById();
        this.serviceJourneyInterchangeById = new HierarchicalMapById();
        this.stopPlaceById = new HierarchicalVersionMapById();
        this.tariffZonesById = new HierarchicalVersionMapById();
        this.brandingById = new HierarchicalMapById();
        this.timeZone = new HierarchicalElement();
    }

    public NetexEntityIndex(NetexEntityIndex parent) {
        this.parent = parent;
        this.authoritiesById = new HierarchicalMapById(parent.authoritiesById);
        this.dayTypeById = new HierarchicalMapById(parent.dayTypeById);
        this.dayTypeAssignmentByDayTypeId = new HierarchicalMultimap<String, DayTypeAssignment>(parent.dayTypeAssignmentByDayTypeId);
        this.datedServiceJourneys = new HierarchicalMapById(parent.datedServiceJourneys);
        this.destinationDisplayById = new HierarchicalMapById(parent.destinationDisplayById);
        this.flexibleStopPlaceById = new HierarchicalMapById(parent.flexibleStopPlaceById);
        this.groupOfLinesById = new HierarchicalMapById(parent.groupOfLinesById);
        this.groupOfStopPlacesById = new HierarchicalMapById(parent.groupOfStopPlacesById);
        this.journeyPatternsById = new HierarchicalMapById(parent.journeyPatternsById);
        this.flexibleLineByid = new HierarchicalMapById(parent.flexibleLineByid);
        this.lineById = new HierarchicalMapById(parent.lineById);
        this.multiModalStopPlaceById = new HierarchicalMapById(parent.multiModalStopPlaceById);
        this.networkById = new HierarchicalMapById(parent.networkById);
        this.networkIdByGroupOfLineId = new HierarchicalMap<String, String>(parent.networkIdByGroupOfLineId);
        this.noticeById = new HierarchicalMapById(parent.noticeById);
        this.noticeAssignmentById = new HierarchicalMapById(parent.noticeAssignmentById);
        this.operatingDayById = new HierarchicalMapById(parent.operatingDayById);
        this.operatingPeriodById = new HierarchicalMapById(parent.operatingPeriodById);
        this.operatorsById = new HierarchicalMapById(parent.operatorsById);
        this.quayById = new HierarchicalVersionMapById<Quay>(parent.quayById);
        this.flexibleStopPlaceByStopPointRef = new HierarchicalMap<String, String>(parent.flexibleStopPlaceByStopPointRef);
        this.quayIdByStopPointRef = new HierarchicalMap<String, String>(parent.quayIdByStopPointRef);
        this.routeById = new HierarchicalMapById(parent.routeById);
        this.serviceJourneyById = new HierarchicalMapById(parent.serviceJourneyById);
        this.serviceLinkById = new HierarchicalMapById(parent.serviceLinkById);
        this.serviceJourneyInterchangeById = new HierarchicalMapById(parent.serviceJourneyInterchangeById);
        this.stopPlaceById = new HierarchicalVersionMapById<StopPlace>(parent.stopPlaceById);
        this.tariffZonesById = new HierarchicalVersionMapById<TariffZone>(parent.tariffZonesById);
        this.brandingById = new HierarchicalMapById(parent.brandingById);
        this.timeZone = new HierarchicalElement<String>(parent.timeZone);
    }

    public NetexEntityIndex push() {
        return new NetexEntityIndex(this);
    }

    public NetexEntityIndex pop() {
        return this.parent;
    }

    public NetexEntityIndexReadOnlyView readOnlyView() {
        return new NetexEntityIndexReadOnlyView(){

            @Override
            public Network lookupNetworkForLine(String groupOfLineOrNetworkId) {
                GroupOfLines groupOfLines = (GroupOfLines)NetexEntityIndex.this.groupOfLinesById.lookup(groupOfLineOrNetworkId);
                String networkId = groupOfLines == null ? groupOfLineOrNetworkId : (String)NetexEntityIndex.this.networkIdByGroupOfLineId.lookup(groupOfLines.getId());
                return (Network)NetexEntityIndex.this.networkById.lookup(networkId);
            }

            @Override
            public ReadOnlyHierarchicalMapById<GroupOfLines> getGroupsOfLinesById() {
                return NetexEntityIndex.this.groupOfLinesById;
            }

            @Override
            public ReadOnlyHierarchicalMapById<Authority> getAuthoritiesById() {
                return NetexEntityIndex.this.authoritiesById;
            }

            @Override
            public ReadOnlyHierarchicalMapById<DayType> getDayTypeById() {
                return NetexEntityIndex.this.dayTypeById;
            }

            @Override
            @Deprecated
            public ReadOnlyHierarchicalMap<String, Collection<DayTypeAssignment>> getDayTypeAssignmentByDayTypeId() {
                return NetexEntityIndex.this.dayTypeAssignmentByDayTypeId;
            }

            @Override
            public ReadOnlyHierarchicalMapById<DatedServiceJourney> getDatedServiceJourneys() {
                return NetexEntityIndex.this.datedServiceJourneys;
            }

            @Override
            public ReadOnlyHierarchicalMapById<DestinationDisplay> getDestinationDisplayById() {
                return NetexEntityIndex.this.destinationDisplayById;
            }

            @Override
            public ReadOnlyHierarchicalMapById<FlexibleStopPlace> getFlexibleStopPlacesById() {
                return NetexEntityIndex.this.flexibleStopPlaceById;
            }

            @Override
            public ReadOnlyHierarchicalMapById<GroupOfStopPlaces> getGroupOfStopPlacesById() {
                return NetexEntityIndex.this.groupOfStopPlacesById;
            }

            @Override
            public ReadOnlyHierarchicalMapById<JourneyPattern> getJourneyPatternsById() {
                return NetexEntityIndex.this.journeyPatternsById;
            }

            @Override
            public ReadOnlyHierarchicalMapById<FlexibleLine> getFlexibleLineById() {
                return NetexEntityIndex.this.flexibleLineByid;
            }

            @Override
            public ReadOnlyHierarchicalMapById<Line> getLineById() {
                return NetexEntityIndex.this.lineById;
            }

            @Override
            public ReadOnlyHierarchicalMapById<StopPlace> getMultiModalStopPlaceById() {
                return NetexEntityIndex.this.multiModalStopPlaceById;
            }

            @Override
            public ReadOnlyHierarchicalMapById<Notice> getNoticeById() {
                return NetexEntityIndex.this.noticeById;
            }

            @Override
            public ReadOnlyHierarchicalMapById<NoticeAssignment> getNoticeAssignmentById() {
                return NetexEntityIndex.this.noticeAssignmentById;
            }

            @Override
            public ReadOnlyHierarchicalMapById<OperatingDay> getOperatingDayById() {
                return NetexEntityIndex.this.operatingDayById;
            }

            @Override
            public ReadOnlyHierarchicalMapById<OperatingPeriod> getOperatingPeriodById() {
                return NetexEntityIndex.this.operatingPeriodById;
            }

            @Override
            public ReadOnlyHierarchicalMapById<Operator> getOperatorsById() {
                return NetexEntityIndex.this.operatorsById;
            }

            @Override
            public ReadOnlyHierarchicalVersionMapById<Quay> getQuayById() {
                return NetexEntityIndex.this.quayById;
            }

            @Override
            public ReadOnlyHierarchicalMap<String, String> getQuayIdByStopPointRef() {
                return NetexEntityIndex.this.quayIdByStopPointRef;
            }

            @Override
            public ReadOnlyHierarchicalMap<String, String> getFlexibleStopPlaceByStopPointRef() {
                return NetexEntityIndex.this.flexibleStopPlaceByStopPointRef;
            }

            @Override
            public ReadOnlyHierarchicalMapById<Route> getRouteById() {
                return NetexEntityIndex.this.routeById;
            }

            @Override
            public ReadOnlyHierarchicalMapById<ServiceJourney> getServiceJourneyById() {
                return NetexEntityIndex.this.serviceJourneyById;
            }

            @Override
            public ReadOnlyHierarchicalMapById<ServiceJourneyInterchange> getServiceJourneyInterchangeById() {
                return NetexEntityIndex.this.serviceJourneyInterchangeById;
            }

            @Override
            public ReadOnlyHierarchicalMapById<ServiceLink> getServiceLinkById() {
                return NetexEntityIndex.this.serviceLinkById;
            }

            @Override
            public ReadOnlyHierarchicalVersionMapById<StopPlace> getStopPlaceById() {
                return NetexEntityIndex.this.stopPlaceById;
            }

            @Override
            public ReadOnlyHierarchicalVersionMapById<TariffZone> getTariffZonesById() {
                return NetexEntityIndex.this.tariffZonesById;
            }

            @Override
            public ReadOnlyHierarchicalMapById<Branding> getBrandingById() {
                return NetexEntityIndex.this.brandingById;
            }

            @Override
            public String getTimeZone() {
                return NetexEntityIndex.this.timeZone.get();
            }
        };
    }
}

