/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model.transfer;

import java.io.Serializable;
import org.opentripplanner.model.transfer.TransferPoint;
import org.opentripplanner.transit.model.timetable.Trip;
import org.opentripplanner.util.lang.ValueObjectToStringBuilder;

public final class TripTransferPoint
implements TransferPoint,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Trip trip;
    private final int stopPositionInPattern;

    public TripTransferPoint(Trip trip, int stopPositionInPattern) {
        this.trip = trip;
        this.stopPositionInPattern = stopPositionInPattern;
    }

    public Trip getTrip() {
        return this.trip;
    }

    public int getStopPositionInPattern() {
        return this.stopPositionInPattern;
    }

    @Override
    public boolean appliesToAllTrips() {
        return false;
    }

    @Override
    public int getSpecificityRanking() {
        return 4;
    }

    @Override
    public boolean isTripTransferPoint() {
        return true;
    }

    public String toString() {
        return ValueObjectToStringBuilder.of().addText("TripTP{").addObj(this.trip.getId()).addText(", stopPos ").addNum(this.stopPositionInPattern).addText("}").toString();
    }
}

