/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model.transfer;

import java.io.Serializable;
import java.util.Objects;
import java.util.function.IntSupplier;
import javax.annotation.Nullable;
import org.opentripplanner.model.transfer.TransferPriority;
import org.opentripplanner.transit.raptor.api.transit.RaptorTransferConstraint;
import org.opentripplanner.transit.raptor.api.transit.SearchDirection;
import org.opentripplanner.util.OTPFeature;
import org.opentripplanner.util.lang.ToStringBuilder;

public class TransferConstraint
implements Serializable,
RaptorTransferConstraint {
    private static final long serialVersionUID = 1L;
    public static final TransferConstraint REGULAR_TRANSFER = TransferConstraint.create().build();
    private static final int STAY_SEATED_TRANSFER_COST = 1000;
    private static final int GUARANTIED_TRANSFER_COST = 2000;
    private static final int NONE_FACILITATED_COST = 3000;
    private static final int DEFAULT_COST = 3000 + TransferPriority.ALLOWED.cost();
    public static final int ZERO_COST = 0;
    public static final int NOT_SET = -1;
    private final TransferPriority priority;
    private final boolean staySeated;
    private final boolean guaranteed;
    private final int maxWaitTime;
    private final int minTransferTime;
    private final boolean includeInRaptorRouting;

    private TransferConstraint(Builder builder) {
        this.priority = builder.priority;
        this.staySeated = builder.staySeated;
        this.guaranteed = builder.guaranteed;
        this.maxWaitTime = builder.maxWaitTime;
        this.minTransferTime = builder.minTransferTime;
        boolean bl = this.includeInRaptorRouting = this.staySeated || this.guaranteed || this.priority == TransferPriority.NOT_ALLOWED || this.minTransferTime != -1;
        if (this.isMaxWaitTimeSet() && !this.guaranteed) {
            throw new IllegalArgumentException("'maxWaitTime' do only apply to guaranteed transfers.");
        }
    }

    public static int cost(@Nullable TransferConstraint c) {
        return c == null ? DEFAULT_COST : c.cost();
    }

    public static Builder create() {
        return new Builder();
    }

    public int cost() {
        return this.priority.cost() + this.facilitatedCost();
    }

    public TransferPriority getPriority() {
        return this.priority;
    }

    public boolean isGuaranteed() {
        return this.guaranteed;
    }

    public boolean isFacilitated() {
        return this.staySeated || this.guaranteed;
    }

    public boolean includeInRaptorRouting() {
        return this.includeInRaptorRouting;
    }

    @Override
    public boolean isNotAllowed() {
        return this.priority == TransferPriority.NOT_ALLOWED;
    }

    @Override
    public boolean isRegularTransfer() {
        return !this.isFacilitated() && !this.isMinTransferTimeSet() && !this.priority.isConstrained();
    }

    @Override
    public boolean isStaySeated() {
        return this.staySeated;
    }

    public int getMaxWaitTime() {
        return this.maxWaitTime;
    }

    public int getMinTransferTime() {
        return this.minTransferTime;
    }

    public boolean isMinTransferTimeSet() {
        return this.minTransferTime != -1;
    }

    public int calculateTransferTargetTime(int sourceTransitArrivalTime, int transferSlack, IntSupplier calcRegularTransferTargetTime, SearchDirection direction) {
        if (this.isFacilitated()) {
            return sourceTransitArrivalTime;
        }
        if (this.isMinTransferTimeSet()) {
            int minTransferTime = this.getMinTransferTime() + transferSlack;
            if (direction.isForward()) {
                int minTransferBoardTime = sourceTransitArrivalTime + minTransferTime;
                return OTPFeature.MinimumTransferTimeIsDefinitive.isOn() ? minTransferBoardTime : Math.max(minTransferBoardTime, calcRegularTransferTargetTime.getAsInt());
            }
            int minTransferBoardTime = sourceTransitArrivalTime - minTransferTime;
            return OTPFeature.MinimumTransferTimeIsDefinitive.isOn() ? minTransferBoardTime : Math.min(minTransferBoardTime, calcRegularTransferTargetTime.getAsInt());
        }
        return calcRegularTransferTargetTime.getAsInt();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.priority, this.staySeated, this.guaranteed, this.maxWaitTime});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TransferConstraint)) {
            return false;
        }
        TransferConstraint that = (TransferConstraint)o;
        return this.staySeated == that.staySeated && this.guaranteed == that.guaranteed && this.priority == that.priority && this.maxWaitTime == that.maxWaitTime;
    }

    public String toString() {
        if (this.isRegularTransfer()) {
            return "{no constraints}";
        }
        return ToStringBuilder.of().addEnum("priority", this.priority, TransferPriority.ALLOWED).addBoolIfTrue("staySeated", this.staySeated).addBoolIfTrue("guaranteed", this.guaranteed).addDurationSec("minTransferTime", this.minTransferTime, -1).addDurationSec("maxWaitTime", this.maxWaitTime, -1).toString();
    }

    private int facilitatedCost() {
        if (this.staySeated) {
            return 1000;
        }
        if (this.guaranteed) {
            return 2000;
        }
        return 3000;
    }

    private boolean isMaxWaitTimeSet() {
        return this.maxWaitTime != -1;
    }

    public static class Builder {
        private TransferPriority priority = TransferPriority.ALLOWED;
        private boolean staySeated = false;
        private boolean guaranteed = false;
        private int maxWaitTime = -1;
        private int minTransferTime = -1;

        public Builder priority(TransferPriority priority) {
            this.priority = priority;
            return this;
        }

        public Builder notAllowed() {
            return this.priority(TransferPriority.NOT_ALLOWED);
        }

        public Builder recommended() {
            return this.priority(TransferPriority.RECOMMENDED);
        }

        public Builder preferred() {
            return this.priority(TransferPriority.PREFERRED);
        }

        public Builder staySeated(boolean enable) {
            this.staySeated = enable;
            return this;
        }

        public Builder staySeated() {
            return this.staySeated(true);
        }

        public Builder guaranteed(boolean enable) {
            this.guaranteed = enable;
            return this;
        }

        public Builder guaranteed() {
            return this.guaranteed(true);
        }

        public Builder maxWaitTime(int maxWaitTime) {
            this.maxWaitTime = maxWaitTime;
            return this;
        }

        public Builder minTransferTime(int minTransferTime) {
            this.minTransferTime = minTransferTime;
            return this;
        }

        public TransferConstraint build() {
            return new TransferConstraint(this);
        }
    }
}

