/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model.transfer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import org.opentripplanner.model.transfer.ConstrainedTransfer;
import org.opentripplanner.model.transfer.TransferPoint;
import org.opentripplanner.model.transfer.TransferPointMap;
import org.opentripplanner.model.transfer.TransferService;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.model.timetable.Trip;

public class DefaultTransferService
implements Serializable,
TransferService {
    private final List<ConstrainedTransfer> transfersList = new ArrayList<ConstrainedTransfer>();
    private final TransferPointMap<TransferPointMap<ConstrainedTransfer>> transfersMap = new TransferPointMap();

    public void addAll(Collection<ConstrainedTransfer> transfers) {
        HashSet<ConstrainedTransfer> set = new HashSet<ConstrainedTransfer>(this.transfersList);
        for (ConstrainedTransfer transfer : transfers) {
            if (set.contains(transfer)) continue;
            this.add(transfer);
            set.add(transfer);
        }
    }

    @Override
    public List<ConstrainedTransfer> listAll() {
        return this.transfersList;
    }

    @Override
    @Nullable
    public ConstrainedTransfer findTransfer(Trip fromTrip, int fromStopPosition, StopLocation fromStop, Trip toTrip, int toStopPosition, StopLocation toStop) {
        return this.transfersMap.get(fromTrip, fromStop, fromStopPosition).stream().map(map2 -> map2.get(toTrip, toStop, toStopPosition)).flatMap(Collection::stream).max(Comparator.comparingInt(ConstrainedTransfer::getSpecificityRanking)).orElse(null);
    }

    private void add(ConstrainedTransfer transfer) {
        TransferPoint from = transfer.getFrom();
        TransferPoint to = transfer.getTo();
        this.transfersMap.computeIfAbsent(from, TransferPointMap::new).put(to, transfer);
        this.transfersList.add(transfer);
    }
}

