/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model.plan.pagecursor;

import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import javax.annotation.Nullable;
import org.opentripplanner.model.plan.SortOrder;
import org.opentripplanner.model.plan.pagecursor.PageCursor;
import org.opentripplanner.model.plan.pagecursor.PageType;
import org.opentripplanner.util.lang.ToStringBuilder;

public class PageCursorFactory {
    private final SortOrder sortOrder;
    private final Duration newSearchWindow;
    private PageType currentPageType;
    private SearchTime current = null;
    private Duration currentSearchWindow = null;
    private boolean wholeSwUsed = true;
    private Instant removedItineraryStartTime = null;
    private Instant removedItineraryEndTime = null;
    private PageCursor nextCursor = null;
    private PageCursor prevCursor = null;

    public PageCursorFactory(SortOrder sortOrder, Duration newSearchWindow) {
        this.sortOrder = sortOrder;
        this.newSearchWindow = newSearchWindow;
    }

    public PageCursorFactory withOriginalSearch(@Nullable PageType pageType, Instant edt, Instant lat, Duration searchWindow) {
        this.currentPageType = pageType == null ? PageCursorFactory.resolvePageTypeForTheFirstSearch(this.sortOrder) : pageType;
        this.current = new SearchTime(edt, lat);
        this.currentSearchWindow = searchWindow;
        return this;
    }

    public PageCursorFactory withRemovedItineraries(Instant startTime, Instant endTime) {
        this.wholeSwUsed = false;
        this.removedItineraryStartTime = startTime.truncatedTo(ChronoUnit.MINUTES);
        this.removedItineraryEndTime = endTime.plusSeconds(59L).truncatedTo(ChronoUnit.MINUTES);
        return this;
    }

    @Nullable
    public PageCursor previousPageCursor() {
        this.createPageCursors();
        return this.prevCursor;
    }

    @Nullable
    public PageCursor nextPageCursor() {
        this.createPageCursors();
        return this.nextCursor;
    }

    public String toString() {
        return ToStringBuilder.of(PageCursorFactory.class).addEnum("sortOrder", this.sortOrder).addEnum("currentPageType", this.currentPageType).addObj("current", this.current).addDuration("currentSearchWindow", this.currentSearchWindow).addDuration("newSearchWindow", this.newSearchWindow).addBoolIfTrue("searchWindowCropped", !this.wholeSwUsed).addDateTime("removedItineraryStartTime", this.removedItineraryStartTime).addDateTime("removedItineraryEndTime", this.removedItineraryEndTime).addObj("nextCursor", this.nextCursor).addObj("prevCursor", this.prevCursor).toString();
    }

    private static PageType resolvePageTypeForTheFirstSearch(SortOrder sortOrder) {
        return sortOrder.isSortedByArrivalTimeAcceding() ? PageType.NEXT_PAGE : PageType.PREVIOUS_PAGE;
    }

    private void createPageCursors() {
        if (this.current == null || this.nextCursor != null || this.prevCursor != null) {
            return;
        }
        SearchTime prev = new SearchTime(null, null);
        SearchTime next = new SearchTime(null, null);
        if (this.sortOrder.isSortedByArrivalTimeAcceding()) {
            if (this.currentPageType == PageType.NEXT_PAGE) {
                prev.edt = this.calcPrevSwStartRelativeToUsedSw();
                next.edt = this.wholeSwUsed ? this.calcNextSwStartRelativeToUsedSw() : this.removedItineraryStartTime;
            } else {
                if (this.wholeSwUsed) {
                    prev.edt = this.calcPrevSwStartRelativeToUsedSw();
                } else {
                    prev.edt = this.calcPrevSwStartRelativeToRmItinerary();
                    prev.lat = this.removedItineraryEndTime;
                }
                next.edt = this.calcNextSwStartRelativeToUsedSw();
            }
        } else if (this.currentPageType == PageType.PREVIOUS_PAGE) {
            if (this.wholeSwUsed) {
                prev.edt = this.calcPrevSwStartRelativeToUsedSw();
                prev.lat = this.current.lat;
            } else {
                prev.edt = this.calcPrevSwStartRelativeToRmItinerary();
                prev.lat = this.removedItineraryEndTime;
            }
            next.edt = this.calcNextSwStartRelativeToUsedSw();
        } else {
            prev.edt = this.calcPrevSwStartRelativeToUsedSw();
            prev.lat = this.current.lat;
            next.edt = this.wholeSwUsed ? this.calcNextSwStartRelativeToUsedSw() : this.removedItineraryStartTime;
        }
        this.prevCursor = new PageCursor(PageType.PREVIOUS_PAGE, this.sortOrder, prev.edt, prev.lat, this.newSearchWindow);
        this.nextCursor = new PageCursor(PageType.NEXT_PAGE, this.sortOrder, next.edt, next.lat, this.newSearchWindow);
    }

    private Instant calcPrevSwStartRelativeToRmItinerary() {
        return this.removedItineraryStartTime.minus(this.newSearchWindow).plusSeconds(60L);
    }

    private Instant calcPrevSwStartRelativeToUsedSw() {
        return this.current.edt.minus(this.newSearchWindow);
    }

    private Instant calcNextSwStartRelativeToUsedSw() {
        return this.current.edt.plus(this.currentSearchWindow);
    }

    private static class SearchTime {
        Instant edt;
        Instant lat;

        private SearchTime(Instant edt, Instant lat) {
            this.edt = edt;
            this.lat = lat;
        }

        public String toString() {
            return ToStringBuilder.of(SearchTime.class).addDateTime("edt", this.edt).addDateTime("lat", this.lat).toString();
        }
    }
}

