/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model.plan.legreference;

import java.time.LocalDate;
import java.time.ZoneId;
import org.opentripplanner.model.Timetable;
import org.opentripplanner.model.plan.ScheduledTransitLeg;
import org.opentripplanner.model.plan.legreference.LegReference;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.model.timetable.Trip;
import org.opentripplanner.transit.model.timetable.TripTimes;
import org.opentripplanner.transit.service.TransitService;
import org.opentripplanner.util.time.ServiceDateUtils;

public record ScheduledTransitLegReference(FeedScopedId tripId, LocalDate serviceDate, int fromStopPositionInPattern, int toStopPositionInPattern) implements LegReference
{
    @Override
    public ScheduledTransitLeg getLeg(TransitService transitService) {
        Trip trip = transitService.getTripForId(this.tripId);
        if (trip == null) {
            return null;
        }
        TripPattern tripPattern = transitService.getPatternForTrip(trip, this.serviceDate);
        if (tripPattern == null) {
            return null;
        }
        Timetable timetable = transitService.getTimetableForTripPattern(tripPattern, this.serviceDate);
        TripTimes tripTimes = timetable.getTripTimes(trip);
        ZoneId timeZone = transitService.getTimeZone();
        int boardingTime = tripTimes.getDepartureTime(this.fromStopPositionInPattern);
        int alightingTime = tripTimes.getArrivalTime(this.toStopPositionInPattern);
        return new ScheduledTransitLeg(tripTimes, tripPattern, this.fromStopPositionInPattern, this.toStopPositionInPattern, ServiceDateUtils.toZonedDateTime(this.serviceDate, timeZone, boardingTime), ServiceDateUtils.toZonedDateTime(this.serviceDate, timeZone, alightingTime), this.serviceDate, timeZone, null, null, 0, null);
    }
}

