/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model.plan;

import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.locationtech.jts.geom.LineString;
import org.opentripplanner.common.model.P2;
import org.opentripplanner.model.StreetNote;
import org.opentripplanner.model.plan.Leg;
import org.opentripplanner.model.plan.Place;
import org.opentripplanner.model.plan.StreetLegBuilder;
import org.opentripplanner.model.plan.WalkStep;
import org.opentripplanner.routing.core.TraverseMode;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.util.lang.DoubleUtils;
import org.opentripplanner.util.lang.ToStringBuilder;

public class StreetLeg
implements Leg {
    private final TraverseMode mode;
    private final ZonedDateTime startTime;
    private final ZonedDateTime endTime;
    private final double distanceMeters;
    private final Place from;
    private final Place to;
    private final int generalizedCost;
    private final Double elevationLost;
    private final Double elevationGained;
    private final LineString legGeometry;
    private final List<WalkStep> walkSteps;
    private final Set<StreetNote> streetNotes;
    private final List<P2<Double>> legElevation;
    private final FeedScopedId pathwayId;
    private final Boolean walkingBike;
    private final Boolean rentedVehicle;
    private final String vehicleRentalNetwork;
    private final Float accessibilityScore;

    public StreetLeg(StreetLegBuilder builder) {
        this.mode = Objects.requireNonNull(builder.getMode());
        this.startTime = builder.getStartTime();
        this.endTime = builder.getEndTime();
        this.distanceMeters = DoubleUtils.roundTo2Decimals(builder.getDistanceMeters());
        this.from = builder.getFrom();
        this.to = builder.getTo();
        this.generalizedCost = builder.getGeneralizedCost();
        this.legElevation = builder.getElevation();
        this.legGeometry = builder.getGeometry();
        this.walkSteps = builder.getWalkSteps();
        this.elevationGained = StreetLeg.calculateElevationGained(this.legElevation);
        this.elevationLost = StreetLeg.calculateElevationLost(this.legElevation);
        this.streetNotes = Set.copyOf(builder.getStreetNotes());
        this.pathwayId = builder.getPathwayId();
        this.walkingBike = builder.getWalkingBike();
        this.rentedVehicle = builder.getRentedVehicle();
        this.vehicleRentalNetwork = builder.getVehicleRentalNetwork();
        this.accessibilityScore = builder.getAccessibilityScore();
    }

    public static StreetLegBuilder create() {
        return new StreetLegBuilder();
    }

    @Override
    public boolean isTransitLeg() {
        return false;
    }

    @Override
    public boolean isWalkingLeg() {
        return this.mode == TraverseMode.WALK;
    }

    @Override
    public boolean isStreetLeg() {
        return true;
    }

    public TraverseMode getMode() {
        return this.mode;
    }

    @Override
    public ZonedDateTime getStartTime() {
        return this.startTime;
    }

    @Override
    public ZonedDateTime getEndTime() {
        return this.endTime;
    }

    @Override
    public double getDistanceMeters() {
        return this.distanceMeters;
    }

    @Override
    public FeedScopedId getPathwayId() {
        return this.pathwayId;
    }

    @Override
    public Place getFrom() {
        return this.from;
    }

    @Override
    public Place getTo() {
        return this.to;
    }

    @Override
    public LineString getLegGeometry() {
        return this.legGeometry;
    }

    List<P2<Double>> getRawLegElevation() {
        return this.legElevation;
    }

    @Override
    public List<P2<Double>> getRoundedLegElevation() {
        return StreetLeg.normalizeElevation(this.legElevation);
    }

    @Override
    public Double getElevationGained() {
        return this.elevationGained;
    }

    @Override
    public Double getElevationLost() {
        return this.elevationLost;
    }

    @Override
    public List<WalkStep> getWalkSteps() {
        return this.walkSteps;
    }

    @Override
    public Set<StreetNote> getStreetNotes() {
        return this.streetNotes;
    }

    @Override
    public Boolean getWalkingBike() {
        return this.walkingBike;
    }

    @Override
    @Nullable
    public Float accessibilityScore() {
        return this.accessibilityScore;
    }

    @Override
    public Boolean getRentedVehicle() {
        return this.rentedVehicle;
    }

    @Override
    public String getVehicleRentalNetwork() {
        return this.vehicleRentalNetwork;
    }

    @Override
    public int getGeneralizedCost() {
        return this.generalizedCost;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean hasSameMode(Leg other) {
        if (!(other instanceof StreetLeg)) return false;
        StreetLeg oSL = (StreetLeg)other;
        if (!this.mode.equals((Object)oSL.mode)) return false;
        return true;
    }

    @Override
    public Leg withTimeShift(Duration duration) {
        return StreetLegBuilder.of(this).withStartTime(this.startTime.plus(duration)).withEndTime(this.endTime.plus(duration)).build();
    }

    public StreetLeg withAccessibilityScore(float accessibilityScore) {
        return StreetLegBuilder.of(this).withAccessibilityScore(Float.valueOf(accessibilityScore)).build();
    }

    public String toString() {
        return ToStringBuilder.of(StreetLeg.class).addObj("from", this.from).addObj("to", this.to).addTime("startTime", this.startTime).addTime("endTime", this.endTime).addEnum("mode", this.mode).addNum("distance", (Number)this.distanceMeters, "m").addNum("cost", this.generalizedCost).addObj("gtfsPathwayId", this.pathwayId).addObj("legGeometry", this.legGeometry).addStr("legElevation", this.legElevation != null ? this.legElevation.toString() : null).addNum("elevationGained", (Number)this.elevationGained, "m").addNum("elevationLost", (Number)this.elevationLost, "m").addCol("walkSteps", this.walkSteps).addCol("streetNotes", this.streetNotes).addBool("walkingBike", this.walkingBike).addBool("rentedVehicle", this.rentedVehicle).addStr("bikeRentalNetwork", this.vehicleRentalNetwork).toString();
    }

    static List<P2<Double>> normalizeElevation(List<P2<Double>> elevation) {
        return elevation == null ? null : elevation.stream().map(it -> new P2<Double>(DoubleUtils.roundTo2Decimals((Double)it.first), DoubleUtils.roundTo2Decimals((Double)it.second))).toList();
    }

    private static Double calculateElevationGained(List<P2<Double>> legElevation) {
        return StreetLeg.calculateElevationChange(legElevation, v -> v > 0.0);
    }

    private static Double calculateElevationLost(List<P2<Double>> legElevation) {
        return StreetLeg.calculateElevationChange(legElevation, v -> v < 0.0);
    }

    private static Double calculateElevationChange(List<P2<Double>> legElevation, Predicate<Double> elevationFilter) {
        if (legElevation == null) {
            return null;
        }
        double sum = 0.0;
        Double lastElevation = null;
        for (P2<Double> p2 : legElevation) {
            double change;
            double elevation = (Double)p2.second;
            if (lastElevation != null && elevationFilter.test(change = elevation - lastElevation)) {
                sum += Math.abs(change);
            }
            lastElevation = elevation;
        }
        return DoubleUtils.roundTo2Decimals(sum);
    }
}

