/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model.plan;

public enum RelativeDirection {
    DEPART,
    HARD_LEFT,
    LEFT,
    SLIGHTLY_LEFT,
    CONTINUE,
    SLIGHTLY_RIGHT,
    RIGHT,
    HARD_RIGHT,
    CIRCLE_CLOCKWISE,
    CIRCLE_COUNTERCLOCKWISE,
    ELEVATOR,
    UTURN_LEFT,
    UTURN_RIGHT;


    public static RelativeDirection calculate(double lastAngle, double thisAngle, boolean roundabout) {
        return RelativeDirection.calculate(thisAngle - lastAngle, roundabout);
    }

    public static RelativeDirection calculate(double angle, boolean roundabout) {
        double cwAngle = angle;
        if (cwAngle < 0.0) {
            cwAngle += Math.PI * 2;
        }
        double ccwAngle = Math.PI * 2 - cwAngle;
        if (roundabout) {
            if (cwAngle > ccwAngle) {
                return CIRCLE_CLOCKWISE;
            }
            return CIRCLE_COUNTERCLOCKWISE;
        }
        if (cwAngle < 0.3 || ccwAngle < 0.3) {
            return CONTINUE;
        }
        if (cwAngle < 0.7) {
            return SLIGHTLY_RIGHT;
        }
        if (ccwAngle < 0.7) {
            return SLIGHTLY_LEFT;
        }
        if (cwAngle < 2.0) {
            return RIGHT;
        }
        if (ccwAngle < 2.0) {
            return LEFT;
        }
        if (cwAngle < Math.PI) {
            return HARD_RIGHT;
        }
        return HARD_LEFT;
    }
}

