/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model.plan;

import org.opentripplanner.model.plan.VehicleParkingWithEntrance;
import org.opentripplanner.model.plan.VertexType;
import org.opentripplanner.routing.api.request.preference.RoutingPreferences;
import org.opentripplanner.routing.core.State;
import org.opentripplanner.routing.core.TraverseMode;
import org.opentripplanner.routing.graph.Vertex;
import org.opentripplanner.routing.vehicle_rental.VehicleRentalPlace;
import org.opentripplanner.routing.vertextype.StreetVertex;
import org.opentripplanner.routing.vertextype.VehicleParkingEntranceVertex;
import org.opentripplanner.routing.vertextype.VehicleRentalPlaceVertex;
import org.opentripplanner.transit.model.basic.I18NString;
import org.opentripplanner.transit.model.basic.LocalizedString;
import org.opentripplanner.transit.model.basic.WgsCoordinate;
import org.opentripplanner.transit.model.site.AreaStop;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.util.lang.ToStringBuilder;

public class Place {
    public final I18NString name;
    public final WgsCoordinate coordinate;
    public final VertexType vertexType;
    public final StopLocation stop;
    public final VehicleRentalPlace vehicleRentalPlace;
    public final VehicleParkingWithEntrance vehicleParkingWithEntrance;

    private Place(I18NString name, WgsCoordinate coordinate, VertexType vertexType, StopLocation stop, VehicleRentalPlace vehicleRentalPlace, VehicleParkingWithEntrance vehicleParkingWithEntrance) {
        this.name = name;
        this.coordinate = coordinate;
        this.vertexType = vertexType;
        this.stop = stop;
        this.vehicleRentalPlace = vehicleRentalPlace;
        this.vehicleParkingWithEntrance = vehicleParkingWithEntrance;
    }

    public static Place normal(Double lat, Double lon, I18NString name) {
        return new Place(name, WgsCoordinate.creatOptionalCoordinate(lat, lon), VertexType.NORMAL, null, null, null);
    }

    public static Place normal(Vertex vertex, I18NString name) {
        return new Place(name, WgsCoordinate.creatOptionalCoordinate(vertex.getLat(), vertex.getLon()), VertexType.NORMAL, null, null, null);
    }

    public static Place forStop(StopLocation stop) {
        return new Place(stop.getName(), stop.getCoordinate(), VertexType.TRANSIT, stop, null, null);
    }

    public static Place forFlexStop(StopLocation stop, Vertex vertex) {
        I18NString name = stop.getName();
        if (stop instanceof AreaStop) {
            AreaStop flexArea = (AreaStop)stop;
            if (vertex instanceof StreetVertex) {
                StreetVertex s = (StreetVertex)vertex;
                name = flexArea.hasFallbackName() ? s.getIntersectionName() : new LocalizedString("partOf", s.getIntersectionName(), flexArea.getName());
            }
        }
        return new Place(name, WgsCoordinate.creatOptionalCoordinate(vertex.getLat(), vertex.getLon()), VertexType.TRANSIT, stop, null, null);
    }

    public static Place forVehicleRentalPlace(VehicleRentalPlaceVertex vertex) {
        return new Place(vertex.getName(), WgsCoordinate.creatOptionalCoordinate(vertex.getLat(), vertex.getLon()), VertexType.VEHICLERENTAL, null, vertex.getStation(), null);
    }

    public static Place forVehicleParkingEntrance(VehicleParkingEntranceVertex vertex, State state) {
        TraverseMode traverseMode = null;
        if (state.getRequest().mode().includesDriving()) {
            traverseMode = TraverseMode.CAR;
        } else if (state.getRequest().mode().includesBiking()) {
            traverseMode = TraverseMode.BICYCLE;
        }
        RoutingPreferences preferences = state.getPreferences();
        boolean realTime = preferences.parking().useAvailabilityInformation() && vertex.getVehicleParking().hasRealTimeDataForMode(traverseMode, state.getRequest().wheelchair());
        return new Place(vertex.getName(), WgsCoordinate.creatOptionalCoordinate(vertex.getLat(), vertex.getLon()), VertexType.VEHICLEPARKING, null, null, VehicleParkingWithEntrance.builder().vehicleParking(vertex.getVehicleParking()).entrance(vertex.getParkingEntrance()).realtime(realTime).build());
    }

    public boolean sameLocation(Place other) {
        if (this == other) {
            return true;
        }
        if (this.coordinate != null) {
            return this.coordinate.sameLocation(other.coordinate);
        }
        return this.stop != null && this.stop.equals(other.stop);
    }

    public String toStringShort() {
        StringBuilder buf = new StringBuilder(this.name.toString());
        if (this.stop != null) {
            buf.append(" (").append(this.stop.getId()).append(")");
        } else {
            buf.append(" ").append(this.coordinate.toString());
        }
        return buf.toString();
    }

    public String toString() {
        return ToStringBuilder.of(Place.class).addStr("name", this.name.toString()).addObj("stop", this.stop).addObj("coordinate", this.coordinate).addEnum("vertexType", this.vertexType).addObj("vehicleRentalPlace", this.vehicleRentalPlace).addObj("vehicleParkingEntrance", this.vehicleParkingWithEntrance).toString();
    }
}

