/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model.plan;

import java.time.Duration;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.locationtech.jts.geom.LineString;
import org.opentripplanner.common.model.P2;
import org.opentripplanner.model.BookingInfo;
import org.opentripplanner.model.PickDrop;
import org.opentripplanner.model.StreetNote;
import org.opentripplanner.model.plan.Place;
import org.opentripplanner.model.plan.ScheduledTransitLeg;
import org.opentripplanner.model.plan.StopArrival;
import org.opentripplanner.model.plan.WalkStep;
import org.opentripplanner.model.plan.legreference.LegReference;
import org.opentripplanner.model.transfer.ConstrainedTransfer;
import org.opentripplanner.routing.alertpatch.TransitAlert;
import org.opentripplanner.transit.model.basic.Accessibility;
import org.opentripplanner.transit.model.basic.I18NString;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.network.Route;
import org.opentripplanner.transit.model.organization.Agency;
import org.opentripplanner.transit.model.organization.Operator;
import org.opentripplanner.transit.model.site.FareZone;
import org.opentripplanner.transit.model.timetable.Trip;

public interface Leg {
    public boolean isTransitLeg();

    default public boolean isScheduledTransitLeg() {
        return false;
    }

    default public ScheduledTransitLeg asScheduledTransitLeg() {
        throw new ClassCastException();
    }

    default public Boolean isInterlinedWithPreviousLeg() {
        return false;
    }

    default public boolean isWalkingLeg() {
        return false;
    }

    default public boolean isStreetLeg() {
        return false;
    }

    default public Duration getDuration() {
        return Duration.between(this.getStartTime(), this.getEndTime());
    }

    default public boolean isPartiallySameTransitLeg(Leg other) {
        if (!this.isTransitLeg() || !other.isTransitLeg()) {
            throw new IllegalStateException();
        }
        if (!this.getServiceDate().equals(other.getServiceDate())) {
            return false;
        }
        if (!this.getTrip().getId().equals(other.getTrip().getId())) {
            return false;
        }
        return this.getBoardStopPosInPattern() < other.getAlightStopPosInPattern() && this.getAlightStopPosInPattern() > other.getBoardStopPosInPattern();
    }

    public boolean hasSameMode(Leg var1);

    default public boolean isPartiallySameLeg(Leg other) {
        if (!this.hasSameMode(other)) {
            return false;
        }
        if (!this.overlapInTime(other)) {
            return false;
        }
        if (this.isStreetLeg()) {
            return true;
        }
        if (!this.getTrip().getId().equals(other.getTrip().getId())) {
            return false;
        }
        return this.getBoardStopPosInPattern() < other.getAlightStopPosInPattern() && this.getAlightStopPosInPattern() > other.getBoardStopPosInPattern();
    }

    default public boolean overlapInTime(Leg other) {
        return this.getStartTime().toEpochSecond() < other.getEndTime().toEpochSecond() && other.getStartTime().toEpochSecond() < this.getEndTime().toEpochSecond();
    }

    default public Agency getAgency() {
        return null;
    }

    default public Operator getOperator() {
        return null;
    }

    default public Route getRoute() {
        return null;
    }

    default public Trip getTrip() {
        return null;
    }

    default public Accessibility getTripWheelchairAccessibility() {
        return null;
    }

    public ZonedDateTime getStartTime();

    public ZonedDateTime getEndTime();

    default public int getDepartureDelay() {
        return 0;
    }

    default public int getArrivalDelay() {
        return 0;
    }

    default public boolean getRealTime() {
        return false;
    }

    default public boolean isFlexibleTrip() {
        return false;
    }

    default public Boolean getNonExactFrequency() {
        return null;
    }

    default public Integer getHeadway() {
        return null;
    }

    public double getDistanceMeters();

    default public FeedScopedId getPathwayId() {
        return null;
    }

    default public int getAgencyTimeZoneOffset() {
        int MILLIS_TO_SECONDS = 1000;
        return this.getStartTime().getOffset().getTotalSeconds() * MILLIS_TO_SECONDS;
    }

    default public Integer getRouteType() {
        return null;
    }

    default public I18NString getHeadsign() {
        return null;
    }

    default public LocalDate getServiceDate() {
        return null;
    }

    default public String getRouteBrandingUrl() {
        return null;
    }

    public Place getFrom();

    public Place getTo();

    default public List<StopArrival> getIntermediateStops() {
        return null;
    }

    public LineString getLegGeometry();

    default public List<P2<Double>> getRoundedLegElevation() {
        return null;
    }

    default public Double getElevationGained() {
        return null;
    }

    default public Double getElevationLost() {
        return null;
    }

    default public List<WalkStep> getWalkSteps() {
        return List.of();
    }

    default public Set<StreetNote> getStreetNotes() {
        return null;
    }

    default public Set<TransitAlert> getTransitAlerts() {
        return Set.of();
    }

    default public PickDrop getBoardRule() {
        return null;
    }

    default public PickDrop getAlightRule() {
        return null;
    }

    default public BookingInfo getDropOffBookingInfo() {
        return null;
    }

    default public BookingInfo getPickupBookingInfo() {
        return null;
    }

    default public ConstrainedTransfer getTransferFromPrevLeg() {
        return null;
    }

    default public ConstrainedTransfer getTransferToNextLeg() {
        return null;
    }

    default public Integer getBoardStopPosInPattern() {
        return null;
    }

    default public Integer getAlightStopPosInPattern() {
        return null;
    }

    default public Integer getBoardingGtfsStopSequence() {
        return null;
    }

    default public Integer getAlightGtfsStopSequence() {
        return null;
    }

    default public Boolean getWalkingBike() {
        return null;
    }

    @Nullable
    default public Float accessibilityScore() {
        return null;
    }

    default public Boolean getRentedVehicle() {
        return null;
    }

    default public String getVehicleRentalNetwork() {
        return null;
    }

    public int getGeneralizedCost();

    default public LegReference getLegReference() {
        return null;
    }

    default public void addAlert(TransitAlert alert) {
        throw new UnsupportedOperationException();
    }

    default public Leg withTimeShift(Duration duration) {
        throw new UnsupportedOperationException();
    }

    default public Set<FareZone> getFareZones() {
        Stream intermediate = this.getIntermediateStops().stream().flatMap(stopArrival -> stopArrival.place.stop.getFareZones().stream());
        Stream<FareZone> start = Leg.getFareZones(this.getFrom());
        Stream<FareZone> end = Leg.getFareZones(this.getTo());
        return Stream.of(intermediate, start, end).flatMap(s -> s).collect(Collectors.toSet());
    }

    private static Stream<FareZone> getFareZones(Place place) {
        if (place.stop == null) {
            return Stream.empty();
        }
        return place.stop.getFareZones().stream();
    }
}

