/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model.impl;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opentripplanner.ext.flex.trip.FlexTrip;
import org.opentripplanner.graph_builder.DataImportIssueStore;
import org.opentripplanner.gtfs.mapping.StaySeatedNotAllowed;
import org.opentripplanner.model.FeedInfo;
import org.opentripplanner.model.Frequency;
import org.opentripplanner.model.OtpTransitService;
import org.opentripplanner.model.ShapePoint;
import org.opentripplanner.model.TripStopTimes;
import org.opentripplanner.model.calendar.CalendarServiceData;
import org.opentripplanner.model.calendar.ServiceCalendar;
import org.opentripplanner.model.calendar.ServiceCalendarDate;
import org.opentripplanner.model.calendar.ServiceDateInterval;
import org.opentripplanner.model.calendar.impl.CalendarServiceDataFactoryImpl;
import org.opentripplanner.model.impl.OtpTransitServiceImpl;
import org.opentripplanner.model.transfer.ConstrainedTransfer;
import org.opentripplanner.model.transfer.TransferPoint;
import org.opentripplanner.transit.model.basic.Notice;
import org.opentripplanner.transit.model.framework.AbstractTransitEntity;
import org.opentripplanner.transit.model.framework.EntityById;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.network.GroupOfRoutes;
import org.opentripplanner.transit.model.network.Route;
import org.opentripplanner.transit.model.network.StopPattern;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.model.organization.Agency;
import org.opentripplanner.transit.model.organization.Branding;
import org.opentripplanner.transit.model.organization.Operator;
import org.opentripplanner.transit.model.site.AreaStop;
import org.opentripplanner.transit.model.site.BoardingArea;
import org.opentripplanner.transit.model.site.Entrance;
import org.opentripplanner.transit.model.site.FareZone;
import org.opentripplanner.transit.model.site.GroupOfStations;
import org.opentripplanner.transit.model.site.GroupStop;
import org.opentripplanner.transit.model.site.MultiModalStation;
import org.opentripplanner.transit.model.site.Pathway;
import org.opentripplanner.transit.model.site.PathwayNode;
import org.opentripplanner.transit.model.site.RegularStop;
import org.opentripplanner.transit.model.site.Station;
import org.opentripplanner.transit.model.timetable.Trip;
import org.opentripplanner.transit.model.timetable.TripOnServiceDate;
import org.opentripplanner.transit.service.StopModel;
import org.opentripplanner.transit.service.StopModelBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OtpTransitServiceBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(OtpTransitServiceBuilder.class);
    private final EntityById<Agency> agenciesById = new EntityById();
    private final List<ServiceCalendarDate> calendarDates = new ArrayList<ServiceCalendarDate>();
    private final List<ServiceCalendar> calendars = new ArrayList<ServiceCalendar>();
    private final List<FeedInfo> feedInfos = new ArrayList<FeedInfo>();
    private final List<Frequency> frequencies = new ArrayList<Frequency>();
    private final StopModelBuilder stopModelBuilder;
    private final Multimap<AbstractTransitEntity, Notice> noticeAssignments = ArrayListMultimap.create();
    private final EntityById<Operator> operatorsById = new EntityById();
    private final List<Pathway> pathways = new ArrayList<Pathway>();
    private final EntityById<Route> routesById = new EntityById();
    private final Multimap<FeedScopedId, ShapePoint> shapePoints = ArrayListMultimap.create();
    private final EntityById<Entrance> entrancesById = new EntityById();
    private final EntityById<PathwayNode> pathwayNodesById = new EntityById();
    private final EntityById<BoardingArea> boardingAreasById = new EntityById();
    private final TripStopTimes stopTimesByTrip = new TripStopTimes();
    private final EntityById<FareZone> fareZonesById = new EntityById();
    private final List<ConstrainedTransfer> transfers = new ArrayList<ConstrainedTransfer>();
    private final List<StaySeatedNotAllowed> staySeatedNotAllowed = new ArrayList<StaySeatedNotAllowed>();
    private final EntityById<Trip> tripsById = new EntityById();
    private final Multimap<StopPattern, TripPattern> tripPatterns = ArrayListMultimap.create();
    private final EntityById<FlexTrip<?, ?>> flexTripsById = new EntityById();
    private final EntityById<Branding> brandingsById = new EntityById();
    private final Multimap<FeedScopedId, GroupOfRoutes> groupsOfRoutesByRouteId = ArrayListMultimap.create();
    private final EntityById<TripOnServiceDate> tripOnServiceDates = new EntityById();
    private final EntityById<GroupOfRoutes> groupOfRouteById = new EntityById();
    private final DataImportIssueStore issueStore;

    public OtpTransitServiceBuilder(DataImportIssueStore issueStore) {
        this.stopModelBuilder = StopModel.of();
        this.issueStore = issueStore;
    }

    public EntityById<Agency> getAgenciesById() {
        return this.agenciesById;
    }

    public List<ServiceCalendarDate> getCalendarDates() {
        return this.calendarDates;
    }

    public List<ServiceCalendar> getCalendars() {
        return this.calendars;
    }

    public List<FeedInfo> getFeedInfos() {
        return this.feedInfos;
    }

    public List<Frequency> getFrequencies() {
        return this.frequencies;
    }

    public StopModelBuilder stopModelBuilder() {
        return this.stopModelBuilder;
    }

    public EntityById<GroupOfStations> getGroupsOfStationsById() {
        return this.stopModelBuilder().groupOfStationById();
    }

    public EntityById<MultiModalStation> getMultiModalStationsById() {
        return this.stopModelBuilder().multiModalStationById();
    }

    public Multimap<AbstractTransitEntity, Notice> getNoticeAssignments() {
        return this.noticeAssignments;
    }

    public EntityById<Operator> getOperatorsById() {
        return this.operatorsById;
    }

    public List<Pathway> getPathways() {
        return this.pathways;
    }

    public EntityById<Route> getRoutes() {
        return this.routesById;
    }

    public Multimap<FeedScopedId, ShapePoint> getShapePoints() {
        return this.shapePoints;
    }

    public EntityById<Station> getStations() {
        return this.stopModelBuilder().stationById();
    }

    public EntityById<RegularStop> getStops() {
        return this.stopModelBuilder().regularStopsById();
    }

    public EntityById<Entrance> getEntrances() {
        return this.entrancesById;
    }

    public EntityById<PathwayNode> getPathwayNodes() {
        return this.pathwayNodesById;
    }

    public EntityById<BoardingArea> getBoardingAreas() {
        return this.boardingAreasById;
    }

    public EntityById<AreaStop> getAreaStops() {
        return this.stopModelBuilder().areaStopById();
    }

    public EntityById<GroupStop> getGroupStops() {
        return this.stopModelBuilder().groupStopById();
    }

    public TripStopTimes getStopTimesSortedByTrip() {
        return this.stopTimesByTrip;
    }

    public EntityById<FareZone> getFareZonesById() {
        return this.fareZonesById;
    }

    public List<ConstrainedTransfer> getTransfers() {
        return this.transfers;
    }

    public List<StaySeatedNotAllowed> getStaySeatedNotAllowed() {
        return this.staySeatedNotAllowed;
    }

    public EntityById<Trip> getTripsById() {
        return this.tripsById;
    }

    public Multimap<StopPattern, TripPattern> getTripPatterns() {
        return this.tripPatterns;
    }

    public EntityById<FlexTrip<?, ?>> getFlexTripsById() {
        return this.flexTripsById;
    }

    public EntityById<Branding> getBrandingsById() {
        return this.brandingsById;
    }

    public Multimap<FeedScopedId, GroupOfRoutes> getGroupsOfRoutesByRouteId() {
        return this.groupsOfRoutesByRouteId;
    }

    public EntityById<GroupOfRoutes> getGroupOfRouteById() {
        return this.groupOfRouteById;
    }

    public EntityById<TripOnServiceDate> getTripOnServiceDates() {
        return this.tripOnServiceDates;
    }

    public CalendarServiceData buildCalendarServiceData() {
        return CalendarServiceDataFactoryImpl.createCalendarServiceData(this.getCalendarDates(), this.getCalendars());
    }

    public OtpTransitService build() {
        return new OtpTransitServiceImpl(this);
    }

    public void limitServiceDays(ServiceDateInterval periodLimit) {
        if (periodLimit.isUnbounded()) {
            LOG.info("Limiting transit service is skipped, the period is unbounded.");
            return;
        }
        LOG.warn("Limiting transit service days to time period: {}", (Object)periodLimit);
        int orgSize = this.calendarDates.size();
        this.calendarDates.removeIf(c -> !periodLimit.include(c.getDate()));
        OtpTransitServiceBuilder.logRemove("ServiceCalendarDate", orgSize, this.calendarDates.size(), "Outside time period.");
        ArrayList<ServiceCalendar> keepCal = new ArrayList<ServiceCalendar>();
        for (ServiceCalendar calendar : this.calendars) {
            if (!calendar.getPeriod().overlap(periodLimit)) continue;
            calendar.setPeriod(calendar.getPeriod().intersection(periodLimit));
            keepCal.add(calendar);
        }
        orgSize = this.calendars.size();
        if (orgSize != keepCal.size()) {
            this.calendars.clear();
            this.calendars.addAll(keepCal);
            OtpTransitServiceBuilder.logRemove("ServiceCalendar", orgSize, this.calendars.size(), "Outside time period.");
        }
        this.removeEntitiesWithInvalidReferences();
        LOG.info("Limiting transit service days to time period complete.");
    }

    Set<FeedScopedId> findAllServiceIds() {
        HashSet<FeedScopedId> serviceIds = new HashSet<FeedScopedId>();
        for (ServiceCalendar calendar : this.getCalendars()) {
            serviceIds.add(calendar.getServiceId());
        }
        for (ServiceCalendarDate date : this.getCalendarDates()) {
            serviceIds.add(date.getServiceId());
        }
        return serviceIds;
    }

    private static void logRemove(String type, int orgSize, int newSize, String reason) {
        if (orgSize == newSize) {
            return;
        }
        LOG.info("{} of {} {}(s) removed. Reason: {}", new Object[]{orgSize - newSize, orgSize, type, reason});
    }

    private void removeEntitiesWithInvalidReferences() {
        this.removeTripsWithNoneExistingServiceIds();
        this.removeStopTimesForNoneExistingTrips();
        this.fixOrRemovePatternsWhichReferenceNoneExistingTrips();
        this.removeTransfersForNoneExistingTrips();
        this.removeTripOnServiceDateForNonExistingTrip();
    }

    private void removeTripsWithNoneExistingServiceIds() {
        Set<FeedScopedId> serviceIds = this.findAllServiceIds();
        int orgSize = this.tripsById.size();
        this.tripsById.removeIf(t -> !serviceIds.contains(t.getServiceId()), t -> this.issueStore.add("RemovedMissingServiceIdTrip", "Removed trip %s as service id %s does not exist", t.getId(), t.getServiceId()));
        OtpTransitServiceBuilder.logRemove("Trip", orgSize, this.tripsById.size(), "Trip service id does not exist.");
    }

    private void removeStopTimesForNoneExistingTrips() {
        int orgSize = this.stopTimesByTrip.size();
        this.stopTimesByTrip.removeIf(t -> !this.tripsById.containsKey(t.getId()));
        OtpTransitServiceBuilder.logRemove("StopTime", orgSize, this.stopTimesByTrip.size(), "StopTime trip does not exist.");
    }

    private void fixOrRemovePatternsWhichReferenceNoneExistingTrips() {
        int orgSize = this.tripPatterns.size();
        ArrayList<Map.Entry> removePatterns = new ArrayList<Map.Entry>();
        for (Map.Entry e : this.tripPatterns.entries()) {
            TripPattern ptn = (TripPattern)e.getValue();
            ptn.removeTrips(t -> !this.tripsById.containsKey(t.getId()));
            if (!ptn.scheduledTripsAsStream().findAny().isEmpty()) continue;
            removePatterns.add(e);
        }
        for (Map.Entry it : removePatterns) {
            this.tripPatterns.remove(it.getKey(), it.getValue());
            this.issueStore.add("RemovedEmptyTripPattern", "Removed trip pattern %s as it contains no trips", ((TripPattern)it.getValue()).getId());
        }
        OtpTransitServiceBuilder.logRemove("TripPattern", orgSize, this.tripPatterns.size(), "No trips for pattern exist.");
    }

    private void removeTransfersForNoneExistingTrips() {
        int orgSize = this.transfers.size();
        this.transfers.removeIf(this::transferTripReferencesDoNotExist);
        OtpTransitServiceBuilder.logRemove("Trip", orgSize, this.transfers.size(), "Transfer to/from trip does not exist.");
    }

    private void removeTripOnServiceDateForNonExistingTrip() {
        int orgSize = this.tripOnServiceDates.size();
        for (TripOnServiceDate tripOnServiceDate : this.tripOnServiceDates.values()) {
            if (this.tripsById.containsKey(tripOnServiceDate.getTrip().getId())) continue;
            OtpTransitServiceBuilder.logRemove("TripOnServiceDate", orgSize, this.tripOnServiceDates.size(), "Trip for TripOnServiceDate does not exist.");
        }
    }

    private boolean transferTripReferencesDoNotExist(ConstrainedTransfer t) {
        return this.transferPointTripReferenceDoesNotExist(t.getFrom()) || this.transferPointTripReferenceDoesNotExist(t.getTo());
    }

    private boolean transferPointTripReferenceDoesNotExist(TransferPoint point) {
        if (!point.isTripTransferPoint()) {
            return false;
        }
        Trip trip = point.asTripTransferPoint().getTrip();
        return !this.tripsById.containsKey(trip.getId());
    }
}

