/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.model.calendar;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.util.time.ServiceDateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalendarServiceData
implements Serializable {
    private static final String CAL_SERVICE_FEED_ID = "CSID";
    private static final Logger LOG = LoggerFactory.getLogger(CalendarServiceData.class);
    private final Map<FeedScopedId, List<LocalDate>> serviceDatesByServiceId = new HashMap<FeedScopedId, List<LocalDate>>();
    private final Map<LocalDate, Set<FeedScopedId>> serviceIdsByDate = new HashMap<LocalDate, Set<FeedScopedId>>();

    public Set<FeedScopedId> getServiceIds() {
        return Collections.unmodifiableSet(this.serviceDatesByServiceId.keySet());
    }

    public List<LocalDate> getServiceDatesForServiceId(FeedScopedId serviceId) {
        return this.serviceDatesByServiceId.get(serviceId);
    }

    public Set<FeedScopedId> getServiceIdsForDate(LocalDate date) {
        Set<FeedScopedId> serviceIds = this.serviceIdsByDate.get(date);
        if (serviceIds == null) {
            serviceIds = new HashSet<FeedScopedId>();
        }
        return serviceIds;
    }

    public void putServiceDatesForServiceId(FeedScopedId serviceId, List<LocalDate> dates) {
        List<LocalDate> serviceDates = CalendarServiceData.sortedImmutableList(dates);
        this.serviceDatesByServiceId.put(serviceId, serviceDates);
        this.addDatesToServiceIdsByDate(serviceId, serviceDates);
    }

    public FeedScopedId getOrCreateServiceIdForDate(LocalDate serviceDate) {
        FeedScopedId serviceId = new FeedScopedId(CAL_SERVICE_FEED_ID, ServiceDateUtils.asCompactString(serviceDate));
        if (this.serviceDatesByServiceId.containsKey(serviceId)) {
            return serviceId;
        }
        this.serviceDatesByServiceId.put(serviceId, List.of(serviceDate));
        this.serviceIdsByDate.computeIfAbsent(serviceDate, d -> new HashSet()).add(serviceId);
        LOG.info("Adding serviceId {} to CalendarService", (Object)serviceId);
        return serviceId;
    }

    public void add(CalendarServiceData other) {
        for (FeedScopedId serviceId : other.serviceDatesByServiceId.keySet()) {
            this.putServiceDatesForServiceId(serviceId, other.serviceDatesByServiceId.get(serviceId));
        }
    }

    private static <T> List<T> sortedImmutableList(Collection<T> c) {
        return c.stream().sorted().toList();
    }

    private void addDatesToServiceIdsByDate(FeedScopedId serviceId, List<LocalDate> serviceDates) {
        for (LocalDate serviceDate : serviceDates) {
            Set serviceIds = this.serviceIdsByDate.computeIfAbsent(serviceDate, k -> new HashSet());
            serviceIds.add(serviceId);
        }
    }
}

