/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.inspector;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.impl.PackedCoordinateSequence;
import org.opentripplanner.common.model.T2;
import org.opentripplanner.inspector.DefaultScalarColorPalette;
import org.opentripplanner.inspector.EdgeVertexTileRenderer;
import org.opentripplanner.inspector.ScalarColorPalette;
import org.opentripplanner.routing.edgetype.StreetEdge;
import org.opentripplanner.routing.graph.Edge;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.graph.Vertex;

class ElevationEdgeRenderer
implements EdgeVertexTileRenderer.EdgeVertexRenderer {
    private final ScalarColorPalette colorPalette;

    ElevationEdgeRenderer(Graph graph) {
        this.colorPalette = graph.hasElevation ? new DefaultScalarColorPalette(graph.minElevation, (graph.minElevation + graph.maxElevation) / 2.0, graph.maxElevation) : new DefaultScalarColorPalette(0.0, 0.0, 0.0);
    }

    @Override
    public boolean renderEdge(Edge e, EdgeVertexTileRenderer.EdgeVisualAttributes attrs) {
        return true;
    }

    @Override
    public boolean renderVertex(Vertex v, EdgeVertexTileRenderer.VertexVisualAttributes attrs) {
        Double elevation = this.findElevationForVertex(v);
        if (elevation != null) {
            attrs.color = this.colorPalette.getColor(elevation);
            attrs.label = elevation.toString();
            return true;
        }
        return false;
    }

    @Override
    public String getName() {
        return "Elevation";
    }

    @Override
    public boolean hasEdgeSegments(Edge edge) {
        return true;
    }

    @Override
    public Iterable<T2<Double, Color>> edgeSegments(Edge edge) {
        if (edge instanceof StreetEdge) {
            StreetEdge streetEdge = (StreetEdge)edge;
            if (streetEdge.hasElevationExtension()) {
                double edgeLength = edge.getDistanceMeters();
                Color color = Color.DARK_GRAY;
                ArrayList<T2<Double, Color>> t2 = new ArrayList<T2<Double, Color>>();
                PackedCoordinateSequence profile = streetEdge.getElevationProfile();
                for (int i = 0; i < profile.size(); ++i) {
                    Coordinate point = profile.getCoordinate(i);
                    if (i != 0) {
                        t2.add(new T2<Double, Color>(point.x / edgeLength, color));
                    }
                    color = this.colorPalette.getColor(point.y);
                }
                return t2;
            }
            return List.of(new T2<Double, Color>(1.0, Color.GRAY));
        }
        return List.of(new T2<Double, Color>(1.0, Color.LIGHT_GRAY));
    }

    private Double findElevationForVertex(Vertex v) {
        return Stream.concat(v.getIncomingStreetEdges().stream().filter(StreetEdge::hasElevationExtension).map(streetEdge -> streetEdge.getElevationProfile().getCoordinate((int)(streetEdge.getElevationProfile().size() - 1)).y), v.getOutgoingStreetEdges().stream().filter(StreetEdge::hasElevationExtension).map(streetEdge -> streetEdge.getElevationProfile().getCoordinate((int)0).y)).findAny().orElse(null);
    }
}

