/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.inspector;

import com.jhlabs.awt.ShapeStroke;
import com.jhlabs.awt.TextStroke;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.util.Comparator;
import java.util.List;
import org.locationtech.jts.awt.IdentityPointTransformation;
import org.locationtech.jts.awt.PointShapeFactory;
import org.locationtech.jts.awt.PointTransformation;
import org.locationtech.jts.awt.ShapeWriter;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.linearref.LengthLocationMap;
import org.locationtech.jts.linearref.LinearLocation;
import org.locationtech.jts.linearref.LocationIndexedLine;
import org.locationtech.jts.operation.buffer.BufferParameters;
import org.locationtech.jts.operation.buffer.OffsetCurveBuilder;
import org.opentripplanner.common.model.T2;
import org.opentripplanner.inspector.TileRenderer;
import org.opentripplanner.routing.edgetype.StreetEdge;
import org.opentripplanner.routing.graph.Edge;
import org.opentripplanner.routing.graph.Vertex;
import org.opentripplanner.routing.impl.StreetVertexIndex;
import org.opentripplanner.routing.vertextype.StreetVertex;
import org.opentripplanner.util.geometry.GeometryUtils;

public class EdgeVertexTileRenderer
implements TileRenderer {
    private final EdgeVertexRenderer evRenderer;

    public EdgeVertexTileRenderer(EdgeVertexRenderer evRenderer) {
        this.evRenderer = evRenderer;
    }

    @Override
    public int getColorModel() {
        return 2;
    }

    @Override
    public void renderTile(TileRenderer.TileRenderContext context) {
        boolean render;
        float lineWidth = (float)(1.0 + 3.0 / Math.sqrt(context.metersPerPixel));
        Envelope bboxWithMargins = context.expandPixels((double)lineWidth * 2.0, (double)lineWidth * 2.0);
        StreetVertexIndex streetIndex = context.graph.getStreetIndex();
        List vertices = streetIndex.getVerticesForEnvelope(bboxWithMargins).stream().sorted(this.evRenderer::vertexSorter).toList();
        List<Edge> edges = streetIndex.getEdgesForEnvelope(bboxWithMargins).stream().distinct().sorted(this.evRenderer::edgeSorter).toList();
        ShapeWriter shapeWriter = new ShapeWriter((PointTransformation)new IdentityPointTransformation(), (PointShapeFactory)new PointShapeFactory.Point());
        BasicStroke stroke = new BasicStroke(lineWidth * 1.4f, 1, 2);
        BasicStroke halfStroke = new BasicStroke(lineWidth * 0.6f + 1.0f, 1, 2);
        BasicStroke halfDashedStroke = new BasicStroke(lineWidth * 0.6f + 1.0f, 0, 2, 1.0f, new float[]{4.0f * lineWidth, lineWidth}, 2.0f * lineWidth);
        ShapeStroke arrowStroke = new ShapeStroke(new Polygon(new int[]{0, 0, 30}, new int[]{0, 20, 10}, 3), lineWidth / 2.0f, 5.0f * lineWidth, 2.5f * lineWidth);
        BasicStroke thinStroke = new BasicStroke(1.0f, 1, 2);
        Font font = new Font("SansSerif", 0, Math.round(lineWidth));
        Font largeFont = new Font("SansSerif", 0, Math.round(lineWidth * 1.5f));
        FontMetrics largeFontMetrics = context.graphics.getFontMetrics(largeFont);
        context.graphics.setFont(largeFont);
        context.graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        context.graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        BufferParameters bufParams = new BufferParameters();
        bufParams.setSingleSided(true);
        bufParams.setJoinStyle(3);
        EdgeVisualAttributes evAttrs = new EdgeVisualAttributes();
        for (Edge edge : edges) {
            Geometry midLineGeom;
            OffsetCurveBuilder offsetBuilder;
            Coordinate[] coords;
            evAttrs.color = null;
            evAttrs.label = null;
            LineString edgeGeom = edge.getGeometry();
            boolean hasGeom = true;
            if (edgeGeom == null) {
                Coordinate[] coordinates = new Coordinate[]{edge.getFromVertex().getCoordinate(), edge.getToVertex().getCoordinate()};
                edgeGeom = GeometryUtils.getGeometryFactory().createLineString(coordinates);
                hasGeom = false;
            }
            if (!(render = this.evRenderer.renderEdge(edge, evAttrs)) || (coords = (offsetBuilder = new OffsetCurveBuilder(new PrecisionModel(), bufParams)).getOffsetCurve((midLineGeom = context.transform.transform((Geometry)edgeGeom)).getCoordinates(), (double)lineWidth * 0.4)).length < 2) continue;
            LineString offsetLine = GeometryUtils.makeLineString(coords);
            Shape midLineShape = shapeWriter.toShape(midLineGeom);
            Shape offsetShape = shapeWriter.toShape((Geometry)offsetLine);
            context.graphics.setStroke(hasGeom ? halfStroke : halfDashedStroke);
            if (this.evRenderer.hasEdgeSegments(edge)) {
                LocationIndexedLine line = new LocationIndexedLine((Geometry)offsetLine);
                LengthLocationMap locater = new LengthLocationMap((Geometry)offsetLine);
                double offsetLength = offsetLine.getLength();
                LinearLocation previousLocation = line.getStartIndex();
                for (T2<Double, Color> p2 : this.evRenderer.edgeSegments(edge)) {
                    LinearLocation currentLocation = locater.getLocation(offsetLength * (Double)p2.first);
                    Geometry segmentGeometry = line.extractLine(previousLocation, currentLocation);
                    Shape segmentShape = shapeWriter.toShape(segmentGeometry);
                    context.graphics.setColor((Color)p2.second);
                    context.graphics.draw(segmentShape);
                    previousLocation = currentLocation;
                }
            } else {
                context.graphics.setColor(evAttrs.color);
                context.graphics.draw(offsetShape);
            }
            if (lineWidth > 6.0f) {
                context.graphics.setColor(Color.WHITE);
                context.graphics.setStroke(arrowStroke);
                context.graphics.draw(offsetShape);
            }
            if (lineWidth > 4.0f) {
                context.graphics.setColor(Color.BLACK);
                context.graphics.setStroke(thinStroke);
                context.graphics.draw(midLineShape);
            }
            if (evAttrs.label == null || !(lineWidth > 8.0f)) continue;
            context.graphics.setColor(Color.BLACK);
            context.graphics.setStroke(new TextStroke("    " + evAttrs.label + "                              ", font, false, true));
            context.graphics.draw(offsetShape);
        }
        VertexVisualAttributes vvAttrs = new VertexVisualAttributes();
        for (Vertex vertex : vertices) {
            vvAttrs.color = null;
            vvAttrs.label = null;
            Point point = GeometryUtils.getGeometryFactory().createPoint(vertex.getCoordinate());
            render = this.evRenderer.renderVertex(vertex, vvAttrs);
            if (!render) continue;
            Point tilePoint = (Point)context.transform.transform((Geometry)point);
            Shape shape = shapeWriter.toShape((Geometry)tilePoint);
            context.graphics.setColor(vvAttrs.color);
            context.graphics.setStroke(stroke);
            context.graphics.draw(shape);
            if (vvAttrs.label == null || !(lineWidth > 6.0f) || !context.bbox.contains(point.getCoordinate())) continue;
            context.graphics.setColor(Color.BLACK);
            int labelWidth = largeFontMetrics.stringWidth(vvAttrs.label);
            double x = tilePoint.getX();
            if (x + (double)labelWidth > (double)context.tileWidth) {
                x -= (double)labelWidth;
            }
            context.graphics.drawString(vvAttrs.label, (float)x, (float)tilePoint.getY());
        }
    }

    @Override
    public String getName() {
        return this.evRenderer.getName();
    }

    public static interface EdgeVertexRenderer {
        public static final Comparator<Vertex> defaultVertexComparator = Comparator.comparing(v -> v instanceof StreetVertex).reversed();
        public static final Comparator<Edge> defaultEdgeComparator = Comparator.comparing(e -> e.getGeometry() != null).thenComparing(e -> e instanceof StreetEdge);

        public boolean renderEdge(Edge var1, EdgeVisualAttributes var2);

        public boolean renderVertex(Vertex var1, VertexVisualAttributes var2);

        public String getName();

        default public boolean hasEdgeSegments(Edge edge) {
            return false;
        }

        default public Iterable<T2<Double, Color>> edgeSegments(Edge edge) {
            return List.of();
        }

        default public int vertexSorter(Vertex v1, Vertex v2) {
            return defaultVertexComparator.compare(v1, v2);
        }

        default public int edgeSorter(Edge e1, Edge e2) {
            return defaultEdgeComparator.compare(e1, e2);
        }
    }

    public static class EdgeVisualAttributes {
        public Color color;
        public String label;
    }

    public static class VertexVisualAttributes {
        public Color color;
        public String label;
    }
}

