/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.gtfs.mapping;

import java.time.ZoneId;
import java.util.HashMap;
import java.util.Map;
import org.onebusaway.gtfs.model.Stop;
import org.opentripplanner.gtfs.mapping.AgencyAndIdMapper;
import org.opentripplanner.gtfs.mapping.TranslationHelper;
import org.opentripplanner.gtfs.mapping.WgsCoordinateMapper;
import org.opentripplanner.transit.model.site.Station;
import org.opentripplanner.transit.model.site.StationBuilder;

class StationMapper {
    private final Map<Stop, Station> mappedStops = new HashMap<Stop, Station>();
    private final TranslationHelper translationHelper;

    StationMapper(TranslationHelper translationHelper) {
        this.translationHelper = translationHelper;
    }

    Station map(Stop orginal) {
        return orginal == null ? null : this.mappedStops.computeIfAbsent(orginal, this::doMap);
    }

    private Station doMap(Stop rhs) {
        if (rhs.getLocationType() != 1) {
            throw new IllegalArgumentException("Expected type 1, but got " + rhs.getLocationType());
        }
        StationBuilder builder = Station.of(AgencyAndIdMapper.mapAgencyAndId(rhs.getId())).withCoordinate(WgsCoordinateMapper.mapToDomain(rhs)).withCode(rhs.getCode());
        builder.withName(this.translationHelper.getTranslation(Stop.class, "name", rhs.getId().getId(), rhs.getName()));
        builder.withDescription(this.translationHelper.getTranslation(Stop.class, "desc", rhs.getId().getId(), rhs.getDesc()));
        builder.withUrl(this.translationHelper.getTranslation(Stop.class, "url", rhs.getId().getId(), rhs.getUrl()));
        if (rhs.getTimezone() != null) {
            builder.withTimezone(ZoneId.of(rhs.getTimezone()));
        }
        return (Station)builder.build();
    }
}

