/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.gtfs.mapping;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.opentripplanner.graph_builder.DataImportIssueStore;
import org.opentripplanner.gtfs.mapping.AgencyAndIdMapper;
import org.opentripplanner.gtfs.mapping.AgencyMapper;
import org.opentripplanner.gtfs.mapping.BikeAccessMapper;
import org.opentripplanner.gtfs.mapping.BrandingMapper;
import org.opentripplanner.gtfs.mapping.TransitModeMapper;
import org.opentripplanner.gtfs.mapping.TranslationHelper;
import org.opentripplanner.transit.model.basic.I18NString;
import org.opentripplanner.transit.model.basic.TransitMode;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.network.GroupOfRoutes;
import org.opentripplanner.transit.model.network.Route;
import org.opentripplanner.transit.model.network.RouteBuilder;
import org.opentripplanner.util.MapUtils;

class RouteMapper {
    private final AgencyMapper agencyMapper;
    private final BrandingMapper brandingMapper;
    private final DataImportIssueStore issueStore;
    private TranslationHelper translationHelper;
    private final Map<org.onebusaway.gtfs.model.Route, Route> mappedRoutes = new HashMap<org.onebusaway.gtfs.model.Route, Route>();

    RouteMapper(AgencyMapper agencyMapper, DataImportIssueStore issueStore, TranslationHelper helper) {
        this.agencyMapper = agencyMapper;
        this.issueStore = issueStore;
        this.brandingMapper = new BrandingMapper();
        this.translationHelper = helper;
    }

    Collection<Route> map(Collection<org.onebusaway.gtfs.model.Route> agencies) {
        return MapUtils.mapToList(agencies, this::map);
    }

    Route map(org.onebusaway.gtfs.model.Route orginal) {
        return orginal == null ? null : this.mappedRoutes.computeIfAbsent(orginal, this::doMap);
    }

    private Route doMap(org.onebusaway.gtfs.model.Route rhs) {
        TransitMode mode;
        RouteBuilder lhs = Route.of(AgencyAndIdMapper.mapAgencyAndId(rhs.getId()));
        I18NString longName = null;
        if (rhs.getLongName() != null) {
            longName = this.translationHelper.getTranslation(org.onebusaway.gtfs.model.Route.class, "longName", rhs.getId().getId(), rhs.getLongName());
        }
        lhs.withAgency(this.agencyMapper.map(rhs.getAgency()));
        lhs.withShortName(rhs.getShortName());
        lhs.withLongName(longName);
        lhs.withGtfsType(rhs.getType());
        if (rhs.isSortOrderSet()) {
            lhs.withGtfsSortOrder(rhs.getSortOrder());
        }
        if ((mode = TransitModeMapper.mapMode(rhs.getType())) == null) {
            this.issueStore.add("RouteMapper", "Treating %s route type for route %s as BUS.", rhs.getType(), lhs.getId());
            lhs.withMode(TransitMode.BUS);
        } else {
            lhs.withMode(mode);
        }
        lhs.withDescription(rhs.getDesc());
        lhs.withUrl(rhs.getUrl());
        lhs.withColor(rhs.getColor());
        lhs.withTextColor(rhs.getTextColor());
        lhs.withBikesAllowed(BikeAccessMapper.mapForRoute(rhs));
        lhs.withBranding(this.brandingMapper.map(rhs));
        if (rhs.getNetworkId() != null) {
            GroupOfRoutes networkId = (GroupOfRoutes)GroupOfRoutes.of(new FeedScopedId(rhs.getId().getAgencyId(), rhs.getNetworkId())).build();
            lhs.getGroupsOfRoutes().add(networkId);
        }
        return (Route)lhs.build();
    }
}

