/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.gtfs.mapping;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.locationtech.jts.geom.Geometry;
import org.onebusaway.gtfs.model.Location;
import org.opentripplanner.common.geometry.UnsupportedGeometryException;
import org.opentripplanner.gtfs.mapping.AgencyAndIdMapper;
import org.opentripplanner.transit.model.basic.NonLocalizedString;
import org.opentripplanner.transit.model.site.AreaStop;
import org.opentripplanner.util.MapUtils;
import org.opentripplanner.util.geometry.GeometryUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocationMapper {
    private static final Logger LOG = LoggerFactory.getLogger(LocationMapper.class);
    private final Map<Location, AreaStop> mappedLocations = new HashMap<Location, AreaStop>();

    Collection<AreaStop> map(Collection<Location> allLocations) {
        return MapUtils.mapToList(allLocations, this::map);
    }

    AreaStop map(Location orginal) {
        return orginal == null ? null : this.mappedLocations.computeIfAbsent(orginal, this::doMap);
    }

    private AreaStop doMap(Location gtfsLocation) {
        NonLocalizedString name = NonLocalizedString.ofNullable(gtfsLocation.getName());
        Geometry geometry = null;
        try {
            geometry = GeometryUtils.convertGeoJsonToJtsGeometry(gtfsLocation.getGeometry());
        }
        catch (UnsupportedGeometryException e) {
            LOG.error("Unsupported geometry type for {}", (Object)gtfsLocation.getId());
        }
        return (AreaStop)AreaStop.of(AgencyAndIdMapper.mapAgencyAndId(gtfsLocation.getId())).withName(name).withUrl(NonLocalizedString.ofNullable(gtfsLocation.getUrl())).withDescription(NonLocalizedString.ofNullable(gtfsLocation.getDescription())).withZoneId(gtfsLocation.getZoneId()).withGeometry(geometry).build();
    }
}

