/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.gtfs.mapping;

import java.time.Duration;
import java.util.Collection;
import java.util.Currency;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.onebusaway.gtfs.model.FareContainer;
import org.onebusaway.gtfs.model.FareProduct;
import org.onebusaway.gtfs.model.RiderCategory;
import org.opentripplanner.gtfs.mapping.AgencyAndIdMapper;
import org.opentripplanner.routing.core.Money;
import org.opentripplanner.transit.model.framework.FeedScopedId;

public class FareProductMapper {
    public static int NOT_SET = -999;
    private final Set<org.opentripplanner.ext.fares.model.FareProduct> mappedFareProducts = new HashSet<org.opentripplanner.ext.fares.model.FareProduct>();

    public org.opentripplanner.ext.fares.model.FareProduct map(FareProduct rhs) {
        Currency currency = Currency.getInstance(rhs.getCurrency());
        Money price = new Money(currency, (int)((double)rhs.getAmount() * Math.pow(10.0, currency.getDefaultFractionDigits())));
        Duration duration = null;
        if (rhs.getDurationUnit() != NOT_SET) {
            duration = FareProductMapper.toDuration(rhs.getDurationUnit(), rhs.getDurationAmount());
        }
        org.opentripplanner.ext.fares.model.FareProduct fp = new org.opentripplanner.ext.fares.model.FareProduct(AgencyAndIdMapper.mapAgencyAndId(rhs.getFareProductId()), rhs.getName(), price, duration, FareProductMapper.toInternalModel(rhs.getRiderCategory()), FareProductMapper.toInternalModel(rhs.egetFareContainer()));
        this.mappedFareProducts.add(fp);
        return fp;
    }

    public Collection<org.opentripplanner.ext.fares.model.FareProduct> map(Collection<FareProduct> allFareProducts) {
        return allFareProducts.stream().map(this::map).toList();
    }

    public Optional<org.opentripplanner.ext.fares.model.FareProduct> getByFareProductId(FeedScopedId fareProductId) {
        return this.mappedFareProducts.stream().filter(p -> p.id().equals(fareProductId)).findFirst();
    }

    private static org.opentripplanner.ext.fares.model.RiderCategory toInternalModel(RiderCategory riderCategory) {
        if (riderCategory == null) {
            return null;
        }
        return new org.opentripplanner.ext.fares.model.RiderCategory(riderCategory.getId().getId(), riderCategory.getName(), riderCategory.getEligibilityUrl());
    }

    private static Duration toDuration(int unit, int amount) {
        return switch (unit) {
            case 0 -> Duration.ofSeconds(amount);
            case 1 -> Duration.ofMinutes(amount);
            case 2 -> Duration.ofHours(amount);
            case 3 -> Duration.ofDays(amount);
            case 4 -> Duration.ofDays((long)amount * 7L);
            case 5 -> Duration.ofDays((long)amount * 31L);
            case 6 -> Duration.ofDays((long)amount * 365L);
            default -> throw new IllegalStateException("Unexpected value: " + unit);
        };
    }

    private static org.opentripplanner.ext.fares.model.FareContainer toInternalModel(FareContainer c) {
        if (c == null) {
            return null;
        }
        return new org.opentripplanner.ext.fares.model.FareContainer(c.getId().getId(), c.getName());
    }
}

