/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.gtfs.graphbuilder;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.onebusaway.csv_entities.CsvInputSource;
import org.opentripplanner.datastore.api.CompositeDataSource;
import org.opentripplanner.datastore.api.FileType;
import org.opentripplanner.datastore.configure.DataStoreModule;
import org.opentripplanner.graph_builder.ConfiguredDataSource;
import org.opentripplanner.graph_builder.module.GtfsFeedId;
import org.opentripplanner.gtfs.graphbuilder.GtfsFeedParameters;
import org.opentripplanner.gtfs.graphbuilder.GtfsFeedParametersBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GtfsBundle {
    private static final Logger LOG = LoggerFactory.getLogger(GtfsBundle.class);
    private final CompositeDataSource dataSource;
    private GtfsFeedId feedId;
    private CsvInputSource csvInputSource;
    public int subwayAccessTime;
    private double maxStopToShapeSnapDistance = 150.0;

    public GtfsBundle(File gtfsFile) {
        this(DataStoreModule.compositeSource(gtfsFile, FileType.GTFS));
    }

    private GtfsBundle(CompositeDataSource compositeDataSource) {
        this(new ConfiguredDataSource<GtfsFeedParameters>(compositeDataSource, new GtfsFeedParametersBuilder().withSource(compositeDataSource.uri()).build()));
    }

    public GtfsBundle(ConfiguredDataSource<GtfsFeedParameters> configuredDataSource) {
        this.dataSource = (CompositeDataSource)configuredDataSource.dataSource();
        if (configuredDataSource.config().feedId().isPresent()) {
            this.feedId = new GtfsFeedId.Builder().id(configuredDataSource.config().feedId().get()).build();
        }
    }

    public CsvInputSource getCsvInputSource() {
        if (this.csvInputSource == null) {
            this.csvInputSource = new CsvInputSource(){

                public boolean hasResource(String s) {
                    return GtfsBundle.this.dataSource.content().stream().anyMatch(it -> it.name().equals(s));
                }

                public InputStream getResource(String s) {
                    return GtfsBundle.this.dataSource.entry(s).asInputStream();
                }

                public void close() {
                }
            };
        }
        return this.csvInputSource;
    }

    public void close() {
        try {
            this.dataSource.close();
        }
        catch (IOException e) {
            LOG.warn("Failed to close datasource {}, details: {}", new Object[]{this.dataSource.path(), e.getLocalizedMessage(), e});
        }
    }

    public String toString() {
        Object src = this.dataSource.path();
        if (this.feedId != null) {
            src = (String)src + " (" + this.feedId.getId() + ")";
        }
        return "GTFS bundle at " + (String)src;
    }

    public GtfsFeedId getFeedId() {
        if (this.feedId == null) {
            this.feedId = new GtfsFeedId.Builder().fromGtfsFeed(this.getCsvInputSource()).build();
        }
        return this.feedId;
    }

    public void setFeedId(GtfsFeedId feedId) {
        this.feedId = feedId;
    }

    public void checkInputs() {
        if (this.csvInputSource != null) {
            LOG.warn("unknown CSV source type; cannot check inputs");
            return;
        }
        if (!this.dataSource.exists()) {
            throw new RuntimeException("GTFS Path " + this.dataSource.path() + " does not exist or cannot be read.");
        }
    }

    public double getMaxStopToShapeSnapDistance() {
        return this.maxStopToShapeSnapDistance;
    }

    public void setMaxStopToShapeSnapDistance(double maxStopToShapeSnapDistance) {
        this.maxStopToShapeSnapDistance = maxStopToShapeSnapDistance;
    }
}

