/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module.osm.tagmapping;

import org.opentripplanner.graph_builder.module.osm.WayPropertySet;
import org.opentripplanner.graph_builder.module.osm.tagmapping.AtlantaMapper;
import org.opentripplanner.graph_builder.module.osm.tagmapping.DefaultMapper;
import org.opentripplanner.graph_builder.module.osm.tagmapping.FinlandMapper;
import org.opentripplanner.graph_builder.module.osm.tagmapping.GermanyMapper;
import org.opentripplanner.graph_builder.module.osm.tagmapping.HoustonMapper;
import org.opentripplanner.graph_builder.module.osm.tagmapping.NorwayMapper;
import org.opentripplanner.graph_builder.module.osm.tagmapping.UKMapper;
import org.opentripplanner.openstreetmap.model.OSMWithTags;

public interface OsmTagMapper {
    public static OsmTagMapper defaultMapper() {
        return Source.DEFAULT.getInstance();
    }

    public void populateProperties(WayPropertySet var1);

    default public boolean doesTagValueDisallowThroughTraffic(String tagValue) {
        return "no".equals(tagValue) || "destination".equals(tagValue) || "private".equals(tagValue) || "customers".equals(tagValue) || "delivery".equals(tagValue);
    }

    default public boolean isGeneralNoThroughTraffic(OSMWithTags way) {
        String access = way.getTag("access");
        return this.doesTagValueDisallowThroughTraffic(access);
    }

    default public boolean isVehicleThroughTrafficExplicitlyDisallowed(OSMWithTags way) {
        String vehicle = way.getTag("vehicle");
        if (vehicle != null) {
            return this.doesTagValueDisallowThroughTraffic(vehicle);
        }
        return this.isGeneralNoThroughTraffic(way);
    }

    default public boolean isMotorVehicleThroughTrafficExplicitlyDisallowed(OSMWithTags way) {
        String motorVehicle = way.getTag("motor_vehicle");
        if (motorVehicle != null) {
            return this.doesTagValueDisallowThroughTraffic(motorVehicle);
        }
        return this.isVehicleThroughTrafficExplicitlyDisallowed(way);
    }

    default public boolean isBicycleNoThroughTrafficExplicitlyDisallowed(OSMWithTags way) {
        String bicycle = way.getTag("bicycle");
        if (bicycle != null) {
            return this.doesTagValueDisallowThroughTraffic(bicycle);
        }
        return this.isVehicleThroughTrafficExplicitlyDisallowed(way);
    }

    default public boolean isWalkNoThroughTrafficExplicitlyDisallowed(OSMWithTags way) {
        String foot = way.getTag("foot");
        if (foot != null) {
            return this.doesTagValueDisallowThroughTraffic(foot);
        }
        return this.isGeneralNoThroughTraffic(way);
    }

    public static enum Source {
        DEFAULT,
        NORWAY,
        UK,
        FINLAND,
        GERMANY,
        ATLANTA,
        HOUSTON;


        public OsmTagMapper getInstance() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case DEFAULT -> new DefaultMapper();
                case NORWAY -> new NorwayMapper();
                case UK -> new UKMapper();
                case FINLAND -> new FinlandMapper();
                case GERMANY -> new GermanyMapper();
                case ATLANTA -> new AtlantaMapper();
                case HOUSTON -> new HoustonMapper();
            };
        }
    }
}

