/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module.osm.specifier;

import java.util.Arrays;
import java.util.List;
import org.opentripplanner.graph_builder.module.osm.specifier.ExactMatchSpecifier;
import org.opentripplanner.graph_builder.module.osm.specifier.OsmSpecifier;
import org.opentripplanner.openstreetmap.model.OSMWithTags;

public class LogicalOrSpecifier
implements OsmSpecifier {
    private final List<ExactMatchSpecifier> subSpecs;

    public LogicalOrSpecifier(String ... specs) {
        this.subSpecs = Arrays.stream(specs).map(ExactMatchSpecifier::new).toList();
    }

    @Override
    public OsmSpecifier.Scores matchScores(OSMWithTags way) {
        return OsmSpecifier.Scores.of(this.matchScore(way));
    }

    @Override
    public int matchScore(OSMWithTags way) {
        boolean oneMatchesExactly = this.subSpecs.stream().anyMatch(subspec -> subspec.allTagsMatch(way));
        if (oneMatchesExactly) {
            return 1;
        }
        return 0;
    }
}

