/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module.osm.specifier;

import java.util.List;
import org.opentripplanner.graph_builder.module.osm.specifier.OsmSpecifier;
import org.opentripplanner.openstreetmap.model.OSMWithTags;
import org.opentripplanner.util.lang.ToStringBuilder;

public class BestMatchSpecifier
implements OsmSpecifier {
    public static final int EXACT_MATCH_SCORE = 100;
    private final List<OsmSpecifier.Tag> pairs;

    public BestMatchSpecifier(String spec) {
        this.pairs = OsmSpecifier.getTagsFromString(spec, ";");
    }

    @Override
    public OsmSpecifier.Scores matchScores(OSMWithTags way) {
        return this.computeScores(way);
    }

    @Override
    public int matchScore(OSMWithTags way) {
        int score = 0;
        int matches = 0;
        for (OsmSpecifier.Tag pair : this.pairs) {
            String tag = pair.key();
            String value = pair.value();
            String matchValue = way.getTag(tag);
            int tagScore = BestMatchSpecifier.getTagScore(value, matchValue);
            score += tagScore;
            if (tagScore <= 0) continue;
            ++matches;
        }
        return score += matches == this.pairs.size() ? 10 : 0;
    }

    public String toString() {
        return ToStringBuilder.of(this.getClass()).addObj("pairs", this.pairs).toString();
    }

    private static int getTagScore(String value, String matchValue) {
        if (OsmSpecifier.matchesWildcard(value, matchValue)) {
            return 1;
        }
        if (value.equals(matchValue)) {
            return 100;
        }
        if (value.contains(":")) {
            if ((value = value.split(":", 2)[0]).equals(matchValue)) {
                return 75;
            }
            return 0;
        }
        return 0;
    }

    private OsmSpecifier.Scores computeScores(OSMWithTags way) {
        int leftScore = 0;
        int rightScore = 0;
        int leftMatches = 0;
        int rightMatches = 0;
        for (OsmSpecifier.Tag pair : this.pairs) {
            String tag = pair.key();
            String value = pair.value();
            String leftMatchValue = way.getTag(tag + ":left");
            String rightMatchValue = way.getTag(tag + ":right");
            String matchValue = way.getTag(tag);
            if (leftMatchValue == null) {
                leftMatchValue = matchValue;
            }
            if (rightMatchValue == null) {
                rightMatchValue = matchValue;
            }
            int leftTagScore = BestMatchSpecifier.getTagScore(value, leftMatchValue);
            leftScore += leftTagScore;
            if (leftTagScore > 0) {
                ++leftMatches;
            }
            int rightTagScore = BestMatchSpecifier.getTagScore(value, rightMatchValue);
            rightScore += rightTagScore;
            if (rightTagScore <= 0) continue;
            ++rightMatches;
        }
        int allMatchLeftBonus = leftMatches == this.pairs.size() ? 10 : 0;
        int allMatchRightBonus = rightMatches == this.pairs.size() ? 10 : 0;
        return new OsmSpecifier.Scores(leftScore += allMatchLeftBonus, rightScore += allMatchRightBonus);
    }
}

