/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module.osm.parameters;

import java.net.URI;
import java.time.ZoneId;
import java.util.Objects;
import java.util.Optional;
import org.opentripplanner.graph_builder.model.DataSourceConfig;
import org.opentripplanner.graph_builder.module.osm.parameters.OsmExtractParametersBuilder;
import org.opentripplanner.graph_builder.module.osm.tagmapping.OsmTagMapper;

public class OsmExtractParameters
implements DataSourceConfig {
    private final URI source;
    private final OsmTagMapper osmTagMapper;
    private final ZoneId timeZone;

    OsmExtractParameters(OsmExtractParametersBuilder builder) {
        this.source = Objects.requireNonNull(builder.getSource());
        this.osmTagMapper = builder.getOsmTagMapper();
        this.timeZone = builder.getTimeZone();
    }

    @Override
    public URI source() {
        return this.source;
    }

    public Optional<OsmTagMapper> osmTagMapper() {
        return Optional.ofNullable(this.osmTagMapper);
    }

    public Optional<ZoneId> timeZone() {
        return Optional.ofNullable(this.timeZone);
    }
}

