/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module.osm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.opentripplanner.common.geometry.SphericalDistanceLibrary;
import org.opentripplanner.common.model.P2;
import org.opentripplanner.graph_builder.DataImportIssueStore;
import org.opentripplanner.graph_builder.issues.AreaTooComplicated;
import org.opentripplanner.graph_builder.module.osm.Area;
import org.opentripplanner.graph_builder.module.osm.AreaGroup;
import org.opentripplanner.graph_builder.module.osm.OSMDatabase;
import org.opentripplanner.graph_builder.module.osm.OSMFilter;
import org.opentripplanner.graph_builder.module.osm.OpenStreetMapModule;
import org.opentripplanner.graph_builder.module.osm.Ring;
import org.opentripplanner.graph_builder.module.osm.WayProperties;
import org.opentripplanner.openstreetmap.model.OSMNode;
import org.opentripplanner.openstreetmap.model.OSMRelation;
import org.opentripplanner.openstreetmap.model.OSMRelationMember;
import org.opentripplanner.openstreetmap.model.OSMWithTags;
import org.opentripplanner.routing.algorithm.astar.AStarBuilder;
import org.opentripplanner.routing.algorithm.astar.strategies.SkipEdgeStrategy;
import org.opentripplanner.routing.api.request.RouteRequest;
import org.opentripplanner.routing.api.request.StreetMode;
import org.opentripplanner.routing.api.request.request.StreetRequest;
import org.opentripplanner.routing.core.State;
import org.opentripplanner.routing.edgetype.AreaEdge;
import org.opentripplanner.routing.edgetype.AreaEdgeList;
import org.opentripplanner.routing.edgetype.NamedArea;
import org.opentripplanner.routing.edgetype.StreetEdge;
import org.opentripplanner.routing.edgetype.StreetTraversalPermission;
import org.opentripplanner.routing.graph.Edge;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.graph.Vertex;
import org.opentripplanner.routing.spt.DominanceFunction;
import org.opentripplanner.routing.spt.GraphPath;
import org.opentripplanner.routing.spt.ShortestPathTree;
import org.opentripplanner.routing.vertextype.IntersectionVertex;
import org.opentripplanner.routing.vertextype.OsmVertex;
import org.opentripplanner.transit.model.basic.I18NString;
import org.opentripplanner.util.geometry.GeometryUtils;

public class WalkableAreaBuilder {
    private final DataImportIssueStore issueStore;
    private final int maxAreaNodes;
    private final Graph graph;
    private final OSMDatabase osmdb;
    private final Map<OSMWithTags, WayProperties> wayPropertiesCache = new HashMap<OSMWithTags, WayProperties>();
    private final OpenStreetMapModule.Handler handler;
    private final HashMap<Coordinate, IntersectionVertex> areaBoundaryVertexForCoordinate = new HashMap();
    private final boolean platformEntriesLinking;
    private final List<OsmVertex> platformLinkingEndpoints;
    private final Set<String> boardingLocationRefTags;

    public WalkableAreaBuilder(Graph graph, OSMDatabase osmdb, OpenStreetMapModule.Handler handler, DataImportIssueStore issueStore, int maxAreaNodes, boolean platformEntriesLinking, Set<String> boardingLocationRefTags) {
        this.graph = graph;
        this.osmdb = osmdb;
        this.handler = handler;
        this.issueStore = issueStore;
        this.maxAreaNodes = maxAreaNodes;
        this.platformEntriesLinking = platformEntriesLinking;
        this.boardingLocationRefTags = boardingLocationRefTags;
        this.platformLinkingEndpoints = platformEntriesLinking ? graph.getVertices().stream().filter(OsmVertex.class::isInstance).map(OsmVertex.class::cast).filter(this::isPlatformLinkingEndpoint).collect(Collectors.toList()) : List.of();
    }

    public void buildWithoutVisibility(AreaGroup group) {
        Set<String> references = this.getStopReferences(group);
        for (Ring ring : group.outermostRings) {
            HashSet<AreaEdge> edges = new HashSet<AreaEdge>();
            AreaEdgeList edgeList = new AreaEdgeList(ring.jtsPolygon, references);
            HashSet<P2<OSMNode>> alreadyAddedEdges = new HashSet<P2<OSMNode>>();
            for (Area area : group.areas) {
                if (!ring.jtsPolygon.contains((Geometry)area.jtsMultiPolygon)) continue;
                for (Ring outerRing : area.outermostRings) {
                    for (int i = 0; i < outerRing.nodes.size(); ++i) {
                        edges.addAll(this.createEdgesForRingSegment(edgeList, area, outerRing, i, alreadyAddedEdges));
                    }
                    for (Ring innerRing : outerRing.getHoles()) {
                        for (int j = 0; j < innerRing.nodes.size(); ++j) {
                            edges.addAll(this.createEdgesForRingSegment(edgeList, area, innerRing, j, alreadyAddedEdges));
                        }
                    }
                }
            }
            edges.stream().flatMap(v -> Stream.of(v.getFromVertex(), v.getToVertex()).filter(IntersectionVertex.class::isInstance).map(IntersectionVertex.class::cast)).forEach(edgeList.visibilityVertices::add);
            this.createNamedAreas(edgeList, ring, group.areas);
        }
    }

    public void buildWithVisibility(AreaGroup group) {
        HashSet<OSMNode> startingNodes = new HashSet<OSMNode>();
        HashSet<Vertex> startingVertices = new HashSet<Vertex>();
        HashSet<Edge> edges = new HashSet<Edge>();
        HashSet<Edge> ringEdges = new HashSet<Edge>();
        Set<Long> osmWayIds = group.areas.stream().map(area -> area.parent).flatMap(osmWithTags -> osmWithTags instanceof OSMRelation ? ((OSMRelation)osmWithTags).getMembers().stream().map(OSMRelationMember::getRef) : Stream.of(Long.valueOf(osmWithTags.getId()))).collect(Collectors.toSet());
        Set<String> references = this.getStopReferences(group);
        for (Ring ring : group.outermostRings) {
            Polygon polygon = ring.jtsPolygon;
            AreaEdgeList edgeList = new AreaEdgeList(polygon, references);
            HashSet<OSMNode> visibilityNodes = new HashSet<OSMNode>();
            HashSet<P2<OSMNode>> alreadyAddedEdges = new HashSet<P2<OSMNode>>();
            HashSet<IntersectionVertex> platformLinkingVertices = new HashSet<IntersectionVertex>();
            GeometryFactory geometryFactory = GeometryUtils.getGeometryFactory();
            OSMWithTags areaEntity = group.getSomeOSMObject();
            for (Area area2 : group.areas) {
                if (!polygon.contains((Geometry)area2.jtsMultiPolygon)) continue;
                Collection<OSMNode> nodes = this.osmdb.getStopsInArea(area2.parent);
                if (nodes != null) {
                    for (OSMNode node : nodes) {
                        IntersectionVertex vertex = this.handler.getVertexForOsmNode(node, areaEntity);
                        platformLinkingVertices.add(vertex);
                        visibilityNodes.add(node);
                        startingNodes.add(node);
                        edgeList.visibilityVertices.add(vertex);
                    }
                }
                for (Ring outerRing : area2.outermostRings) {
                    OSMNode node;
                    if (this.platformEntriesLinking && "platform".equals(area2.parent.getTag("public_transport"))) {
                        List<OsmVertex> endpointsWithin = this.platformLinkingEndpoints.stream().filter(t -> outerRing.jtsPolygon.contains((Geometry)geometryFactory.createPoint(t.getCoordinate()))).toList();
                        platformLinkingVertices.addAll(endpointsWithin);
                        for (OsmVertex v : endpointsWithin) {
                            node = this.osmdb.getNode(v.nodeId);
                            visibilityNodes.add(node);
                            startingNodes.add(node);
                            edgeList.visibilityVertices.add(v);
                        }
                    }
                    for (int i = 0; i < outerRing.nodes.size(); ++i) {
                        OSMNode node2 = outerRing.nodes.get(i);
                        Set<AreaEdge> newEdges = this.createEdgesForRingSegment(edgeList, area2, outerRing, i, alreadyAddedEdges);
                        edges.addAll(newEdges);
                        ringEdges.addAll(newEdges);
                        if (outerRing.isNodeConvex(i)) {
                            visibilityNodes.add(node2);
                        }
                        if (!this.isStartingNode(node2, osmWayIds)) continue;
                        visibilityNodes.add(node2);
                        startingNodes.add(node2);
                        edgeList.visibilityVertices.add(this.handler.getVertexForOsmNode(node2, areaEntity));
                    }
                    for (Ring innerRing : outerRing.getHoles()) {
                        for (int j = 0; j < innerRing.nodes.size(); ++j) {
                            node = innerRing.nodes.get(j);
                            edges.addAll(this.createEdgesForRingSegment(edgeList, area2, innerRing, j, alreadyAddedEdges));
                            if (!innerRing.isNodeConvex(j)) {
                                visibilityNodes.add(node);
                            }
                            if (!this.isStartingNode(node, osmWayIds)) continue;
                            visibilityNodes.add(node);
                            startingNodes.add(node);
                            edgeList.visibilityVertices.add(this.handler.getVertexForOsmNode(node, areaEntity));
                        }
                    }
                }
            }
            if (polygon.getNumPoints() > this.maxAreaNodes) {
                this.issueStore.add(new AreaTooComplicated(group.getSomeOSMObject().getId(), visibilityNodes.size(), this.maxAreaNodes));
                continue;
            }
            if (edgeList.visibilityVertices.size() == 0) {
                this.issueStore.add("UnconnectedArea", "Area %s has no connection to street network", osmWayIds.stream().map(Object::toString).collect(Collectors.joining(", ")));
            }
            this.createNamedAreas(edgeList, ring, group.areas);
            for (OSMNode nodeI : visibilityNodes) {
                IntersectionVertex startEndpoint = this.handler.getVertexForOsmNode(nodeI, areaEntity);
                if (startingNodes.contains(nodeI)) {
                    startingVertices.add(startEndpoint);
                }
                for (OSMNode nodeJ : visibilityNodes) {
                    P2<OSMNode> nodePair = new P2<OSMNode>(nodeI, nodeJ);
                    if (alreadyAddedEdges.contains(nodePair)) continue;
                    IntersectionVertex endEndpoint = this.handler.getVertexForOsmNode(nodeJ, areaEntity);
                    Coordinate[] coordinates = new Coordinate[]{startEndpoint.getCoordinate(), endEndpoint.getCoordinate()};
                    LineString line = geometryFactory.createLineString(coordinates);
                    if (!polygon.contains((Geometry)line)) continue;
                    Set<AreaEdge> segments = this.createSegments(startEndpoint, endEndpoint, group.areas, edgeList);
                    edges.addAll(segments);
                    if (platformLinkingVertices.contains(startEndpoint)) {
                        ringEdges.addAll(segments);
                    }
                    if (!platformLinkingVertices.contains(endEndpoint)) continue;
                    ringEdges.addAll(segments);
                }
            }
        }
        this.pruneAreaEdges(startingVertices, edges, ringEdges);
    }

    private Set<String> getStopReferences(AreaGroup group) {
        return group.areas.stream().filter(g -> g.parent.isBoardingLocation()).flatMap(g -> g.parent.getMultiTagValues(this.boardingLocationRefTags).stream()).collect(Collectors.toSet());
    }

    private void pruneAreaEdges(Collection<Vertex> startingVertices, Set<Edge> edges, Set<Edge> edgesToKeep) {
        if (edges.size() == 0) {
            return;
        }
        StreetEdge firstEdge = (StreetEdge)edges.iterator().next();
        StreetMode mode = firstEdge.getPermission().allows(StreetTraversalPermission.PEDESTRIAN) ? StreetMode.WALK : (firstEdge.getPermission().allows(StreetTraversalPermission.BICYCLE) ? StreetMode.BIKE : StreetMode.CAR);
        RouteRequest options = new RouteRequest();
        HashSet<Edge> usedEdges = new HashSet<Edge>();
        for (Vertex vertex : startingVertices) {
            ShortestPathTree spt = AStarBuilder.allDirections(new ListedEdgesOnly(edges)).setDominanceFunction(new DominanceFunction.EarliestArrival()).setRequest(options).setStreetRequest(new StreetRequest(mode)).setFrom(vertex).getShortestPathTree();
            for (Vertex endVertex : startingVertices) {
                GraphPath path = spt.getPath(endVertex);
                if (path == null) continue;
                usedEdges.addAll(path.edges);
            }
        }
        for (Edge edge : edges) {
            if (usedEdges.contains(edge) || edgesToKeep.contains(edge)) continue;
            this.graph.removeEdge(edge);
        }
    }

    private boolean isStartingNode(OSMNode node, Set<Long> osmWayIds) {
        return this.osmdb.isNodeBelongsToWay(node.getId()) || !this.osmdb.getAreasForNode(node.getId()).stream().allMatch(osmWay -> osmWayIds.contains(osmWay.getId())) || node.isBoardingLocation();
    }

    private Set<AreaEdge> createEdgesForRingSegment(AreaEdgeList edgeList, Area area, Ring ring, int i, HashSet<P2<OSMNode>> alreadyAddedEdges) {
        OSMNode nextNode;
        OSMNode node = ring.nodes.get(i);
        P2<OSMNode> nodePair = new P2<OSMNode>(node, nextNode = ring.nodes.get((i + 1) % ring.nodes.size()));
        if (alreadyAddedEdges.contains(nodePair)) {
            return Set.of();
        }
        alreadyAddedEdges.add(nodePair);
        IntersectionVertex startEndpoint = this.handler.getVertexForOsmNode(node, area.parent);
        IntersectionVertex endEndpoint = this.handler.getVertexForOsmNode(nextNode, area.parent);
        return this.createSegments(startEndpoint, endEndpoint, List.of(area), edgeList);
    }

    private Set<AreaEdge> createSegments(IntersectionVertex startEndpoint, IntersectionVertex endEndpoint, Collection<Area> areas, AreaEdgeList edgeList) {
        ArrayList<Area> intersects = new ArrayList<Area>();
        Coordinate[] coordinates = new Coordinate[]{startEndpoint.getCoordinate(), endEndpoint.getCoordinate()};
        GeometryFactory geometryFactory = GeometryUtils.getGeometryFactory();
        LineString line = geometryFactory.createLineString(coordinates);
        for (Area area : areas) {
            MultiPolygon polygon = area.jtsMultiPolygon;
            Geometry intersection = polygon.intersection((Geometry)line);
            if (!(intersection.getLength() > 1.0E-6)) continue;
            intersects.add(area);
        }
        if (intersects.size() == 0) {
            return Set.of();
        }
        if (intersects.size() == 1) {
            Area area = (Area)intersects.get(0);
            OSMWithTags areaEntity = area.parent;
            StreetTraversalPermission areaPermissions = OSMFilter.getPermissionsForEntity(areaEntity, StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE);
            float carSpeed = areaEntity.getOsmProvider().getWayPropertySet().getCarSpeedForWay(areaEntity, false);
            double length = SphericalDistanceLibrary.distance(startEndpoint.getCoordinate(), endEndpoint.getCoordinate());
            int cls = 5;
            cls |= OSMFilter.getStreetClasses(areaEntity);
            String label = "way (area) " + areaEntity.getId() + " from " + startEndpoint.getLabel() + " to " + endEndpoint.getLabel();
            I18NString name = this.handler.getNameForWay(areaEntity, label);
            AreaEdge street = new AreaEdge(startEndpoint, endEndpoint, line, name, length, areaPermissions, false, edgeList);
            street.setCarSpeed(carSpeed);
            if (!areaEntity.hasTag("name") && !areaEntity.hasTag("ref")) {
                street.setHasBogusName(true);
            }
            if (areaEntity.isTagFalse("wheelchair")) {
                street.setWheelchairAccessible(false);
            }
            street.setStreetClass(cls);
            label = "way (area) " + areaEntity.getId() + " from " + endEndpoint.getLabel() + " to " + startEndpoint.getLabel();
            name = this.handler.getNameForWay(areaEntity, label);
            AreaEdge backStreet = new AreaEdge(endEndpoint, startEndpoint, line.reverse(), name, length, areaPermissions, true, edgeList);
            backStreet.setCarSpeed(carSpeed);
            if (!areaEntity.hasTag("name") && !areaEntity.hasTag("ref")) {
                backStreet.setHasBogusName(true);
            }
            if (areaEntity.isTagFalse("wheelchair")) {
                backStreet.setWheelchairAccessible(false);
            }
            backStreet.setStreetClass(cls);
            if (!this.wayPropertiesCache.containsKey(areaEntity)) {
                WayProperties wayData = areaEntity.getOsmProvider().getWayPropertySet().getDataForWay(areaEntity);
                this.wayPropertiesCache.put(areaEntity, wayData);
            }
            this.handler.applyWayProperties(street, backStreet, this.wayPropertiesCache.get(areaEntity), areaEntity);
            return Set.of(street, backStreet);
        }
        Coordinate startCoordinate = startEndpoint.getCoordinate();
        Point startPoint = geometryFactory.createPoint(startCoordinate);
        HashSet<AreaEdge> edges = new HashSet<AreaEdge>();
        for (Area area : intersects) {
            IntersectionVertex newEndpoint;
            Geometry lineParts;
            MultiPolygon polygon = area.jtsMultiPolygon;
            if (!polygon.intersects((Geometry)startPoint) && !polygon.getBoundary().intersects((Geometry)startPoint) || !((lineParts = line.intersection((Geometry)polygon)).getLength() > 1.0E-6)) continue;
            Coordinate edgeCoordinate = null;
            if (lineParts instanceof MultiLineString) {
                MultiLineString mls = (MultiLineString)lineParts;
                boolean found = false;
                for (int i = 0; i < mls.getNumGeometries(); ++i) {
                    LineString segment = (LineString)mls.getGeometryN(i);
                    if (found) {
                        edgeCoordinate = segment.getEndPoint().getCoordinate();
                    } else {
                        if (!segment.contains((Geometry)startPoint) && !segment.getBoundary().contains((Geometry)startPoint)) continue;
                        found = true;
                        if (!(segment.getLength() > 1.0E-6)) continue;
                        edgeCoordinate = segment.getEndPoint().getCoordinate();
                    }
                    break;
                }
            } else {
                if (!(lineParts instanceof LineString)) continue;
                edgeCoordinate = ((LineString)lineParts).getEndPoint().getCoordinate();
            }
            if ((newEndpoint = this.areaBoundaryVertexForCoordinate.get(edgeCoordinate)) == null) {
                newEndpoint = new IntersectionVertex(this.graph, "area splitter at " + edgeCoordinate, edgeCoordinate.x, edgeCoordinate.y);
                this.areaBoundaryVertexForCoordinate.put(edgeCoordinate, newEndpoint);
            }
            edges.addAll(this.createSegments(startEndpoint, newEndpoint, List.of(area), edgeList));
            edges.addAll(this.createSegments(newEndpoint, endEndpoint, intersects, edgeList));
            return edges;
        }
        return Set.of();
    }

    private void createNamedAreas(AreaEdgeList edgeList, Ring ring, Collection<Area> areas) {
        Polygon containingArea = ring.jtsPolygon;
        for (Area area : areas) {
            Geometry intersection = containingArea.intersection((Geometry)area.jtsMultiPolygon);
            if (intersection.getArea() == 0.0) continue;
            NamedArea namedArea = new NamedArea();
            OSMWithTags areaEntity = area.parent;
            int cls = 5;
            namedArea.setStreetClass(cls |= OSMFilter.getStreetClasses(areaEntity));
            String id = "way (area) " + areaEntity.getId() + " (splitter linking)";
            I18NString name = this.handler.getNameForWay(areaEntity, id);
            namedArea.setName(name);
            if (!this.wayPropertiesCache.containsKey(areaEntity)) {
                WayProperties wayData = areaEntity.getOsmProvider().getWayPropertySet().getDataForWay(areaEntity);
                this.wayPropertiesCache.put(areaEntity, wayData);
            }
            Double bicycleSafety = this.wayPropertiesCache.get(areaEntity).getBicycleSafetyFeatures().forward();
            namedArea.setBicycleSafetyMultiplier(bicycleSafety);
            Double walkSafety = this.wayPropertiesCache.get(areaEntity).getWalkSafetyFeatures().forward();
            namedArea.setWalkSafetyMultiplier(walkSafety);
            namedArea.setOriginalEdges(intersection);
            StreetTraversalPermission permission = OSMFilter.getPermissionsForEntity(areaEntity, StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE);
            namedArea.setPermission(permission);
            edgeList.addArea(namedArea);
        }
    }

    private boolean isPlatformLinkingEndpoint(OsmVertex osmVertex) {
        boolean isCandidate = false;
        Vertex start = null;
        for (Edge e : osmVertex.getIncoming()) {
            if (!(e instanceof StreetEdge) || e instanceof AreaEdge) continue;
            Edge se = (StreetEdge)e;
            if (!Arrays.asList(1, 2, 3).contains(((StreetEdge)se).getPermission().code)) continue;
            isCandidate = true;
            start = se.getFromVertex();
            break;
        }
        if (isCandidate && start != null) {
            boolean isEndpoint = true;
            for (Edge se : osmVertex.getOutgoing()) {
                if (se.getToVertex().getCoordinate().equals((Object)start.getCoordinate()) || se instanceof AreaEdge) continue;
                isEndpoint = false;
            }
            return isEndpoint;
        }
        return false;
    }

    record ListedEdgesOnly(Set<Edge> edges) implements SkipEdgeStrategy
    {
        @Override
        public boolean shouldSkipEdge(State current, Edge edge) {
            return !this.edges.contains(edge);
        }
    }
}

