/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module.osm;

import ch.poole.openinghoursparser.OpeningHoursParseException;
import com.google.common.collect.Iterables;
import gnu.trove.list.TLongList;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.Set;
import java.util.stream.Collectors;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.opentripplanner.common.TurnRestriction;
import org.opentripplanner.common.geometry.SphericalDistanceLibrary;
import org.opentripplanner.common.model.P2;
import org.opentripplanner.common.model.T2;
import org.opentripplanner.graph_builder.DataImportIssueStore;
import org.opentripplanner.graph_builder.Issue;
import org.opentripplanner.graph_builder.issues.Graphwide;
import org.opentripplanner.graph_builder.issues.InvalidVehicleParkingCapacity;
import org.opentripplanner.graph_builder.issues.ParkAndRideUnlinked;
import org.opentripplanner.graph_builder.issues.StreetCarSpeedZero;
import org.opentripplanner.graph_builder.issues.TurnRestrictionBad;
import org.opentripplanner.graph_builder.model.GraphBuilderModule;
import org.opentripplanner.graph_builder.module.osm.Area;
import org.opentripplanner.graph_builder.module.osm.AreaGroup;
import org.opentripplanner.graph_builder.module.osm.OSMDatabase;
import org.opentripplanner.graph_builder.module.osm.OSMFilter;
import org.opentripplanner.graph_builder.module.osm.Ring;
import org.opentripplanner.graph_builder.module.osm.TurnRestrictionTag;
import org.opentripplanner.graph_builder.module.osm.VertexAndName;
import org.opentripplanner.graph_builder.module.osm.WalkableAreaBuilder;
import org.opentripplanner.graph_builder.module.osm.WayProperties;
import org.opentripplanner.graph_builder.module.osm.tagmapping.OsmTagMapper;
import org.opentripplanner.graph_builder.services.osm.CustomNamer;
import org.opentripplanner.model.StreetNote;
import org.opentripplanner.model.calendar.openinghours.OHCalendar;
import org.opentripplanner.openstreetmap.OSMOpeningHoursParser;
import org.opentripplanner.openstreetmap.OpenStreetMapProvider;
import org.opentripplanner.openstreetmap.model.OSMLevel;
import org.opentripplanner.openstreetmap.model.OSMNode;
import org.opentripplanner.openstreetmap.model.OSMWay;
import org.opentripplanner.openstreetmap.model.OSMWithTags;
import org.opentripplanner.routing.core.TraverseMode;
import org.opentripplanner.routing.edgetype.AreaEdge;
import org.opentripplanner.routing.edgetype.AreaEdgeList;
import org.opentripplanner.routing.edgetype.ElevatorAlightEdge;
import org.opentripplanner.routing.edgetype.ElevatorBoardEdge;
import org.opentripplanner.routing.edgetype.ElevatorHopEdge;
import org.opentripplanner.routing.edgetype.FreeEdge;
import org.opentripplanner.routing.edgetype.NamedArea;
import org.opentripplanner.routing.edgetype.StreetEdge;
import org.opentripplanner.routing.edgetype.StreetTraversalPermission;
import org.opentripplanner.routing.edgetype.VehicleParkingEdge;
import org.opentripplanner.routing.graph.Edge;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.graph.Vertex;
import org.opentripplanner.routing.services.notes.NoteMatcher;
import org.opentripplanner.routing.util.ElevationUtils;
import org.opentripplanner.routing.vehicle_parking.VehicleParking;
import org.opentripplanner.routing.vehicle_parking.VehicleParkingHelper;
import org.opentripplanner.routing.vehicle_parking.VehicleParkingService;
import org.opentripplanner.routing.vehicle_parking.VehicleParkingSpaces;
import org.opentripplanner.routing.vertextype.BarrierVertex;
import org.opentripplanner.routing.vertextype.ElevatorOffboardVertex;
import org.opentripplanner.routing.vertextype.ElevatorOnboardVertex;
import org.opentripplanner.routing.vertextype.ExitVertex;
import org.opentripplanner.routing.vertextype.IntersectionVertex;
import org.opentripplanner.routing.vertextype.OsmBoardingLocationVertex;
import org.opentripplanner.routing.vertextype.OsmVertex;
import org.opentripplanner.routing.vertextype.StreetVertex;
import org.opentripplanner.routing.vertextype.VehicleParkingEntranceVertex;
import org.opentripplanner.standalone.config.BuildConfig;
import org.opentripplanner.transit.model.basic.Accessibility;
import org.opentripplanner.transit.model.basic.I18NString;
import org.opentripplanner.transit.model.basic.LocalizedStringFormat;
import org.opentripplanner.transit.model.basic.NonLocalizedString;
import org.opentripplanner.transit.model.basic.WgsCoordinate;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.util.geometry.GeometryUtils;
import org.opentripplanner.util.logging.ProgressTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenStreetMapModule
implements GraphBuilderModule {
    private static final Logger LOG = LoggerFactory.getLogger(OpenStreetMapModule.class);
    private static final String VEHICLE_PARKING_OSM_FEED_ID = "OSM";
    private final Map<Vertex, Double> elevationData = new HashMap<Vertex, Double>();
    private final List<OpenStreetMapProvider> providers;
    private OSMOpeningHoursParser osmOpeningHoursParser;
    private final Set<String> boardingAreaRefTags;
    public boolean skipVisibility = false;
    public boolean platformEntriesLinking = false;
    public CustomNamer customNamer;
    public boolean ignoreWheelchairAccessibility = false;
    public boolean staticParkAndRide = true;
    public boolean staticBikeParkAndRide;
    public int maxAreaNodes = 500;
    public boolean banDiscouragedWalking = false;
    public boolean banDiscouragedBiking = false;
    private final DataImportIssueStore issueStore;
    private final OsmTagMapper osmTagMapper;
    private final Graph graph;

    public OpenStreetMapModule(Collection<OpenStreetMapProvider> providers, Set<String> boardingAreaRefTags, Graph graph, DataImportIssueStore issueStore, OsmTagMapper osmTagMapper) {
        this.providers = List.copyOf(providers);
        this.boardingAreaRefTags = boardingAreaRefTags;
        this.graph = graph;
        this.issueStore = issueStore;
        this.osmTagMapper = osmTagMapper;
    }

    public OpenStreetMapModule(BuildConfig config, Collection<OpenStreetMapProvider> providers, Set<String> boardingAreaRefTags, Graph graph, DataImportIssueStore issueStore) {
        this(List.copyOf(providers), boardingAreaRefTags, graph, issueStore, config.osmDefaults.osmOsmTagMapper);
        this.customNamer = config.customNamer;
        this.skipVisibility = !config.areaVisibility;
        this.platformEntriesLinking = config.platformEntriesLinking;
        this.staticBikeParkAndRide = config.staticBikeParkAndRide;
        this.staticParkAndRide = config.staticParkAndRide;
        this.banDiscouragedWalking = config.banDiscouragedWalking;
        this.banDiscouragedBiking = config.banDiscouragedBiking;
        this.maxAreaNodes = config.maxAreaNodes;
    }

    @Override
    public void buildGraph() {
        this.osmOpeningHoursParser = new OSMOpeningHoursParser(this.graph.getOpeningHoursCalendarService(), this.issueStore);
        OSMDatabase osmdb = new OSMDatabase(this.issueStore, this.boardingAreaRefTags);
        Handler handler = new Handler(this.graph, osmdb);
        for (OpenStreetMapProvider provider : this.providers) {
            LOG.info("Gathering OSM from provider: {}", (Object)provider);
            provider.readOSM(osmdb);
        }
        osmdb.postLoad();
        LOG.info("Using OSM way configuration from {}.", (Object)this.osmTagMapper.getClass().getSimpleName());
        LOG.info("Building street graph from OSM");
        handler.buildGraph();
        this.graph.hasStreets = true;
        this.graph.calculateEnvelope();
    }

    public Map<Vertex, Double> elevationDataOutput() {
        return this.elevationData;
    }

    @Override
    public void checkInputs() {
        for (OpenStreetMapProvider provider : this.providers) {
            provider.checkInputs();
        }
    }

    private Issue invalidDuration(OSMWithTags element, String v) {
        return Issue.issue("InvalidDuration", "Duration for osm node %d is not a number: '%s'; it's replaced with '-1' (unknown).", element.getId(), v);
    }

    protected class Handler {
        private static final String nodeLabelFormat = "osm:node:%d";
        private static final String levelnodeLabelFormat = "osm:node:%d:level:%s";
        private final Graph graph;
        private final OSMDatabase osmdb;
        private final HashMap<Long, HashMap<OSMLevel, OsmVertex>> multiLevelNodes = new HashMap();
        private final Map<Long, IntersectionVertex> intersectionNodes = new HashMap<Long, IntersectionVertex>();
        private float bestBikeSafety = 1.0f;
        private float bestWalkSafety = 1.0f;

        public Handler(Graph graph, OSMDatabase osmdb) {
            this.graph = graph;
            this.osmdb = osmdb;
        }

        public void buildGraph() {
            if (OpenStreetMapModule.this.staticParkAndRide) {
                this.processParkAndRideNodes(this.osmdb.getCarParkingNodes(), true);
            }
            if (OpenStreetMapModule.this.staticBikeParkAndRide) {
                this.processParkAndRideNodes(this.osmdb.getBikeParkingNodes(), false);
            }
            for (Area area : Iterables.concat(this.osmdb.getWalkableAreas(), this.osmdb.getParkAndRideAreas(), this.osmdb.getBikeParkingAreas())) {
                this.setWayName(area.parent);
            }
            this.initIntersectionNodes();
            this.buildBasicGraph();
            this.buildWalkableAreas(OpenStreetMapModule.this.skipVisibility, OpenStreetMapModule.this.platformEntriesLinking);
            if (OpenStreetMapModule.this.staticParkAndRide) {
                this.buildParkAndRideAreas();
            }
            if (OpenStreetMapModule.this.staticBikeParkAndRide) {
                this.buildBikeParkAndRideAreas();
            }
            this.buildElevatorEdges(this.graph);
            this.unifyTurnRestrictions();
            if (OpenStreetMapModule.this.customNamer != null) {
                OpenStreetMapModule.this.customNamer.postprocess(this.graph);
            }
            this.applySafetyFactors(this.graph);
        }

        protected void applyWayProperties(StreetEdge street, StreetEdge backStreet, WayProperties wayData, OSMWithTags way) {
            double walkSafety;
            double bicycleSafety;
            OsmTagMapper tagMapperForWay = way.getOsmProvider().getOsmTagMapper();
            Set<T2<StreetNote, NoteMatcher>> notes = way.getOsmProvider().getWayPropertySet().getNoteForWay(way);
            boolean motorVehicleNoThrough = tagMapperForWay.isMotorVehicleThroughTrafficExplicitlyDisallowed(way);
            boolean bicycleNoThrough = tagMapperForWay.isBicycleNoThroughTrafficExplicitlyDisallowed(way);
            boolean walkNoThrough = tagMapperForWay.isWalkNoThroughTrafficExplicitlyDisallowed(way);
            if (street != null) {
                bicycleSafety = wayData.getBicycleSafetyFeatures().forward();
                street.setBicycleSafetyFactor((float)bicycleSafety);
                if (bicycleSafety < (double)this.bestBikeSafety) {
                    this.bestBikeSafety = (float)bicycleSafety;
                }
                walkSafety = wayData.getWalkSafetyFeatures().forward();
                street.setWalkSafetyFactor((float)walkSafety);
                if (walkSafety < (double)this.bestWalkSafety) {
                    this.bestWalkSafety = (float)walkSafety;
                }
                if (notes != null) {
                    for (T2<StreetNote, NoteMatcher> note : notes) {
                        this.graph.streetNotesService.addStaticNote(street, (StreetNote)note.first, (NoteMatcher)note.second);
                    }
                }
                street.setMotorVehicleNoThruTraffic(motorVehicleNoThrough);
                street.setBicycleNoThruTraffic(bicycleNoThrough);
                street.setWalkNoThruTraffic(walkNoThrough);
            }
            if (backStreet != null) {
                bicycleSafety = wayData.getBicycleSafetyFeatures().back();
                if (bicycleSafety < (double)this.bestBikeSafety) {
                    this.bestBikeSafety = (float)bicycleSafety;
                }
                backStreet.setBicycleSafetyFactor((float)bicycleSafety);
                walkSafety = wayData.getWalkSafetyFeatures().back();
                if (walkSafety < (double)this.bestWalkSafety) {
                    this.bestWalkSafety = (float)walkSafety;
                }
                backStreet.setWalkSafetyFactor((float)walkSafety);
                if (notes != null) {
                    for (T2<StreetNote, NoteMatcher> note : notes) {
                        this.graph.streetNotesService.addStaticNote(backStreet, (StreetNote)note.first, (NoteMatcher)note.second);
                    }
                }
                backStreet.setMotorVehicleNoThruTraffic(motorVehicleNoThrough);
                backStreet.setBicycleNoThruTraffic(bicycleNoThrough);
                backStreet.setWalkNoThruTraffic(walkNoThrough);
            }
        }

        protected I18NString getNameForWay(OSMWithTags way, String id) {
            I18NString name = way.getAssumedName();
            if (OpenStreetMapModule.this.customNamer != null && name != null) {
                name = new NonLocalizedString(OpenStreetMapModule.this.customNamer.name(way, name.toString()));
            }
            if (name == null) {
                name = new NonLocalizedString(id);
            }
            return name;
        }

        protected IntersectionVertex getVertexForOsmNode(OSMNode node, OSMWithTags way) {
            IntersectionVertex iv = null;
            if (node.isMultiLevel()) {
                return this.recordLevel(node, way);
            }
            long nid = node.getId();
            iv = this.intersectionNodes.get(nid);
            if (iv == null) {
                Set<String> refs;
                String ref;
                Coordinate coordinate = this.getCoordinate(node);
                String label = this.getNodeLabel(node);
                String highway = node.getTag("highway");
                if ("motorway_junction".equals(highway) && (ref = node.getTag("ref")) != null) {
                    ExitVertex ev = new ExitVertex(this.graph, label, coordinate.x, coordinate.y, nid);
                    ev.setExitName(ref);
                    iv = ev;
                }
                if (node.isBoardingLocation() && !(refs = node.getMultiTagValues(OpenStreetMapModule.this.boardingAreaRefTags)).isEmpty()) {
                    String name = node.getTag("name");
                    iv = new OsmBoardingLocationVertex(this.graph, label, coordinate.x, coordinate.y, NonLocalizedString.ofNullable(name), refs);
                }
                if (node.isBarrier()) {
                    BarrierVertex bv = new BarrierVertex(this.graph, label, coordinate.x, coordinate.y, nid);
                    bv.setBarrierPermissions(OSMFilter.getPermissionsForEntity(node, BarrierVertex.defaultBarrierPermissions));
                    iv = bv;
                }
                if (iv == null) {
                    iv = new OsmVertex(this.graph, label, coordinate.x, coordinate.y, node.getId(), new NonLocalizedString(label));
                    if (node.hasTrafficLight()) {
                        iv.trafficLight = true;
                    }
                }
                this.intersectionNodes.put(nid, iv);
            }
            return iv;
        }

        private OptionalInt parseCapacity(OSMWithTags element) {
            return this.parseCapacity(element, "capacity");
        }

        private OptionalInt parseCapacity(OSMWithTags element, String capacityTag) {
            return element.getTagAsInt(capacityTag, v -> OpenStreetMapModule.this.issueStore.add(new InvalidVehicleParkingCapacity(element.getId(), (String)v)));
        }

        private OptionalInt parseDuration(OSMWithTags element) {
            return element.getTagAsInt("duration", v -> OpenStreetMapModule.this.issueStore.add(OpenStreetMapModule.this.invalidDuration(element, (String)v)));
        }

        private void processParkAndRideNodes(Collection<OSMNode> nodes, boolean isCarParkAndRide) {
            LOG.info("Processing {} P+R nodes.", (Object)(isCarParkAndRide ? "car" : "bike"));
            int n = 0;
            VehicleParkingService vehicleParkingService = this.graph.getVehicleParkingService();
            ArrayList<VehicleParking> vehicleParkingToAdd = new ArrayList<VehicleParking>();
            for (OSMNode node : nodes) {
                ++n;
                I18NString creativeName = this.nameParkAndRideEntity(node);
                VehicleParking.VehicleParkingEntranceCreator entrance = builder -> builder.entranceId(new FeedScopedId(OpenStreetMapModule.VEHICLE_PARKING_OSM_FEED_ID, String.format("%s/%s/entrance", node.getClass().getSimpleName(), node.getId()))).name(creativeName).coordinate(new WgsCoordinate(node.getCoordinate())).walkAccessible(true).carAccessible(isCarParkAndRide);
                VehicleParking vehicleParking = this.createVehicleParkingObjectFromOsmEntity(isCarParkAndRide, node.getCoordinate(), node, creativeName, List.of(entrance));
                vehicleParkingToAdd.add(vehicleParking);
                VehicleParkingEntranceVertex parkVertex = new VehicleParkingEntranceVertex(this.graph, vehicleParking.getEntrances().get(0));
                new VehicleParkingEdge(parkVertex);
            }
            if (!vehicleParkingToAdd.isEmpty()) {
                vehicleParkingService.updateVehicleParking(vehicleParkingToAdd, List.of());
            }
            LOG.info("Created {} {} P+R nodes.", (Object)n, (Object)(isCarParkAndRide ? "car" : "bike"));
        }

        private void buildBikeParkAndRideAreas() {
            LOG.info("Building bike P+R areas");
            List<AreaGroup> areaGroups = this.groupAreas(this.osmdb.getBikeParkingAreas());
            List<VehicleParking> vehicleParkingToAdd = this.buildParkAndRideAreasForGroups(areaGroups, false);
            if (!vehicleParkingToAdd.isEmpty()) {
                this.graph.hasBikeRide = true;
                VehicleParkingService vehicleParkingService = this.graph.getVehicleParkingService();
                vehicleParkingService.updateVehicleParking(vehicleParkingToAdd, List.of());
            }
            LOG.info("Created {} bike P+R areas.", (Object)vehicleParkingToAdd.size());
        }

        private void buildParkAndRideAreas() {
            LOG.info("Building car P+R areas");
            List<AreaGroup> areaGroups = this.groupAreas(this.osmdb.getParkAndRideAreas());
            List<VehicleParking> vehicleParkingToAdd = this.buildParkAndRideAreasForGroups(areaGroups, true);
            if (!vehicleParkingToAdd.isEmpty()) {
                this.graph.hasParkRide = true;
                VehicleParkingService vehicleParkingService = this.graph.getVehicleParkingService();
                vehicleParkingService.updateVehicleParking(vehicleParkingToAdd, List.of());
            }
            LOG.info("Created {} car P+R areas.", (Object)vehicleParkingToAdd.size());
        }

        private List<VehicleParking> buildParkAndRideAreasForGroups(List<AreaGroup> areaGroups, boolean isCarParkAndRide) {
            ArrayList<VehicleParking> vehicleParkingToAdd = new ArrayList<VehicleParking>();
            for (AreaGroup group : areaGroups) {
                VehicleParking vehicleParking = this.buildParkAndRideAreasForGroup(group, isCarParkAndRide);
                if (vehicleParking == null) continue;
                vehicleParkingToAdd.add(vehicleParking);
            }
            return vehicleParkingToAdd;
        }

        private VehicleParking buildParkAndRideAreasForGroup(AreaGroup group, boolean isCarParkAndRide) {
            Envelope envelope = new Envelope();
            HashSet<VertexAndName> accessVertices = new HashSet<VertexAndName>();
            OSMWithTags entity = null;
            for (Area area : group.areas) {
                entity = area.parent;
                List<VertexAndName> areaAccessVertices = this.processVehicleParkingArea(area, envelope);
                accessVertices.addAll(areaAccessVertices);
            }
            if (entity == null) {
                return null;
            }
            I18NString creativeName = this.nameParkAndRideEntity(entity);
            boolean walkAccessibleIn = false;
            boolean carAccessibleIn = false;
            boolean walkAccessibleOut = false;
            boolean carAccessibleOut = false;
            for (VertexAndName access : accessVertices) {
                StreetEdge streetEdge;
                IntersectionVertex accessVertex = access.getVertex();
                for (Edge incoming : accessVertex.getIncoming()) {
                    if (!(incoming instanceof StreetEdge)) continue;
                    streetEdge = (StreetEdge)incoming;
                    if (streetEdge.canTraverse(TraverseMode.WALK)) {
                        walkAccessibleIn = true;
                    }
                    if (!streetEdge.canTraverse(TraverseMode.CAR)) continue;
                    carAccessibleIn = true;
                }
                for (Edge outgoing : accessVertex.getOutgoing()) {
                    if (!(outgoing instanceof StreetEdge)) continue;
                    streetEdge = (StreetEdge)outgoing;
                    if (streetEdge.canTraverse(TraverseMode.WALK)) {
                        walkAccessibleOut = true;
                    }
                    if (!streetEdge.canTraverse(TraverseMode.CAR)) continue;
                    carAccessibleOut = true;
                }
            }
            if (walkAccessibleIn != walkAccessibleOut) {
                LOG.error("P+R walk IN/OUT accessibility mismatch! Please have a look as this should not happen.");
            }
            if (isCarParkAndRide) {
                if (!(walkAccessibleOut && carAccessibleIn && walkAccessibleIn && carAccessibleOut)) {
                    OpenStreetMapModule.this.issueStore.add(new ParkAndRideUnlinked(creativeName.toString(), entity));
                    return null;
                }
            } else if (!walkAccessibleOut || !walkAccessibleIn) {
                OpenStreetMapModule.this.issueStore.add(new ParkAndRideUnlinked(creativeName.toString(), entity));
                return null;
            }
            List<VehicleParking.VehicleParkingEntranceCreator> entrances = this.createParkingEntrancesFromAccessVertices(accessVertices, creativeName, entity);
            VehicleParking vehicleParking = this.createVehicleParkingObjectFromOsmEntity(isCarParkAndRide, envelope.centre(), entity, creativeName, entrances);
            VehicleParkingHelper.linkVehicleParkingToGraph(this.graph, vehicleParking);
            return vehicleParking;
        }

        private VehicleParking createVehicleParkingObjectFromOsmEntity(boolean isCarParkAndRide, Coordinate coordinate, OSMWithTags entity, I18NString creativeName, List<VehicleParking.VehicleParkingEntranceCreator> entrances) {
            OptionalInt wheelchairAccessibleCarCapacity;
            OptionalInt bicycleCapacity;
            OptionalInt carCapacity;
            if (isCarParkAndRide) {
                carCapacity = this.parseCapacity(entity);
                bicycleCapacity = this.parseCapacity(entity, "capacity:bike");
                wheelchairAccessibleCarCapacity = this.parseCapacity(entity, "capacity:disabled");
            } else {
                bicycleCapacity = this.parseCapacity(entity);
                carCapacity = OptionalInt.empty();
                wheelchairAccessibleCarCapacity = OptionalInt.empty();
            }
            VehicleParkingSpaces vehicleParkingSpaces = null;
            if (bicycleCapacity.isPresent() || carCapacity.isPresent() || wheelchairAccessibleCarCapacity.isPresent()) {
                vehicleParkingSpaces = VehicleParkingSpaces.builder().bicycleSpaces(bicycleCapacity.isPresent() ? Integer.valueOf(bicycleCapacity.getAsInt()) : null).carSpaces(carCapacity.isPresent() ? Integer.valueOf(carCapacity.getAsInt()) : null).wheelchairAccessibleCarSpaces(wheelchairAccessibleCarCapacity.isPresent() ? Integer.valueOf(wheelchairAccessibleCarCapacity.getAsInt()) : null).build();
            }
            boolean bicyclePlaces = !isCarParkAndRide || bicycleCapacity.orElse(0) > 0;
            boolean carPlaces = isCarParkAndRide && wheelchairAccessibleCarCapacity.isEmpty() && carCapacity.isEmpty() || carCapacity.orElse(0) > 0;
            boolean wheelchairAccessibleCarPlaces = wheelchairAccessibleCarCapacity.orElse(0) > 0;
            OHCalendar openingHours = this.parseOpeningHours(entity);
            FeedScopedId id = new FeedScopedId(OpenStreetMapModule.VEHICLE_PARKING_OSM_FEED_ID, String.format("%s/%d", entity.getClass().getSimpleName(), entity.getId()));
            ArrayList<String> tags = new ArrayList<String>();
            tags.add(isCarParkAndRide ? "osm:amenity=parking" : "osm:amenity=bicycle_parking");
            if (entity.isTagTrue("fee")) {
                tags.add("osm:fee");
            }
            if (entity.hasTag("supervised") && !entity.isTagTrue("supervised")) {
                tags.add("osm:supervised");
            }
            if (entity.hasTag("covered") && !entity.isTagFalse("covered")) {
                tags.add("osm:covered");
            }
            if (entity.hasTag("surveillance") && !entity.isTagFalse("surveillance")) {
                tags.add("osm:surveillance");
            }
            return VehicleParking.builder().id(id).name(creativeName).coordinate(new WgsCoordinate(coordinate)).tags(tags).detailsUrl(entity.getTag("website")).openingHoursCalendar(openingHours).bicyclePlaces(bicyclePlaces).carPlaces(carPlaces).wheelchairAccessibleCarPlaces(wheelchairAccessibleCarPlaces).capacity(vehicleParkingSpaces).entrances(entrances).build();
        }

        private OHCalendar parseOpeningHours(OSMWithTags entity) {
            String openingHoursTag = entity.getTag("opening_hours");
            if (openingHoursTag != null) {
                ZoneId zoneId = entity.getOsmProvider().getZoneId();
                long id = entity.getId();
                String link = entity.getOpenStreetMapLink();
                try {
                    return OpenStreetMapModule.this.osmOpeningHoursParser.parseOpeningHours(openingHoursTag, String.valueOf(id), link, zoneId);
                }
                catch (OpeningHoursParseException e) {
                    OpenStreetMapModule.this.issueStore.add("OSMOpeningHoursUnparsed", "OSM object with id '%s' (%s) has an invalid opening_hours value, it will always be open", id, link);
                }
            }
            return null;
        }

        private I18NString nameParkAndRideEntity(OSMWithTags osmWithTags) {
            I18NString creativeName = osmWithTags.getAssumedName();
            if (creativeName == null) {
                creativeName = osmWithTags.getOsmProvider().getWayPropertySet().getCreativeNameForWay(osmWithTags);
            }
            if (creativeName == null) {
                creativeName = new NonLocalizedString("Park & Ride (%s/%d)".formatted(osmWithTags.getClass().getSimpleName(), osmWithTags.getId()));
            }
            return creativeName;
        }

        private List<VertexAndName> processVehicleParkingArea(Area area, Envelope envelope) {
            return area.outermostRings.stream().flatMap(ring -> this.processVehicleParkingArea((Ring)ring, area.parent, envelope).stream()).collect(Collectors.toList());
        }

        private List<VertexAndName> processVehicleParkingArea(Ring ring, OSMWithTags entity, Envelope envelope) {
            ArrayList<VertexAndName> accessVertices = new ArrayList<VertexAndName>();
            for (OSMNode node : ring.nodes) {
                envelope.expandToInclude(new Coordinate(node.lon, node.lat));
                IntersectionVertex accessVertex = this.getVertexForOsmNode(node, entity);
                if (accessVertex.getIncoming().isEmpty() || accessVertex.getOutgoing().isEmpty()) continue;
                accessVertices.add(new VertexAndName(node.getAssumedName(), accessVertex));
            }
            accessVertices.addAll(ring.getHoles().stream().flatMap(innerRing -> this.processVehicleParkingArea((Ring)innerRing, entity, envelope).stream()).collect(Collectors.toList()));
            return accessVertices;
        }

        private List<VehicleParking.VehicleParkingEntranceCreator> createParkingEntrancesFromAccessVertices(Set<VertexAndName> accessVertices, I18NString vehicleParkingName, OSMWithTags entity) {
            ArrayList<VehicleParking.VehicleParkingEntranceCreator> entrances = new ArrayList<VehicleParking.VehicleParkingEntranceCreator>();
            List<VertexAndName> sortedAccessVertices = accessVertices.stream().sorted(Comparator.comparing(vn -> vn.getVertex().getLabel())).toList();
            for (VertexAndName access : sortedAccessVertices) {
                I18NString suffix = null;
                if (access.getName() != null) {
                    suffix = access.getName();
                }
                if (suffix == null) {
                    suffix = new NonLocalizedString(String.format("#%d", entrances.size() + 1));
                }
                LocalizedStringFormat entranceName = new LocalizedStringFormat("%s (%s)", vehicleParkingName, suffix);
                entrances.add(builder -> builder.entranceId(new FeedScopedId(OpenStreetMapModule.VEHICLE_PARKING_OSM_FEED_ID, String.format("%s/%d/%s", entity.getClass().getSimpleName(), entity.getId(), access.getVertex().getLabel()))).name(entranceName).coordinate(new WgsCoordinate(access.getVertex().getCoordinate())).vertex(access.getVertex()).walkAccessible(access.getVertex().isConnectedToWalkingEdge()).carAccessible(access.getVertex().isConnectedToDriveableEdge()));
            }
            return entrances;
        }

        private List<AreaGroup> groupAreas(Collection<Area> areas) {
            HashMap<Area, OSMLevel> areasLevels = new HashMap<Area, OSMLevel>(areas.size());
            for (Area area : areas) {
                areasLevels.put(area, this.osmdb.getLevelForWay(area.parent));
            }
            return AreaGroup.groupAreas(areasLevels);
        }

        private void buildWalkableAreas(boolean skipVisibility, boolean platformEntriesLinking) {
            if (skipVisibility) {
                LOG.info("Skipping visibility graph construction for walkable areas and using just area rings for edges.");
            } else {
                LOG.info("Building visibility graphs for walkable areas.");
            }
            List<AreaGroup> areaGroups = this.groupAreas(this.osmdb.getWalkableAreas());
            WalkableAreaBuilder walkableAreaBuilder = new WalkableAreaBuilder(this.graph, this.osmdb, this, OpenStreetMapModule.this.issueStore, OpenStreetMapModule.this.maxAreaNodes, platformEntriesLinking, OpenStreetMapModule.this.boardingAreaRefTags);
            if (skipVisibility) {
                for (AreaGroup group : areaGroups) {
                    walkableAreaBuilder.buildWithoutVisibility(group);
                }
            } else {
                ProgressTracker progress = ProgressTracker.track("Build visibility graph for areas", 50, areaGroups.size());
                for (AreaGroup group : areaGroups) {
                    walkableAreaBuilder.buildWithVisibility(group);
                    progress.step(m -> LOG.info(m));
                }
                LOG.info(progress.completeMessage());
            }
            if (skipVisibility) {
                LOG.info("Done building rings for walkable areas.");
            } else {
                LOG.info("Done building visibility graphs for walkable areas.");
            }
        }

        private void buildBasicGraph() {
            long wayCount = this.osmdb.getWays().size();
            ProgressTracker progress = ProgressTracker.track("Build street graph", 5000, wayCount);
            LOG.info(progress.startMessage());
            block0: for (OSMWay way : this.osmdb.getWays()) {
                WayProperties wayData = way.getOsmProvider().getWayPropertySet().getDataForWay(way);
                this.setWayName(way);
                StreetTraversalPermission permissions = OSMFilter.getPermissionsForWay(way, wayData.getPermission(), OpenStreetMapModule.this.banDiscouragedWalking, OpenStreetMapModule.this.banDiscouragedBiking, OpenStreetMapModule.this.issueStore);
                if (!OSMFilter.isWayRoutable(way) || permissions.allowsNothing()) continue;
                ArrayList<Long> nodes = new ArrayList<Long>(way.getNodeRefs().size());
                long last = -1L;
                double lastLat = -1.0;
                double lastLon = -1.0;
                String lastLevel = null;
                for (long nodeId : way.getNodeRefs()) {
                    OSMNode node = this.osmdb.getNode(nodeId);
                    if (node == null) continue block0;
                    boolean levelsDiffer = false;
                    String level = node.getTag("level");
                    if (lastLevel == null) {
                        if (level != null) {
                            levelsDiffer = true;
                        }
                    } else if (!lastLevel.equals(level)) {
                        levelsDiffer = true;
                    }
                    if (nodeId != last && (node.lat != lastLat || node.lon != lastLon || levelsDiffer)) {
                        nodes.add(nodeId);
                    }
                    last = nodeId;
                    lastLon = node.lon;
                    lastLat = node.lat;
                    lastLevel = level;
                }
                IntersectionVertex startEndpoint = null;
                IntersectionVertex endEndpoint = null;
                ArrayList<Coordinate> segmentCoordinates = new ArrayList<Coordinate>();
                Long startNode = null;
                OSMNode osmStartNode = null;
                for (int i = 0; i < nodes.size() - 1; ++i) {
                    Double elevation;
                    String ele;
                    OSMNode segmentStartOSMNode = this.osmdb.getNode((Long)nodes.get(i));
                    if (segmentStartOSMNode == null) continue;
                    Long endNode = (Long)nodes.get(i + 1);
                    if (osmStartNode == null) {
                        startNode = (Long)nodes.get(i);
                        osmStartNode = segmentStartOSMNode;
                    }
                    OSMNode osmEndNode = this.osmdb.getNode(endNode);
                    if (segmentCoordinates.size() == 0) {
                        segmentCoordinates.add(this.getCoordinate(osmStartNode));
                    }
                    if (!(this.intersectionNodes.containsKey(endNode) || i == nodes.size() - 2 || nodes.subList(0, i).contains(nodes.get(i)) || osmEndNode.hasTag("ele") || osmEndNode.isBoardingLocation() || osmEndNode.isBarrier())) {
                        segmentCoordinates.add(this.getCoordinate(osmEndNode));
                        continue;
                    }
                    segmentCoordinates.add(this.getCoordinate(osmEndNode));
                    LineString geometry = GeometryUtils.getGeometryFactory().createLineString(segmentCoordinates.toArray(new Coordinate[0]));
                    segmentCoordinates.clear();
                    if (startEndpoint == null) {
                        startEndpoint = this.getVertexForOsmNode(osmStartNode, way);
                        ele = segmentStartOSMNode.getTag("ele");
                        if (ele != null && (elevation = ElevationUtils.parseEleTag(ele)) != null) {
                            OpenStreetMapModule.this.elevationData.put(startEndpoint, elevation);
                        }
                    } else {
                        startEndpoint = endEndpoint;
                    }
                    endEndpoint = this.getVertexForOsmNode(osmEndNode, way);
                    ele = osmEndNode.getTag("ele");
                    if (ele != null && (elevation = ElevationUtils.parseEleTag(ele)) != null) {
                        OpenStreetMapModule.this.elevationData.put(endEndpoint, elevation);
                    }
                    P2<StreetEdge> streets = this.getEdgesForStreet(startEndpoint, endEndpoint, way, i, osmStartNode.getId(), osmEndNode.getId(), permissions, geometry);
                    StreetEdge street = (StreetEdge)streets.first;
                    StreetEdge backStreet = (StreetEdge)streets.second;
                    this.applyWayProperties(street, backStreet, wayData, way);
                    this.applyEdgesToTurnRestrictions(way, startNode, endNode, street, backStreet);
                    startNode = endNode;
                    osmStartNode = this.osmdb.getNode(startNode);
                }
                progress.step(m -> LOG.info(m));
            }
            LOG.info(progress.completeMessage());
        }

        private void setWayName(OSMWithTags way) {
            I18NString creativeName;
            if (!way.hasTag("name") && (creativeName = way.getOsmProvider().getWayPropertySet().getCreativeNameForWay(way)) != null) {
                way.setCreativeName(creativeName);
            }
        }

        private void buildElevatorEdges(Graph graph) {
            for (Long nodeId : this.multiLevelNodes.keySet()) {
                OSMNode node = this.osmdb.getNode(nodeId);
                HashMap<OSMLevel, OsmVertex> vertices = this.multiLevelNodes.get(nodeId);
                Object[] levels = vertices.keySet().toArray(new OSMLevel[0]);
                Arrays.sort(levels);
                ArrayList<Vertex> onboardVertices = new ArrayList<Vertex>();
                for (Object level : levels) {
                    OsmVertex sourceVertex = vertices.get(level);
                    String sourceVertexLabel = sourceVertex.getLabel();
                    String levelName = ((OSMLevel)level).longName;
                    this.createElevatorVertices(graph, onboardVertices, sourceVertex, sourceVertexLabel, levelName);
                }
                int travelTime = this.parseDuration(node).orElse(-1);
                Accessibility wheelchair = node.getWheelchairAccessibility();
                this.createElevatorHopEdges(onboardVertices, wheelchair, node.isTagTrue("bicycle"), levels.length, travelTime);
            }
            Iterator elevators = this.osmdb.getWays().stream().filter(this::isElevatorWay).iterator();
            while (elevators.hasNext()) {
                OSMWay elevatorWay = (OSMWay)elevators.next();
                List<Long> nodes = Arrays.stream(elevatorWay.getNodeRefs().toArray()).filter(nodeRef -> this.intersectionNodes.containsKey(nodeRef) && this.intersectionNodes.get(nodeRef) != null).boxed().toList();
                ArrayList<Vertex> onboardVertices = new ArrayList<Vertex>();
                for (int i = 0; i < nodes.size(); ++i) {
                    Long node = nodes.get(i);
                    IntersectionVertex sourceVertex = this.intersectionNodes.get(node);
                    String sourceVertexLabel = sourceVertex.getLabel();
                    String levelName = elevatorWay.getId() + " / " + i;
                    this.createElevatorVertices(graph, onboardVertices, sourceVertex, elevatorWay.getId() + "_" + sourceVertexLabel, levelName);
                }
                int travelTime = this.parseDuration(elevatorWay).orElse(-1);
                int levels = nodes.size();
                Accessibility wheelchair = elevatorWay.getWheelchairAccessibility();
                this.createElevatorHopEdges(onboardVertices, wheelchair, elevatorWay.isTagTrue("bicycle"), levels, travelTime);
                LOG.debug("Created elevatorHopEdges for way {}", (Object)elevatorWay.getId());
            }
        }

        private boolean isElevatorWay(OSMWay way) {
            if (!way.hasTag("highway")) {
                return false;
            }
            if (!"elevator".equals(way.getTag("highway"))) {
                return false;
            }
            if (this.osmdb.isAreaWay(way.getId())) {
                return false;
            }
            TLongList nodeRefs = way.getNodeRefs();
            return nodeRefs.get(0) != nodeRefs.get(nodeRefs.size() - 1);
        }

        private void createElevatorVertices(Graph graph, ArrayList<Vertex> onboardVertices, IntersectionVertex sourceVertex, String sourceVertexLabel, String levelName) {
            ElevatorOffboardVertex offboardVertex = new ElevatorOffboardVertex(graph, sourceVertexLabel + "_offboard", sourceVertex.getX(), sourceVertex.getY(), new NonLocalizedString(levelName));
            new FreeEdge(sourceVertex, offboardVertex);
            new FreeEdge(offboardVertex, sourceVertex);
            ElevatorOnboardVertex onboardVertex = new ElevatorOnboardVertex(graph, sourceVertexLabel + "_onboard", sourceVertex.getX(), sourceVertex.getY(), new NonLocalizedString(levelName));
            new ElevatorBoardEdge(offboardVertex, onboardVertex);
            new ElevatorAlightEdge(onboardVertex, offboardVertex, new NonLocalizedString(levelName));
            onboardVertices.add(onboardVertex);
        }

        private void createElevatorHopEdges(ArrayList<Vertex> onboardVertices, Accessibility wheelchair, boolean bicycleAllowed, int levels, int travelTime) {
            int vSize = onboardVertices.size() - 1;
            for (int i = 0; i < vSize; ++i) {
                StreetTraversalPermission permission;
                Vertex from = onboardVertices.get(i);
                Vertex to = onboardVertices.get(i + 1);
                StreetTraversalPermission streetTraversalPermission = permission = bicycleAllowed ? StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE : StreetTraversalPermission.PEDESTRIAN;
                if (travelTime > -1 && levels > 0) {
                    ElevatorHopEdge.bidirectional(from, to, permission, wheelchair, levels, travelTime);
                    continue;
                }
                ElevatorHopEdge.bidirectional(from, to, permission, wheelchair);
            }
        }

        private void unifyTurnRestrictions() {
            for (Long fromWay : this.osmdb.getTurnRestrictionWayIds()) {
                for (TurnRestrictionTag restrictionTag : this.osmdb.getFromWayTurnRestrictions(fromWay)) {
                    if (restrictionTag.possibleFrom.isEmpty()) {
                        OpenStreetMapModule.this.issueStore.add(new TurnRestrictionBad(restrictionTag.relationOSMID, "No from edge found"));
                        continue;
                    }
                    if (restrictionTag.possibleTo.isEmpty()) {
                        OpenStreetMapModule.this.issueStore.add(new TurnRestrictionBad(restrictionTag.relationOSMID, "No to edge found"));
                        continue;
                    }
                    for (StreetEdge from : restrictionTag.possibleFrom) {
                        if (from == null) {
                            OpenStreetMapModule.this.issueStore.add(new TurnRestrictionBad(restrictionTag.relationOSMID, "from-edge is null"));
                            continue;
                        }
                        block9: for (StreetEdge to : restrictionTag.possibleTo) {
                            if (to == null) {
                                OpenStreetMapModule.this.issueStore.add(new TurnRestrictionBad(restrictionTag.relationOSMID, "to-edge is null"));
                                continue;
                            }
                            int angleDiff = from.getOutAngle() - to.getInAngle();
                            if (angleDiff < 0) {
                                angleDiff += 360;
                            }
                            switch (restrictionTag.direction) {
                                case LEFT: {
                                    if (angleDiff < 160) break;
                                    OpenStreetMapModule.this.issueStore.add(new TurnRestrictionBad(restrictionTag.relationOSMID, "Left turn restriction is not on edges which turn left"));
                                    continue block9;
                                }
                                case RIGHT: {
                                    if (angleDiff > 200) break;
                                    OpenStreetMapModule.this.issueStore.add(new TurnRestrictionBad(restrictionTag.relationOSMID, "Right turn restriction is not on edges which turn right"));
                                    continue block9;
                                }
                                case U: {
                                    if (angleDiff > 150 && angleDiff <= 210) break;
                                    OpenStreetMapModule.this.issueStore.add(new TurnRestrictionBad(restrictionTag.relationOSMID, "U-turn restriction is not on U-turn"));
                                    continue block9;
                                }
                                case STRAIGHT: {
                                    if (angleDiff < 30 || angleDiff >= 330) break;
                                    OpenStreetMapModule.this.issueStore.add(new TurnRestrictionBad(restrictionTag.relationOSMID, "Straight turn restriction is not on edges which go straight"));
                                    continue block9;
                                }
                            }
                            TurnRestriction restriction = new TurnRestriction(from, to, restrictionTag.type, restrictionTag.modes, restrictionTag.time);
                            from.addTurnRestriction(restriction);
                        }
                    }
                }
            }
        }

        private void applyEdgesToTurnRestrictions(OSMWay way, long startNode, long endNode, StreetEdge street, StreetEdge backStreet) {
            Collection<TurnRestrictionTag> restrictionTags = this.osmdb.getFromWayTurnRestrictions(way.getId());
            if (restrictionTags != null) {
                for (TurnRestrictionTag tag : restrictionTags) {
                    if (tag.via == startNode) {
                        tag.possibleFrom.add(backStreet);
                        continue;
                    }
                    if (tag.via != endNode) continue;
                    tag.possibleFrom.add(street);
                }
            }
            if ((restrictionTags = this.osmdb.getToWayTurnRestrictions(way.getId())) != null) {
                for (TurnRestrictionTag tag : restrictionTags) {
                    if (tag.via == startNode) {
                        tag.possibleTo.add(street);
                        continue;
                    }
                    if (tag.via != endNode) continue;
                    tag.possibleTo.add(backStreet);
                }
            }
        }

        private void initIntersectionNodes() {
            HashSet<Long> possibleIntersectionNodes = new HashSet<Long>();
            for (OSMWay way : this.osmdb.getWays()) {
                TLongList nodes = way.getNodeRefs();
                nodes.forEach(node -> {
                    if (possibleIntersectionNodes.contains(node)) {
                        this.intersectionNodes.put(node, null);
                    } else {
                        possibleIntersectionNodes.add(node);
                    }
                    return true;
                });
            }
            for (Area area : Iterables.concat(this.osmdb.getWalkableAreas(), this.osmdb.getParkAndRideAreas(), this.osmdb.getBikeParkingAreas())) {
                for (Ring outerRing : area.outermostRings) {
                    this.intersectAreaRingNodes(possibleIntersectionNodes, outerRing);
                }
            }
        }

        private void intersectAreaRingNodes(Set<Long> possibleIntersectionNodes, Ring outerRing) {
            for (OSMNode node : outerRing.nodes) {
                long nodeId = node.getId();
                if (possibleIntersectionNodes.contains(nodeId)) {
                    this.intersectionNodes.put(nodeId, null);
                    continue;
                }
                possibleIntersectionNodes.add(nodeId);
            }
            outerRing.getHoles().forEach(hole -> this.intersectAreaRingNodes(possibleIntersectionNodes, (Ring)hole));
        }

        private void applySafetyFactors(Graph graph) {
            OpenStreetMapModule.this.issueStore.add(new Graphwide("Multiplying all bike safety values by " + 1.0f / this.bestBikeSafety));
            OpenStreetMapModule.this.issueStore.add(new Graphwide("Multiplying all walk safety values by " + 1.0f / this.bestWalkSafety));
            HashSet<Edge> seenEdges = new HashSet<Edge>();
            HashSet<AreaEdgeList> seenAreas = new HashSet<AreaEdgeList>();
            for (Vertex vertex : graph.getVertices()) {
                StreetEdge pse;
                for (Edge e : vertex.getOutgoing()) {
                    if (e instanceof AreaEdge) {
                        AreaEdgeList areaEdgeList = ((AreaEdge)e).getArea();
                        if (seenAreas.contains(areaEdgeList)) continue;
                        seenAreas.add(areaEdgeList);
                        for (NamedArea area : areaEdgeList.getAreas()) {
                            area.setBicycleSafetyMultiplier(area.getBicycleSafetyMultiplier() / (double)this.bestBikeSafety);
                            area.setWalkSafetyMultiplier(area.getWalkSafetyMultiplier() / (double)this.bestWalkSafety);
                        }
                    }
                    if (!(e instanceof StreetEdge)) continue;
                    pse = (StreetEdge)e;
                    if (seenEdges.contains(e)) continue;
                    seenEdges.add(e);
                    pse.setBicycleSafetyFactor(pse.getBicycleSafetyFactor() / this.bestBikeSafety);
                    pse.setWalkSafetyFactor(pse.getWalkSafetyFactor() / this.bestWalkSafety);
                }
                for (Edge e : vertex.getIncoming()) {
                    if (!(e instanceof StreetEdge)) continue;
                    pse = (StreetEdge)e;
                    if (seenEdges.contains(e)) continue;
                    seenEdges.add(e);
                    pse.setBicycleSafetyFactor(pse.getBicycleSafetyFactor() / this.bestBikeSafety);
                    pse.setWalkSafetyFactor(pse.getWalkSafetyFactor() / this.bestWalkSafety);
                }
            }
        }

        private Coordinate getCoordinate(OSMNode osmNode) {
            return new Coordinate(osmNode.lon, osmNode.lat);
        }

        private String getNodeLabel(OSMNode node) {
            return String.format(nodeLabelFormat, node.getId());
        }

        private String getLevelNodeLabel(OSMNode node, OSMLevel level) {
            return String.format(levelnodeLabelFormat, node.getId(), level.shortName);
        }

        private double getGeometryLengthMeters(Geometry geometry) {
            Coordinate[] coordinates = geometry.getCoordinates();
            double d = 0.0;
            for (int i = 1; i < coordinates.length; ++i) {
                d += SphericalDistanceLibrary.distance(coordinates[i - 1], coordinates[i]);
            }
            return d;
        }

        private P2<StreetEdge> getEdgesForStreet(IntersectionVertex startEndpoint, IntersectionVertex endEndpoint, OSMWay way, int index, long startNode, long endNode, StreetTraversalPermission permissions, LineString geometry) {
            if (permissions.allowsNothing()) {
                return new P2<Object>(null, null);
            }
            LineString backGeometry = geometry.reverse();
            StreetEdge street = null;
            StreetEdge backStreet = null;
            double length = this.getGeometryLengthMeters((Geometry)geometry);
            P2<StreetTraversalPermission> permissionPair = OSMFilter.getPermissions(permissions, way);
            StreetTraversalPermission permissionsFront = (StreetTraversalPermission)((Object)permissionPair.first);
            StreetTraversalPermission permissionsBack = (StreetTraversalPermission)((Object)permissionPair.second);
            if (permissionsFront.allowsAnything()) {
                street = this.getEdgeForStreet(startEndpoint, endEndpoint, way, index, length, permissionsFront, geometry, false);
            }
            if (permissionsBack.allowsAnything()) {
                backStreet = this.getEdgeForStreet(endEndpoint, startEndpoint, way, index, length, permissionsBack, backGeometry, true);
            }
            if (street != null && backStreet != null) {
                backStreet.shareData(street);
            }
            if (way.isRoundabout()) {
                if (street != null) {
                    street.setRoundabout(true);
                }
                if (backStreet != null) {
                    backStreet.setRoundabout(true);
                }
            }
            return new P2<StreetEdge>(street, backStreet);
        }

        private StreetEdge getEdgeForStreet(IntersectionVertex startEndpoint, IntersectionVertex endEndpoint, OSMWay way, int index, double length, StreetTraversalPermission permissions, LineString geometry, boolean back) {
            Object label = "way " + way.getId() + " from " + index;
            label = ((String)label).intern();
            I18NString name = this.getNameForWay(way, (String)label);
            float carSpeed = way.getOsmProvider().getWayPropertySet().getCarSpeedForWay(way, back);
            StreetEdge street = new StreetEdge((StreetVertex)startEndpoint, (StreetVertex)endEndpoint, geometry, name, length, permissions, back);
            street.setCarSpeed(carSpeed);
            String highway = way.getTag("highway");
            int cls = "crossing".equals(highway) && way.isTag("bicycle", "designated") == false ? 4 : ("footway".equals(highway) && way.isTag("footway", "crossing") != false && way.isTag("bicycle", "designated") == false ? 4 : ("residential".equals(highway) || "tertiary".equals(highway) || "secondary".equals(highway) || "secondary_link".equals(highway) || "primary".equals(highway) || "primary_link".equals(highway) || "trunk".equals(highway) || "trunk_link".equals(highway) ? 3 : 5));
            street.setStreetClass(cls |= OSMFilter.getStreetClasses(way));
            if (!way.hasTag("name") && !way.hasTag("ref")) {
                street.setHasBogusName(true);
            }
            boolean steps = way.isSteps();
            street.setStairs(steps);
            if (!OpenStreetMapModule.this.ignoreWheelchairAccessibility && (way.isTagFalse("wheelchair") || steps && !way.isTagTrue("wheelchair"))) {
                street.setWheelchairAccessible(false);
            }
            street.setSlopeOverride(way.getOsmProvider().getWayPropertySet().getSlopeOverride(way));
            if ((double)carSpeed < 0.04) {
                OpenStreetMapModule.this.issueStore.add(new StreetCarSpeedZero(way.getId()));
            }
            if (OpenStreetMapModule.this.customNamer != null) {
                OpenStreetMapModule.this.customNamer.nameWithEdge(way, street);
            }
            return street;
        }

        private OsmVertex recordLevel(OSMNode node, OSMWithTags way) {
            HashMap<Object, Object> vertices;
            OSMLevel level = this.osmdb.getLevelForWay(way);
            long nodeId = node.getId();
            if (this.multiLevelNodes.containsKey(nodeId)) {
                vertices = this.multiLevelNodes.get(nodeId);
            } else {
                vertices = new HashMap();
                this.multiLevelNodes.put(nodeId, vertices);
            }
            if (!vertices.containsKey(level)) {
                Coordinate coordinate = this.getCoordinate(node);
                String label = this.getLevelNodeLabel(node, level);
                OsmVertex vertex = new OsmVertex(this.graph, label, coordinate.x, coordinate.y, node.getId(), new NonLocalizedString(label));
                vertices.put(level, vertex);
                return vertex;
            }
            return (OsmVertex)vertices.get(level);
        }
    }
}

