/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module.osm;

import org.opentripplanner.common.model.P2;
import org.opentripplanner.graph_builder.DataImportIssueStore;
import org.opentripplanner.graph_builder.issues.ConflictingBikeTags;
import org.opentripplanner.openstreetmap.model.OSMWay;
import org.opentripplanner.openstreetmap.model.OSMWithTags;
import org.opentripplanner.routing.edgetype.StreetTraversalPermission;

public class OSMFilter {
    public static boolean isOsmEntityRoutable(OSMWithTags osmEntity) {
        if (osmEntity.hasTag("highway")) {
            return true;
        }
        if (osmEntity.isPlatform()) {
            return !"tourism".equals(osmEntity.getTag("usage"));
        }
        return false;
    }

    public static StreetTraversalPermission getPermissionsForEntity(OSMWithTags entity, StreetTraversalPermission def) {
        StreetTraversalPermission permission = null;
        permission = entity.isGeneralAccessDenied() ? StreetTraversalPermission.NONE : def;
        if (entity.isVehicleExplicitlyDenied()) {
            permission = permission.remove(StreetTraversalPermission.BICYCLE_AND_CAR);
        } else if (entity.isVehicleExplicitlyAllowed()) {
            permission = permission.add(StreetTraversalPermission.BICYCLE_AND_CAR);
        }
        if (entity.isMotorcarExplicitlyDenied() || entity.isMotorVehicleExplicitlyDenied()) {
            permission = permission.remove(StreetTraversalPermission.CAR);
        } else if (entity.isMotorcarExplicitlyAllowed() || entity.isMotorVehicleExplicitlyAllowed()) {
            permission = permission.add(StreetTraversalPermission.CAR);
        }
        if (entity.isBicycleExplicitlyDenied()) {
            permission = permission.remove(StreetTraversalPermission.BICYCLE);
        } else if (entity.isBicycleExplicitlyAllowed()) {
            permission = permission.add(StreetTraversalPermission.BICYCLE);
        }
        if (entity.isPedestrianExplicitlyDenied()) {
            permission = permission.remove(StreetTraversalPermission.PEDESTRIAN);
        } else if (entity.isPedestrianExplicitlyAllowed()) {
            permission = permission.add(StreetTraversalPermission.PEDESTRIAN);
        }
        if (entity.isUnderConstruction()) {
            permission = StreetTraversalPermission.NONE;
        }
        if (permission == null) {
            return def;
        }
        return permission;
    }

    public static StreetTraversalPermission getPermissionsForWay(OSMWay way, StreetTraversalPermission def, boolean banDiscouragedWalking, boolean banDiscouragedBiking, DataImportIssueStore issueStore) {
        StreetTraversalPermission permissions = OSMFilter.getPermissionsForEntity(way, def);
        if (way.isPedestrianExplicitlyAllowed()) {
            permissions = permissions.add(StreetTraversalPermission.PEDESTRIAN);
        } else if (way.isPedestrianExplicitlyDenied()) {
            permissions = permissions.remove(StreetTraversalPermission.PEDESTRIAN);
        }
        if (banDiscouragedWalking && way.hasTag("foot") && way.getTag("foot").equals("discouraged")) {
            permissions = permissions.remove(StreetTraversalPermission.PEDESTRIAN);
        }
        boolean forceBikes = false;
        if (way.isBicycleExplicitlyAllowed()) {
            permissions = permissions.add(StreetTraversalPermission.BICYCLE);
            forceBikes = true;
        }
        if (way.isBicycleDismountForced() || banDiscouragedBiking && way.hasTag("bicycle") && way.getTag("bicycle").equals("discouraged")) {
            permissions = permissions.remove(StreetTraversalPermission.BICYCLE);
            if (forceBikes) {
                issueStore.add(new ConflictingBikeTags(way.getId()));
            }
        }
        return permissions;
    }

    public static StreetTraversalPermission getPermissionsForWay(OSMWay way, StreetTraversalPermission def) {
        return OSMFilter.getPermissionsForWay(way, def, false, false, DataImportIssueStore.noopIssueStore());
    }

    public static P2<StreetTraversalPermission> getPermissions(StreetTraversalPermission permissions, OSMWay way) {
        String oneWayBicycle;
        StreetTraversalPermission permissionsFront = permissions;
        StreetTraversalPermission permissionsBack = permissions;
        if (way.isOneWayForwardDriving() || way.isRoundabout()) {
            permissionsBack = permissionsBack.remove(StreetTraversalPermission.BICYCLE_AND_CAR);
        }
        if (way.isOneWayReverseDriving()) {
            permissionsFront = permissionsFront.remove(StreetTraversalPermission.BICYCLE_AND_CAR);
        }
        if (way.isOneWayForwardBicycle()) {
            permissionsBack = permissionsBack.remove(StreetTraversalPermission.BICYCLE);
        }
        if (way.isOneWayReverseBicycle()) {
            permissionsFront = permissionsFront.remove(StreetTraversalPermission.BICYCLE);
        }
        if ((OSMWithTags.isFalse(oneWayBicycle = way.getTag("oneway:bicycle")) || way.isTagTrue("bicycle:backwards")) && permissions.allows(StreetTraversalPermission.BICYCLE)) {
            permissionsFront = permissionsFront.add(StreetTraversalPermission.BICYCLE);
            permissionsBack = permissionsBack.add(StreetTraversalPermission.BICYCLE);
        }
        if (way.isForwardDirectionSidepath()) {
            permissionsFront = permissionsFront.remove(StreetTraversalPermission.BICYCLE);
        }
        if (way.isReverseDirectionSidepath()) {
            permissionsBack = permissionsBack.remove(StreetTraversalPermission.BICYCLE);
        }
        if (way.isOpposableCycleway()) {
            permissionsBack = permissionsBack.add(StreetTraversalPermission.BICYCLE);
        }
        return new P2<StreetTraversalPermission>(permissionsFront, permissionsBack);
    }

    public static int getStreetClasses(OSMWithTags way) {
        int link = 0;
        String highway = way.getTag("highway");
        if (highway != null && highway.endsWith("_link")) {
            link = 32;
        }
        return OSMFilter.getPlatformClass(way) | link;
    }

    public static int getPlatformClass(OSMWithTags way) {
        String highway = way.getTag("highway");
        if ("platform".equals(way.getTag("railway"))) {
            return 16;
        }
        if ("platform".equals(highway) || "platform".equals(way.getTag("public_transport"))) {
            if (way.isTagTrue("train") || way.isTagTrue("subway") || way.isTagTrue("tram") || way.isTagTrue("monorail")) {
                return 16;
            }
            return 8;
        }
        return 0;
    }

    static boolean isWayRoutable(OSMWithTags way) {
        if (!OSMFilter.isOsmEntityRoutable(way)) {
            return false;
        }
        String highway = way.getTag("highway");
        if (highway != null && (highway.equals("proposed") || highway.equals("planned") || highway.equals("construction") || highway.equals("razed") || highway.equals("raceway") || highway.equals("abandoned") || highway.equals("historic") || highway.equals("no") || highway.equals("emergency_bay") || highway.equals("rest_area") || highway.equals("services") || highway.equals("bus_guideway") || highway.equals("escape"))) {
            return false;
        }
        if (way.isGeneralAccessDenied()) {
            return way.isMotorcarExplicitlyAllowed() || way.isBicycleExplicitlyAllowed() || way.isPedestrianExplicitlyAllowed() || way.isMotorVehicleExplicitlyAllowed() || way.isVehicleExplicitlyAllowed();
        }
        return true;
    }
}

