/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module.osm;

import java.util.Map;
import java.util.regex.Pattern;
import org.opentripplanner.common.model.T2;
import org.opentripplanner.graph_builder.module.osm.LocalizedStringMapper;
import org.opentripplanner.graph_builder.module.osm.TemplateLibrary;
import org.opentripplanner.model.StreetNote;
import org.opentripplanner.openstreetmap.model.OSMWithTags;
import org.opentripplanner.routing.services.notes.NoteMatcher;
import org.opentripplanner.transit.model.basic.I18NString;
import org.opentripplanner.transit.model.basic.TranslatedString;

public class NoteProperties {
    private static final Pattern patternMatcher = Pattern.compile("\\{(.*?)}");
    public String notePattern;
    public NoteMatcher noteMatcher;

    public NoteProperties(String notePattern, NoteMatcher noteMatcher) {
        this.notePattern = notePattern;
        this.noteMatcher = noteMatcher;
    }

    public T2<StreetNote, NoteMatcher> generateNote(OSMWithTags way) {
        I18NString text;
        if (patternMatcher.matcher(this.notePattern).matches()) {
            Map<String, String> noteText = TemplateLibrary.generateI18N(this.notePattern, way);
            text = TranslatedString.getI18NString(noteText, true, false);
        } else {
            text = LocalizedStringMapper.getInstance().map(this.notePattern, way);
        }
        StreetNote note = new StreetNote(text);
        return new T2<StreetNote, NoteMatcher>(note, this.noteMatcher);
    }
}

