/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module.map;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.linearref.LinearLocation;
import org.locationtech.jts.linearref.LocationIndexedLine;
import org.locationtech.jts.util.AssertionFailedException;
import org.opentripplanner.graph_builder.module.map.EndMatchState;
import org.opentripplanner.graph_builder.module.map.LinearIterator;
import org.opentripplanner.graph_builder.module.map.MatchState;
import org.opentripplanner.routing.graph.Edge;
import org.opentripplanner.routing.graph.Vertex;

public class MidblockMatchState
extends MatchState {
    private static final double MAX_ERROR = 1000.0;
    private final LinearLocation edgeIndex;
    private final Geometry edgeGeometry;
    private final LocationIndexedLine indexedEdge;
    public LinearLocation routeIndex;
    Geometry routeGeometry;

    public MidblockMatchState(MatchState parent, Geometry routeGeometry, Edge edge, LinearLocation routeIndex, LinearLocation edgeIndex, double error, double distanceAlongRoute) {
        super(parent, edge, distanceAlongRoute);
        this.routeGeometry = routeGeometry;
        this.routeIndex = routeIndex;
        this.edgeIndex = edgeIndex;
        this.edgeGeometry = edge.getGeometry();
        this.indexedEdge = new LocationIndexedLine(this.edgeGeometry);
        this.currentError = error;
    }

    @Override
    public List<MatchState> getNextStates() {
        ArrayList<MatchState> nextStates = new ArrayList<MatchState>();
        if (this.routeIndex.getSegmentIndex() == this.routeGeometry.getNumPoints() - 1) {
            Coordinate pt = this.routeIndex.getCoordinate(this.routeGeometry);
            double error = MidblockMatchState.distance(pt, this.edgeIndex.getCoordinate(this.edgeGeometry));
            nextStates.add(new EndMatchState((MatchState)this, error, 0.0));
            return nextStates;
        }
        LinearIterator it = new LinearIterator(this.routeGeometry, this.routeIndex);
        if (it.hasNext()) {
            it.next();
            LinearLocation routeSuccessor = it.getLocation();
            Coordinate newRouteCoord = routeSuccessor.getCoordinate(this.routeGeometry);
            LinearLocation newEdgeIndex = this.indexedEdge.project(newRouteCoord);
            Coordinate edgeCoord = newEdgeIndex.getCoordinate(this.edgeGeometry);
            if (newEdgeIndex.compareTo((Object)this.edgeIndex) <= 0) {
                try {
                    LinearLocation projected2 = this.indexedEdge.indexOfAfter(edgeCoord, this.edgeIndex);
                    if (Double.isNaN(projected2.getSegmentFraction())) {
                        return Collections.emptyList();
                    }
                    newEdgeIndex = projected2;
                    if (newEdgeIndex.equals(this.edgeIndex)) {
                        return Collections.emptyList();
                    }
                    edgeCoord = newEdgeIndex.getCoordinate(this.edgeGeometry);
                }
                catch (AssertionFailedException e) {
                    return Collections.emptyList();
                }
            }
            if (newEdgeIndex.getSegmentIndex() == this.edgeGeometry.getNumPoints() - 1) {
                Vertex toVertex = this.edge.getToVertex();
                Coordinate endCoord = toVertex.getCoordinate();
                LocationIndexedLine indexedRoute = new LocationIndexedLine(this.routeGeometry);
                LinearLocation routeProjectedEndIndex = indexedRoute.project(endCoord);
                Coordinate routeProjectedEndCoord = routeProjectedEndIndex.getCoordinate(this.routeGeometry);
                if (routeProjectedEndIndex.compareTo((Object)this.routeIndex) <= 0) {
                    try {
                        routeProjectedEndIndex = indexedRoute.indexOfAfter(routeProjectedEndCoord, this.routeIndex);
                        if (Double.isNaN(routeProjectedEndIndex.getSegmentFraction())) {
                            routeProjectedEndIndex = this.routeIndex;
                        }
                    }
                    catch (AssertionFailedException e) {
                        routeProjectedEndIndex = this.routeIndex;
                    }
                    routeProjectedEndCoord = routeProjectedEndIndex.getCoordinate(this.routeGeometry);
                }
                double positionError = MidblockMatchState.distance(routeProjectedEndCoord, endCoord);
                double travelAlongRoute = MidblockMatchState.distanceAlongGeometry(this.routeGeometry, this.routeIndex, routeProjectedEndIndex);
                double travelAlongEdge = MidblockMatchState.distanceAlongGeometry(this.edgeGeometry, this.edgeIndex, newEdgeIndex);
                double travelError = Math.abs(travelAlongEdge - travelAlongRoute);
                double error = positionError + travelError;
                if (error > 1000.0) {
                    return nextStates;
                }
                for (Edge e : this.getOutgoingMatchableEdges(toVertex)) {
                    double cost = error + 0.1;
                    if (!this.carsCanTraverse(e)) {
                        cost += 20.0;
                    }
                    MidblockMatchState nextState = new MidblockMatchState(this, this.routeGeometry, e, routeProjectedEndIndex, new LinearLocation(), cost, travelAlongRoute);
                    nextStates.add(nextState);
                }
            } else {
                double travelAlongEdge = MidblockMatchState.distanceAlongGeometry(this.edgeGeometry, this.edgeIndex, newEdgeIndex);
                double travelAlongRoute = MidblockMatchState.distanceAlongGeometry(this.routeGeometry, this.routeIndex, routeSuccessor);
                double travelError = Math.abs(travelAlongRoute - travelAlongEdge);
                double positionError = MidblockMatchState.distance(edgeCoord, newRouteCoord);
                double error = travelError + positionError;
                MidblockMatchState nextState = new MidblockMatchState(this, this.routeGeometry, this.edge, routeSuccessor, newEdgeIndex, error, travelAlongRoute);
                nextStates.add(nextState);
                Vertex toVertex = this.edge.getToVertex();
                double travelAlongOldEdge = MidblockMatchState.distanceAlongGeometry(this.edgeGeometry, this.edgeIndex, null);
                for (Edge e : this.getOutgoingMatchableEdges(toVertex)) {
                    LineString newEdgeGeometry = e.getGeometry();
                    LocationIndexedLine newIndexedEdge = new LocationIndexedLine((Geometry)newEdgeGeometry);
                    newEdgeIndex = newIndexedEdge.project(newRouteCoord);
                    Coordinate newEdgeCoord = newEdgeIndex.getCoordinate((Geometry)newEdgeGeometry);
                    positionError = MidblockMatchState.distance(newEdgeCoord, newRouteCoord);
                    travelAlongEdge = travelAlongOldEdge + MidblockMatchState.distanceAlongGeometry((Geometry)newEdgeGeometry, new LinearLocation(), newEdgeIndex);
                    travelError = Math.abs(travelAlongRoute - travelAlongEdge);
                    error = travelError + positionError;
                    if (error > 1000.0) {
                        return nextStates;
                    }
                    double cost = error + 0.1;
                    if (!this.carsCanTraverse(e)) {
                        cost += 20.0;
                    }
                    nextState = new MidblockMatchState(this, this.routeGeometry, e, routeSuccessor, new LinearLocation(), cost, travelAlongRoute);
                    nextStates.add(nextState);
                }
            }
            return nextStates;
        }
        Coordinate routeCoord = this.routeIndex.getCoordinate(this.routeGeometry);
        LinearLocation projected = this.indexedEdge.project(routeCoord);
        double locationError = MidblockMatchState.distance(projected.getCoordinate(this.edgeGeometry), routeCoord);
        EndMatchState end = new EndMatchState((MatchState)this, locationError, 0.0);
        return Arrays.asList(end);
    }

    public int hashCode() {
        return (this.edge.hashCode() * 1337 + this.hashCode(this.edgeIndex)) * 1337 + this.hashCode(this.routeIndex);
    }

    public boolean equals(Object o) {
        if (!(o instanceof MidblockMatchState)) {
            return false;
        }
        MidblockMatchState other = (MidblockMatchState)o;
        return other.edge == this.edge && other.edgeIndex.compareTo((Object)this.edgeIndex) == 0 && other.routeIndex.compareTo((Object)this.routeIndex) == 0;
    }

    public String toString() {
        return "MidblockMatchState(" + this.edge + ", " + this.edgeIndex.getSegmentIndex() + ", " + this.edgeIndex.getSegmentFraction() + ") - " + this.currentError;
    }

    private int hashCode(LinearLocation location) {
        return location.getComponentIndex() * 1000000 + location.getSegmentIndex() * 37 + Double.valueOf(location.getSegmentFraction()).hashCode();
    }
}

