/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module.geometry;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.impl.PackedCoordinateSequence;
import org.locationtech.jts.linearref.LinearLocation;
import org.locationtech.jts.linearref.LocationIndexedLine;
import org.opentripplanner.common.geometry.SphericalDistanceLibrary;
import org.opentripplanner.ext.flex.trip.FlexTrip;
import org.opentripplanner.graph_builder.DataImportIssueStore;
import org.opentripplanner.graph_builder.issues.BogusShapeDistanceTraveled;
import org.opentripplanner.graph_builder.issues.BogusShapeGeometry;
import org.opentripplanner.graph_builder.issues.BogusShapeGeometryCaught;
import org.opentripplanner.graph_builder.issues.MissingShapeGeometry;
import org.opentripplanner.graph_builder.issues.ShapeGeometryTooFar;
import org.opentripplanner.graph_builder.module.geometry.IndexedLineSegment;
import org.opentripplanner.graph_builder.module.geometry.IndexedLineSegmentComparator;
import org.opentripplanner.graph_builder.module.geometry.ShapeSegmentKey;
import org.opentripplanner.model.ShapePoint;
import org.opentripplanner.model.StopTime;
import org.opentripplanner.model.impl.OtpTransitServiceBuilder;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.model.timetable.Trip;
import org.opentripplanner.util.geometry.GeometryUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeometryProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(GeometryProcessor.class);
    private static final GeometryFactory geometryFactory = GeometryUtils.getGeometryFactory();
    private final OtpTransitServiceBuilder transitService;
    private final Map<ShapeSegmentKey, LineString> geometriesByShapeSegmentKey = new ConcurrentHashMap<ShapeSegmentKey, LineString>();
    private final Map<FeedScopedId, LineString> geometriesByShapeId = new ConcurrentHashMap<FeedScopedId, LineString>();
    private final Map<FeedScopedId, double[]> distancesByShapeId = new ConcurrentHashMap<FeedScopedId, double[]>();
    private final double maxStopToShapeSnapDistance;
    private final DataImportIssueStore issueStore;

    public GeometryProcessor(OtpTransitServiceBuilder transitService, double maxStopToShapeSnapDistance, DataImportIssueStore issueStore) {
        this.transitService = transitService;
        this.maxStopToShapeSnapDistance = maxStopToShapeSnapDistance > 0.0 ? maxStopToShapeSnapDistance : 150.0;
        this.issueStore = issueStore;
    }

    public List<LineString> createHopGeometries(Trip trip) {
        if (trip.getShapeId() == null || trip.getShapeId().getId() == null || trip.getShapeId().getId().equals("")) {
            return null;
        }
        return Arrays.asList(this.createGeometry(trip.getShapeId(), this.transitService.getStopTimesSortedByTrip().get(trip)));
    }

    private static boolean equals(LinearLocation startIndex, LinearLocation endIndex) {
        return startIndex.getSegmentIndex() == endIndex.getSegmentIndex() && startIndex.getSegmentFraction() == endIndex.getSegmentFraction() && startIndex.getComponentIndex() == endIndex.getComponentIndex();
    }

    private LineString[] createGeometry(FeedScopedId shapeId, List<StopTime> stopTimes) {
        if (this.hasShapeDist(shapeId, stopTimes)) {
            return this.getHopGeometriesViaShapeDistTravelled(stopTimes, shapeId);
        }
        LineString shapeLineString = this.getLineStringForShapeId(shapeId);
        if (shapeLineString == null) {
            this.issueStore.add(new MissingShapeGeometry(stopTimes.get(0).getTrip().getId(), shapeId));
            return this.createStraightLineHopeGeometries(stopTimes, shapeId);
        }
        List<LinearLocation> locations = this.getLinearLocations(stopTimes, shapeLineString);
        if (locations == null) {
            this.issueStore.add(new ShapeGeometryTooFar(stopTimes.get(0).getTrip().getId(), shapeId));
            return this.createStraightLineHopeGeometries(stopTimes, shapeId);
        }
        return this.getGeometriesByShape(stopTimes, shapeId, shapeLineString, locations);
    }

    private boolean hasShapeDist(FeedScopedId shapeId, List<StopTime> stopTimes) {
        StopTime st0 = stopTimes.get(0);
        return st0.isShapeDistTraveledSet() && this.getDistanceForShapeId(shapeId) != null;
    }

    private LineString[] getGeometriesByShape(List<StopTime> stopTimes, FeedScopedId shapeId, LineString shape, List<LinearLocation> locations) {
        LineString[] geoms = new LineString[stopTimes.size() - 1];
        Iterator<LinearLocation> locationIt = locations.iterator();
        LinearLocation endLocation = locationIt.next();
        double distanceSoFar = 0.0;
        int last = 0;
        for (int i = 0; i < stopTimes.size() - 1; ++i) {
            LinearLocation startLocation = endLocation;
            endLocation = locationIt.next();
            for (int j = last; j < startLocation.getSegmentIndex(); ++j) {
                Coordinate from = shape.getCoordinateN(j);
                Coordinate to = shape.getCoordinateN(j + 1);
                double xd = from.x - to.x;
                double yd = from.y - to.y;
                distanceSoFar += Math.sqrt(xd * xd + yd * yd);
            }
            last = startLocation.getSegmentIndex();
            double startIndex = distanceSoFar + startLocation.getSegmentFraction() * startLocation.getSegmentLength((Geometry)shape);
            for (int j = last; j < endLocation.getSegmentIndex(); ++j) {
                Coordinate from = shape.getCoordinateN(j);
                Coordinate to = shape.getCoordinateN(j + 1);
                double xd = from.x - to.x;
                double yd = from.y - to.y;
                distanceSoFar += Math.sqrt(xd * xd + yd * yd);
            }
            last = startLocation.getSegmentIndex();
            double endIndex = distanceSoFar + endLocation.getSegmentFraction() * endLocation.getSegmentLength((Geometry)shape);
            ShapeSegmentKey key = new ShapeSegmentKey(shapeId, startIndex, endIndex);
            LineString geometry = this.geometriesByShapeSegmentKey.get(key);
            if (geometry == null) {
                LocationIndexedLine locationIndexed = new LocationIndexedLine((Geometry)shape);
                geometry = (LineString)locationIndexed.extractLine(startLocation, endLocation);
                PackedCoordinateSequence.Double sequence = new PackedCoordinateSequence.Double(geometry.getCoordinates(), 2);
                geometry = geometryFactory.createLineString((CoordinateSequence)sequence);
            }
            geoms[i] = geometry;
        }
        return geoms;
    }

    private List<LinearLocation> getLinearLocations(List<StopTime> stopTimes, LineString shape) {
        boolean isFlexTrip = FlexTrip.containsFlexStops(stopTimes);
        ArrayList<IndexedLineSegment> segments = new ArrayList<IndexedLineSegment>();
        for (int i = 0; i < shape.getNumPoints() - 1; ++i) {
            segments.add(new IndexedLineSegment(i, shape.getCoordinateN(i), shape.getCoordinateN(i + 1)));
        }
        ArrayList<List<IndexedLineSegment>> possibleSegmentsForStop = new ArrayList<List<IndexedLineSegment>>();
        int minSegmentIndex = 0;
        for (int i = 0; i < stopTimes.size(); ++i) {
            StopLocation stop = stopTimes.get(i).getStop();
            Coordinate coord = stop.getCoordinate().asJtsCoordinate();
            ArrayList<IndexedLineSegment> stopSegments = new ArrayList<IndexedLineSegment>();
            double bestDistance = Double.MAX_VALUE;
            IndexedLineSegment bestSegment = null;
            int maxSegmentIndex = -1;
            int index = -1;
            int minSegmentIndexForThisStop = -1;
            for (IndexedLineSegment segment : segments) {
                ++index;
                if (segment.index < minSegmentIndex) continue;
                double distance = segment.distance(coord);
                if (distance < this.maxStopToShapeSnapDistance || isFlexTrip) {
                    stopSegments.add(segment);
                    maxSegmentIndex = index;
                    if (minSegmentIndexForThisStop != -1) continue;
                    minSegmentIndexForThisStop = index;
                    continue;
                }
                if (!(distance < bestDistance)) continue;
                bestDistance = distance;
                bestSegment = segment;
                if (maxSegmentIndex == -1) continue;
                maxSegmentIndex = index;
            }
            if (stopSegments.size() == 0 && bestSegment != null) {
                stopSegments.add(bestSegment);
                minSegmentIndex = bestSegment.index;
            } else {
                minSegmentIndex = minSegmentIndexForThisStop;
                stopSegments.sort(new IndexedLineSegmentComparator(coord));
            }
            for (int j = i - 1; j >= 0; --j) {
                Iterator it = ((List)possibleSegmentsForStop.get(j)).iterator();
                while (it.hasNext()) {
                    IndexedLineSegment segment = (IndexedLineSegment)it.next();
                    if (segment.index <= maxSegmentIndex) continue;
                    it.remove();
                }
            }
            possibleSegmentsForStop.add(stopSegments);
        }
        return this.getStopLocations(possibleSegmentsForStop, stopTimes, 0, -1);
    }

    private LineString[] createStraightLineHopeGeometries(List<StopTime> stopTimes, FeedScopedId shapeId) {
        LineString[] geoms = new LineString[stopTimes.size() - 1];
        for (int i = 0; i < stopTimes.size() - 1; ++i) {
            LineString geometry;
            StopTime st0 = stopTimes.get(i);
            StopTime st1 = stopTimes.get(i + 1);
            geoms[i] = geometry = this.createSimpleGeometry(st0.getStop(), st1.getStop());
        }
        return geoms;
    }

    private LineString[] getHopGeometriesViaShapeDistTravelled(List<StopTime> stopTimes, FeedScopedId shapeId) {
        LineString[] geoms = new LineString[stopTimes.size() - 1];
        for (int i = 0; i < stopTimes.size() - 1; ++i) {
            StopTime st0 = stopTimes.get(i);
            StopTime st1 = stopTimes.get(i + 1);
            geoms[i] = this.getHopGeometryViaShapeDistTraveled(shapeId, st0, st1);
        }
        return geoms;
    }

    private List<LinearLocation> getStopLocations(List<List<IndexedLineSegment>> possibleSegmentsForStop, List<StopTime> stopTimes, int index, int prevSegmentIndex) {
        if (index == stopTimes.size()) {
            return new LinkedList<LinearLocation>();
        }
        StopTime st = stopTimes.get(index);
        StopLocation stop = st.getStop();
        Coordinate stopCoord = stop.getCoordinate().asJtsCoordinate();
        for (IndexedLineSegment segment : possibleSegmentsForStop.get(index)) {
            List<LinearLocation> locations;
            if (segment.index < prevSegmentIndex || (locations = this.getStopLocations(possibleSegmentsForStop, stopTimes, index + 1, segment.index)) == null) continue;
            LinearLocation location = new LinearLocation(0, segment.index, segment.fraction(stopCoord));
            locations.add(0, location);
            return locations;
        }
        return null;
    }

    private LineString getHopGeometryViaShapeDistTraveled(FeedScopedId shapeId, StopTime st0, StopTime st1) {
        LinearLocation endIndex;
        double endDistance;
        double startDistance = st0.getShapeDistTraveled();
        ShapeSegmentKey key = new ShapeSegmentKey(shapeId, startDistance, endDistance = st1.getShapeDistTraveled());
        LineString geometry = this.geometriesByShapeSegmentKey.get(key);
        if (geometry != null) {
            return geometry;
        }
        double[] distances = this.getDistanceForShapeId(shapeId);
        if (distances == null) {
            this.issueStore.add(new BogusShapeGeometry(shapeId));
            return null;
        }
        LinearLocation startIndex = this.getSegmentFraction(distances, startDistance);
        if (GeometryProcessor.equals(startIndex, endIndex = this.getSegmentFraction(distances, endDistance))) {
            this.issueStore.add(new BogusShapeDistanceTraveled(st1));
            return this.createSimpleGeometry(st0.getStop(), st1.getStop());
        }
        LineString line = this.getLineStringForShapeId(shapeId);
        LocationIndexedLine lol = new LocationIndexedLine((Geometry)line);
        geometry = this.getSegmentGeometry(shapeId, lol, startIndex, endIndex, startDistance, endDistance, st0, st1);
        return geometry;
    }

    private LineString createSimpleGeometry(StopLocation s0, StopLocation s1) {
        Coordinate[] coordinates = new Coordinate[]{s0.getCoordinate().asJtsCoordinate(), s1.getCoordinate().asJtsCoordinate()};
        PackedCoordinateSequence.Double sequence = new PackedCoordinateSequence.Double(coordinates, 2);
        return geometryFactory.createLineString((CoordinateSequence)sequence);
    }

    private boolean isValid(Geometry geometry, StopLocation s0, StopLocation s1) {
        Coordinate[] coordinates = geometry.getCoordinates();
        if (coordinates.length < 2) {
            return false;
        }
        if (geometry.getLength() == 0.0) {
            return false;
        }
        for (Coordinate coordinate : coordinates) {
            if (!Double.isNaN(coordinate.x) && !Double.isNaN(coordinate.y)) continue;
            return false;
        }
        Coordinate geometryStartCoord = coordinates[0];
        Coordinate geometryEndCoord = coordinates[coordinates.length - 1];
        Coordinate startCoord = s0.getCoordinate().asJtsCoordinate();
        Coordinate endCoord = s1.getCoordinate().asJtsCoordinate();
        if (SphericalDistanceLibrary.fastDistance(startCoord, geometryStartCoord) > this.maxStopToShapeSnapDistance) {
            return false;
        }
        return !(SphericalDistanceLibrary.fastDistance(endCoord, geometryEndCoord) > this.maxStopToShapeSnapDistance);
    }

    private LineString getSegmentGeometry(FeedScopedId shapeId, LocationIndexedLine locationIndexedLine, LinearLocation startIndex, LinearLocation endIndex, double startDistance, double endDistance, StopTime st0, StopTime st1) {
        ShapeSegmentKey key = new ShapeSegmentKey(shapeId, startDistance, endDistance);
        LineString geometry = this.geometriesByShapeSegmentKey.get(key);
        if (geometry == null) {
            geometry = (LineString)locationIndexedLine.extractLine(startIndex, endIndex);
            PackedCoordinateSequence.Double sequence = new PackedCoordinateSequence.Double(geometry.getCoordinates(), 2);
            if (!this.isValid((Geometry)(geometry = geometryFactory.createLineString((CoordinateSequence)sequence)), st0.getStop(), st1.getStop())) {
                this.issueStore.add(new BogusShapeGeometryCaught(shapeId, st0, st1));
                geometry = this.createSimpleGeometry(st0.getStop(), st1.getStop());
            }
            this.geometriesByShapeSegmentKey.put(key, geometry);
        }
        return geometry;
    }

    private List<ShapePoint> getUniqueShapePointsForShapeId(FeedScopedId shapeId) {
        ArrayList<ShapePoint> points = new ArrayList<ShapePoint>(this.transitService.getShapePoints().get((Object)shapeId));
        Collections.sort(points);
        ArrayList<ShapePoint> filtered = new ArrayList<ShapePoint>(points.size());
        ShapePoint last = null;
        for (ShapePoint sp : points) {
            if (last == null || last.getSequence() != sp.getSequence()) {
                if (last != null && last.getLat() == sp.getLat() && last.getLon() == sp.getLon()) {
                    LOG.trace("pair of identical shape points (skipping): {} {}", (Object)last, (Object)sp);
                } else {
                    filtered.add(sp);
                }
            }
            last = sp;
        }
        if (filtered.size() != points.size()) {
            filtered.trimToSize();
            return filtered;
        }
        return points;
    }

    private LineString getLineStringForShapeId(FeedScopedId shapeId) {
        LineString geometry = this.geometriesByShapeId.get(shapeId);
        if (geometry != null) {
            return geometry;
        }
        List<ShapePoint> points = this.getUniqueShapePointsForShapeId(shapeId);
        if (points.size() < 2) {
            return null;
        }
        Coordinate[] coordinates = new Coordinate[points.size()];
        double[] distances = new double[points.size()];
        boolean hasAllDistances = true;
        int i = 0;
        for (ShapePoint point : points) {
            coordinates[i] = new Coordinate(point.getLon(), point.getLat());
            distances[i] = point.getDistTraveled();
            if (!point.isDistTraveledSet()) {
                hasAllDistances = false;
            }
            ++i;
        }
        PackedCoordinateSequence.Double sequence = new PackedCoordinateSequence.Double(coordinates, 2);
        geometry = geometryFactory.createLineString((CoordinateSequence)sequence);
        this.geometriesByShapeId.put(shapeId, geometry);
        if (hasAllDistances) {
            this.distancesByShapeId.put(shapeId, distances);
        }
        return geometry;
    }

    private double[] getDistanceForShapeId(FeedScopedId shapeId) {
        this.getLineStringForShapeId(shapeId);
        return this.distancesByShapeId.get(shapeId);
    }

    private LinearLocation getSegmentFraction(double[] distances, double distance) {
        int index = Arrays.binarySearch(distances, distance);
        if (index < 0) {
            index = -(index + 1);
        }
        if (index == 0) {
            return new LinearLocation(0, 0.0);
        }
        if (index == distances.length) {
            return new LinearLocation(distances.length, 0.0);
        }
        double prevDistance = distances[index - 1];
        if (prevDistance == distances[index]) {
            return new LinearLocation(index - 1, 1.0);
        }
        double indexPart = (distance - distances[index - 1]) / (distances[index] - prevDistance);
        return new LinearLocation(index - 1, indexPart);
    }
}

