/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module;

import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.opentripplanner.common.geometry.SphericalDistanceLibrary;
import org.opentripplanner.ext.flex.trip.FlexTrip;
import org.opentripplanner.graph_builder.DataImportIssueStore;
import org.opentripplanner.graph_builder.issues.HopSpeedFast;
import org.opentripplanner.graph_builder.issues.HopSpeedSlow;
import org.opentripplanner.graph_builder.issues.HopZeroDistance;
import org.opentripplanner.graph_builder.issues.HopZeroTime;
import org.opentripplanner.graph_builder.issues.NegativeDwellTime;
import org.opentripplanner.graph_builder.issues.NegativeHopTime;
import org.opentripplanner.graph_builder.issues.RepeatedStops;
import org.opentripplanner.model.StopTime;
import org.opentripplanner.model.TripStopTimes;
import org.opentripplanner.transit.model.basic.TransitMode;
import org.opentripplanner.transit.model.site.RegularStop;
import org.opentripplanner.transit.model.timetable.Trip;
import org.opentripplanner.util.OTPFeature;
import org.opentripplanner.util.logging.ProgressTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidateAndInterpolateStopTimesForEachTrip {
    private static final Logger LOG = LoggerFactory.getLogger(ValidateAndInterpolateStopTimesForEachTrip.class);
    private static final double MIN_ZERO_TIME_HOP_DISTANCE_METERS = 1000.0;
    private final TripStopTimes stopTimesByTrip;
    private final boolean interpolate;
    private final DataImportIssueStore issueStore;

    public ValidateAndInterpolateStopTimesForEachTrip(TripStopTimes stopTimesByTrip, boolean interpolate, DataImportIssueStore issueStore) {
        this.stopTimesByTrip = stopTimesByTrip;
        this.interpolate = interpolate;
        this.issueStore = issueStore;
    }

    public void run() {
        int tripSize = this.stopTimesByTrip.size();
        ProgressTracker progress = ProgressTracker.track("Validate StopTimes", 100000, tripSize);
        LOG.info(progress.startMessage());
        for (Trip trip : this.stopTimesByTrip.keys()) {
            TIntList removedStopSequences;
            ArrayList<StopTime> stopTimes = new ArrayList<StopTime>(this.stopTimesByTrip.get(trip));
            if (OTPFeature.FlexRouting.isOff()) {
                stopTimes.removeIf(st -> !(st.getStop() instanceof RegularStop));
            }
            if (!(removedStopSequences = this.removeRepeatedStops(stopTimes)).isEmpty()) {
                this.issueStore.add(new RepeatedStops(trip, removedStopSequences));
            }
            if (!this.filterStopTimes(stopTimes)) {
                this.stopTimesByTrip.replace(trip, List.of());
            } else if (this.interpolate) {
                this.interpolateStopTimes(stopTimes);
                this.stopTimesByTrip.replace(trip, stopTimes);
            } else {
                stopTimes.removeIf(st -> !st.isArrivalTimeSet() || !st.isDepartureTimeSet());
                this.stopTimesByTrip.replace(trip, stopTimes);
            }
            progress.step(m -> LOG.info(m));
        }
        LOG.info(progress.completeMessage());
    }

    private TIntList removeRepeatedStops(List<StopTime> stopTimes) {
        StopTime prev = null;
        Iterator<StopTime> it = stopTimes.iterator();
        TIntArrayList stopSequencesRemoved = new TIntArrayList();
        while (it.hasNext()) {
            StopTime st = it.next();
            if (prev != null && prev.getStop().equals(st.getStop())) {
                if (prev.getArrivalTime() == -999) {
                    prev.setArrivalTime(st.getArrivalTime());
                }
                if (st.getDepartureTime() != -999) {
                    prev.setDepartureTime(st.getDepartureTime());
                }
                it.remove();
                stopSequencesRemoved.add(st.getStopSequence());
            }
            prev = st;
        }
        return stopSequencesRemoved;
    }

    private boolean filterStopTimes(List<StopTime> stopTimes) {
        if (stopTimes.size() < 2 && !FlexTrip.containsFlexStops(stopTimes)) {
            return false;
        }
        StopTime st0 = stopTimes.get(0);
        boolean hasTimepoints = stopTimes.stream().anyMatch(stopTime -> stopTime.getTimepoint() == 1);
        if (!hasTimepoints) {
            st0.setTimepoint(1);
        }
        for (int i = 1; i < stopTimes.size(); ++i) {
            StopTime st1 = stopTimes.get(i);
            if (!hasTimepoints && (st1.isDepartureTimeSet() || st1.isArrivalTimeSet())) {
                st1.setTimepoint(1);
            }
            if (!st1.isArrivalTimeSet() && st1.isDepartureTimeSet()) {
                st1.setArrivalTime(st1.getDepartureTime());
            } else if (!st1.isDepartureTimeSet() && st1.isArrivalTimeSet()) {
                st1.setDepartureTime(st1.getArrivalTime());
            }
            if (!st1.isArrivalTimeSet() || !st1.isDepartureTimeSet()) continue;
            int dwellTime = st0.getDepartureTime() - st0.getArrivalTime();
            if (dwellTime < 0) {
                this.issueStore.add(new NegativeDwellTime(st0));
                return false;
            }
            int runningTime = st1.getArrivalTime() - st0.getDepartureTime();
            if (runningTime < 0) {
                this.issueStore.add(new NegativeHopTime(st0, st1));
                return false;
            }
            double hopDistance = SphericalDistanceLibrary.fastDistance(st0.getStop().getCoordinate().asJtsCoordinate(), st1.getStop().getCoordinate().asJtsCoordinate());
            double hopSpeed = hopDistance / (double)runningTime;
            if (hopDistance == 0.0) {
                this.issueStore.add(new HopZeroDistance(runningTime, st1.getTrip(), st1.getStopSequence()));
            }
            if (runningTime == 0) {
                if (hopDistance > 1000.0) {
                    this.issueStore.add(new HopZeroTime((float)hopDistance, st1.getTrip(), st1.getStopSequence()));
                }
            } else if (hopSpeed > this.getMaxSpeedForMode(st0.getTrip().getMode())) {
                this.issueStore.add(new HopSpeedFast((float)hopSpeed, (float)hopDistance, st0.getTrip(), st0.getStopSequence()));
            } else if (hopSpeed < 0.3) {
                this.issueStore.add(new HopSpeedSlow((float)hopSpeed, (float)hopDistance, st0.getTrip(), st0.getStopSequence()));
            }
            st0 = st1;
        }
        return true;
    }

    private double getMaxSpeedForMode(TransitMode mode) {
        return switch (mode) {
            case TransitMode.AIRPLANE -> 280.0;
            case TransitMode.RAIL -> 70.0;
            case TransitMode.GONDOLA, TransitMode.FUNICULAR -> 10.0;
            default -> 30.0;
        };
    }

    private void interpolateStopTimes(List<StopTime> stopTimes) {
        int lastStop = stopTimes.size() - 1;
        int departureTime = -1;
        for (int i = 0; i < lastStop; ++i) {
            int j;
            StopTime st0 = stopTimes.get(i);
            int prevDepartureTime = departureTime;
            departureTime = st0.getDepartureTime();
            if (st0.isDepartureTimeSet() && st0.isArrivalTimeSet() || FlexTrip.isFlexStop(st0.getStop())) continue;
            StopTime st = null;
            for (j = i + 1; !(j >= lastStop + 1 || (st = stopTimes.get(j)).isDepartureTimeSet() && st.getDepartureTime() != departureTime || st.isArrivalTimeSet() && st.getArrivalTime() != departureTime); ++j) {
            }
            if (j == lastStop + 1) {
                throw new RuntimeException("Could not interpolate arrival/departure time on stop " + i + " (missing final stop time) on trip " + st0.getTrip());
            }
            int numInterpStops = j - i;
            int arrivalTime = st.isArrivalTimeSet() ? st.getArrivalTime() : st.getDepartureTime();
            int interpStep = (arrivalTime - prevDepartureTime) / (numInterpStops + 1);
            if (interpStep < 0) {
                throw new RuntimeException("trip goes backwards for some reason");
            }
            for (j = i; j < i + numInterpStops; ++j) {
                departureTime = prevDepartureTime + interpStep * (j - i + 1);
                st = stopTimes.get(j);
                if (st.isArrivalTimeSet()) {
                    departureTime = st.getArrivalTime();
                } else {
                    st.setArrivalTime(departureTime);
                }
                if (st.isDepartureTimeSet()) continue;
                st.setDepartureTime(departureTime);
            }
            i = j - 1;
        }
    }
}

