/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module;

import com.google.common.collect.ArrayListMultimap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import javax.inject.Inject;
import org.opentripplanner.graph_builder.model.GraphBuilderModule;
import org.opentripplanner.transit.model.network.Route;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.model.timetable.TripTimes;
import org.opentripplanner.transit.service.TransitModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TripPatternNamer
implements GraphBuilderModule {
    private static final Logger LOG = LoggerFactory.getLogger(TripPatternNamer.class);
    private final TransitModel transitModel;

    @Inject
    public TripPatternNamer(TransitModel transitModel) {
        this.transitModel = transitModel;
    }

    @Override
    public void buildGraph() {
        TripPatternNamer.generateUniqueNames(this.transitModel.getAllTripPatterns());
    }

    @Override
    public void checkInputs() {
    }

    public static void generateUniqueNames(Collection<TripPattern> tableTripPatterns) {
        Collection routeTripPatterns;
        LOG.info("Generating unique names for stop patterns on each route.");
        ArrayListMultimap patternsByRoute = ArrayListMultimap.create();
        for (TripPattern ttp : tableTripPatterns) {
            patternsByRoute.put((Object)ttp.getRoute(), (Object)ttp);
        }
        for (Route route : patternsByRoute.keySet()) {
            routeTripPatterns = patternsByRoute.get((Object)route);
            if (routeTripPatterns.stream().allMatch(tripPattern -> tripPattern.getName() != null)) continue;
            String routeName = route.getName();
            if (routeTripPatterns.size() == 1) {
                ((TripPattern)routeTripPatterns.iterator().next()).initName(routeName);
                continue;
            }
            ArrayListMultimap signs = ArrayListMultimap.create();
            ArrayListMultimap starts = ArrayListMultimap.create();
            ArrayListMultimap ends = ArrayListMultimap.create();
            ArrayListMultimap vias = ArrayListMultimap.create();
            for (TripPattern pattern : routeTripPatterns) {
                String headsign;
                StopLocation start = pattern.firstStop();
                StopLocation end = pattern.lastStop();
                String string = headsign = pattern.getTripHeadsign() != null ? pattern.getTripHeadsign().toString() : null;
                if (headsign != null) {
                    signs.put((Object)headsign, (Object)pattern);
                }
                starts.put((Object)start, (Object)pattern);
                ends.put((Object)end, (Object)pattern);
                for (StopLocation stop : pattern.getStops()) {
                    vias.put((Object)stop, (Object)pattern);
                }
            }
            block4: for (TripPattern pattern : routeTripPatterns) {
                String headsign;
                if (pattern.getName() != null) continue;
                StringBuilder sb = new StringBuilder(routeName);
                String string = headsign = pattern.getTripHeadsign() != null ? pattern.getTripHeadsign().toString() : null;
                if (headsign != null && signs.get((Object)headsign).size() == 1) {
                    pattern.initName(sb.append(" ").append(headsign).toString());
                    continue;
                }
                StopLocation end = pattern.lastStop();
                sb.append(" to ").append(TripPatternNamer.stopNameAndId(end));
                if (ends.get((Object)end).size() == 1) {
                    pattern.initName(sb.toString());
                    continue;
                }
                StopLocation start = pattern.firstStop();
                sb.append(" from ").append(TripPatternNamer.stopNameAndId(start));
                if (starts.get((Object)start).size() == 1) {
                    pattern.initName(sb.toString());
                    continue;
                }
                Collection tripPatterns = starts.get((Object)start);
                HashSet remainingPatterns = new HashSet(tripPatterns);
                remainingPatterns.retainAll(ends.get((Object)end));
                if (remainingPatterns.size() == 1) {
                    pattern.initName(sb.toString());
                    continue;
                }
                for (StopLocation via : pattern.getStops()) {
                    if (via.equals(start) || via.equals(end)) continue;
                    HashSet intersection = new HashSet(remainingPatterns);
                    intersection.retainAll(vias.get((Object)via));
                    if (intersection.size() != 1) continue;
                    sb.append(" via ").append(TripPatternNamer.stopNameAndId(via));
                    pattern.initName(sb.toString());
                    continue block4;
                }
                if (remainingPatterns.size() == 2) {
                    sb.append(" express");
                } else {
                    Optional.ofNullable(pattern.getScheduledTimetable().getRepresentativeTripTimes()).map(TripTimes::getTrip).ifPresent(value -> sb.append(" like trip ").append(value.getId()));
                }
                pattern.initName(sb.toString());
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Done generating unique names for stop patterns on each route.");
            for (Route route : patternsByRoute.keySet()) {
                routeTripPatterns = patternsByRoute.get((Object)route);
                LOG.debug("Named {} patterns in route {}", (Object)routeTripPatterns.size(), (Object)route.getName());
                for (TripPattern pattern : routeTripPatterns) {
                    LOG.debug("    {} ({} stops)", (Object)pattern.getName(), (Object)pattern.numberOfStops());
                }
            }
        }
    }

    private static String stopNameAndId(StopLocation stop) {
        return stop.getName() + " (" + stop.getId().toString() + ")";
    }
}

