/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module;

import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import javax.inject.Inject;
import org.opentripplanner.graph_builder.model.GraphBuilderModule;
import org.opentripplanner.model.Timetable;
import org.opentripplanner.transit.service.TransitModel;

public class TimeZoneAdjusterModule
implements GraphBuilderModule {
    private final TransitModel transitModel;

    @Inject
    public TimeZoneAdjusterModule(TransitModel transitModel) {
        this.transitModel = transitModel;
    }

    @Override
    public void buildGraph() {
        Instant serviceStart = this.transitModel.getTransitServiceStarts().toInstant();
        Duration graphOffset = Duration.ofSeconds(this.transitModel.getTimeZone().getRules().getOffset(serviceStart).getTotalSeconds());
        HashMap agencyShift = new HashMap();
        this.transitModel.getAllTripPatterns().forEach(pattern -> {
            Duration timeShift = agencyShift.computeIfAbsent(pattern.getRoute().getAgency().getTimezone(), zoneId -> graphOffset.minusSeconds(zoneId.getRules().getOffset(serviceStart).getTotalSeconds()));
            if (timeShift.isZero()) {
                return;
            }
            Timetable scheduledTimetable = pattern.getScheduledTimetable();
            scheduledTimetable.getTripTimes().forEach(tripTimes -> tripTimes.timeShift(timeShift));
            scheduledTimetable.getFrequencyEntries().forEach(frequencyEntry -> frequencyEntry.tripTimes.timeShift(timeShift));
        });
    }

    @Override
    public void checkInputs() {
    }
}

