/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.issues;

import org.opentripplanner.common.OsmUrlGenerator;
import org.opentripplanner.graph_builder.DataImportIssue;
import org.opentripplanner.routing.graph.Vertex;

public class PrunedIslandStop
implements DataImportIssue {
    public static final String FMT = "Stop %s was linked to a pruned sub graph";
    final Vertex vertex;

    public PrunedIslandStop(Vertex vertex) {
        this.vertex = vertex;
    }

    @Override
    public String getMessage() {
        return String.format(FMT, this.vertex.getLabel());
    }

    @Override
    public String getHTMLMessage() {
        String url = OsmUrlGenerator.fromCoordinate(this.vertex.getCoordinate());
        return "<a href=\"%s\">%s</a>".formatted(url, this.getMessage());
    }

    @Override
    public Vertex getReferencedVertex() {
        return this.vertex;
    }
}

