/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.opentripplanner.datastore.api.CompositeDataSource;
import org.opentripplanner.datastore.api.DataSource;
import org.opentripplanner.graph_builder.DataImportIssue;
import org.opentripplanner.graph_builder.DataImportIssueStore;
import org.opentripplanner.graph_builder.IssueColors;
import org.opentripplanner.graph_builder.model.GraphBuilderModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataImportIssuesToHTML
implements GraphBuilderModule {
    private static final Logger LOG = LoggerFactory.getLogger(DataImportIssuesToHTML.class);
    private final CompositeDataSource reportDirectory;
    private final int maxNumberOfIssuesPerFile;
    private final Multiset<String> issueTypeOccurrences = HashMultiset.create();
    private final List<HTMLWriter> writers = new ArrayList<HTMLWriter>();
    private final Multimap<String, String> issues = ArrayListMultimap.create();
    private final DataImportIssueStore issueStore;

    public DataImportIssuesToHTML(DataImportIssueStore issueStore, CompositeDataSource reportDirectory, int maxNumberOfIssuesPerFile) {
        this.issueStore = issueStore;
        this.reportDirectory = reportDirectory;
        this.maxNumberOfIssuesPerFile = maxNumberOfIssuesPerFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void buildGraph() {
        try {
            if (!this.deleteReportDirectoryAndContent()) {
                return;
            }
            for (DataImportIssue dataImportIssue : this.issueStore.getIssues()) {
                this.addIssue(dataImportIssue);
            }
            LOG.info("Creating data import issue log");
            for (Map.Entry entry : this.issues.asMap().entrySet()) {
                ArrayList<String> issueList = entry.getValue() instanceof List ? (ArrayList<String>)entry.getValue() : new ArrayList<String>((Collection)entry.getValue());
                this.addIssues((String)entry.getKey(), issueList);
            }
            for (HTMLWriter hTMLWriter : this.writers) {
                hTMLWriter.writeFile(this.issueTypeOccurrences, false);
            }
            try {
                HTMLWriter indexFileWriter = new HTMLWriter("index", (Multimap<String, String>)((Multimap)null));
                indexFileWriter.writeFile(this.issueTypeOccurrences, true);
            }
            catch (Exception e) {
                LOG.error("Index file coudn't be created:{}", (Object)e.getMessage());
            }
            LOG.info("Data import issue logs are in {}", (Object)this.reportDirectory.path());
        }
        catch (Exception e) {
            LOG.error("OTP failed to save issue report!", (Throwable)e);
        }
        finally {
            this.closeReportDirectory();
        }
    }

    @Override
    public void checkInputs() {
    }

    private boolean deleteReportDirectoryAndContent() {
        if (this.reportDirectory == null) {
            LOG.error("Saving folder is empty!");
            return false;
        }
        if (this.reportDirectory.exists()) {
            try {
                this.reportDirectory.delete();
            }
            catch (Exception e) {
                LOG.error("Failed to clean HTML report directory: " + this.reportDirectory.path() + ". HTML report won't be generated!", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    private void addIssues(String issueTypeName, List<String> issues) {
        if ((double)issues.size() > 1.2 * (double)this.maxNumberOfIssuesPerFile) {
            LOG.debug("Number of issues is very large. Splitting: {}", (Object)issueTypeName);
            List partitions = Lists.partition(issues, (int)this.maxNumberOfIssuesPerFile);
            for (List partition : partitions) {
                this.issueTypeOccurrences.add((Object)issueTypeName);
                int labelCount = this.issueTypeOccurrences.count((Object)issueTypeName);
                HTMLWriter file_writer = new HTMLWriter(issueTypeName + labelCount, partition);
                this.writers.add(file_writer);
            }
        } else {
            this.issueTypeOccurrences.add((Object)issueTypeName);
            int labelCount = this.issueTypeOccurrences.count((Object)issueTypeName);
            HTMLWriter file_writer = new HTMLWriter(issueTypeName + labelCount, issues);
            this.writers.add(file_writer);
        }
    }

    private void addIssue(DataImportIssue issue) {
        this.issues.put((Object)issue.getType(), (Object)issue.getHTMLMessage());
    }

    private void closeReportDirectory() {
        try {
            this.reportDirectory.close();
        }
        catch (IOException e) {
            LOG.warn("Failed to close report directory: {}, details: {}. ", new Object[]{this.reportDirectory.path(), e.getLocalizedMessage(), e});
        }
    }

    class HTMLWriter {
        private final DataSource target;
        private final Multimap<String, String> writerIssues;
        private final String issueTypeName;

        HTMLWriter(String key, Collection<String> issues) {
            LOG.debug("Making file: {}", (Object)key);
            this.target = DataImportIssuesToHTML.this.reportDirectory.entry(key + ".html");
            this.writerIssues = ArrayListMultimap.create();
            this.writerIssues.putAll((Object)key, issues);
            this.issueTypeName = key;
        }

        HTMLWriter(String filename, Multimap<String, String> curMap) {
            LOG.debug("Making file: {}", (Object)filename);
            this.target = DataImportIssuesToHTML.this.reportDirectory.entry(filename + ".html");
            this.writerIssues = curMap;
            this.issueTypeName = filename;
        }

        private void writeFile(Multiset<String> classes, boolean isIndexFile) {
            try (PrintWriter out = new PrintWriter(this.target.asOutputStream(), true, StandardCharsets.UTF_8);){
                out.println("<html><head><title>Graph report for OTP Graph</title>");
                out.println("\t<meta charset=\"utf-8\">");
                out.println("<meta name='viewport' content='width=device-width, initial-scale=1'>");
                out.println("<script src='http://code.jquery.com/jquery-1.11.1.js'></script>");
                out.println("<link rel='stylesheet' href='http://yui.yahooapis.com/pure/0.5.0/pure-min.css'>");
                String css = "\t\t<style>\n\n\t\t\tbutton.pure-button {\n\t\t\t\tmargin:5px;\n\t\t\t}\n\n\t\t\tspan.pure-button {\n\t\t\t\tcursor:default;\n\t\t\t}\n\n\t\t\t.button-graphwide,\n\t\t\t.button-parkandrideunlinked,\n\t\t\t.button-graphconnectivity,\n\t\t\t.button-turnrestrictionbad\t{\n\t\t\t\tcolor:white;\n\t\t\t\ttext-shadow: 0 1px 1px rgba(0, 0, 0, 0.2);\n\t\t\t}\n\n\t\t\t.button-graphwide {\n\t\t\t\tbackground: rgb(28, 184, 65); /* this is a green */\n\t\t\t}\n\n\t\t\t.button-parkandrideunlinked {\n\t\t\t\tbackground: rgb(202, 60, 60); /* this is a maroon */\n\t\t\t}\n\n\t\t\t.button-graphconnectivity{\n\t\t\t\tbackground: rgb(223, 117, 20); /* this is an orange */\n\t\t\t}\n\n\t\t\t.button-turnrestrictionbad {\n\t\t\t\tbackground: rgb(66, 184, 221); /* this is a light blue */\n\t\t\t}\n\n\t\t</style>\n";
                out.println(css);
                out.println("</head><body>");
                out.println(String.format("<h1>OpenTripPlanner data import issue log for %s</h1>", this.issueTypeName));
                out.println("<h2>Graph report for <em>graph.obj</em></h2>");
                out.println("<p>");
                for (Multiset.Entry htmlIssueType : classes.entrySet()) {
                    String label_name = (String)htmlIssueType.getElement();
                    for (int currentCount = 1; currentCount <= htmlIssueType.getCount(); ++currentCount) {
                        String label = label_name + currentCount;
                        if (label.equals(this.issueTypeName)) {
                            out.printf("<button class='pure-button pure-button-disabled button-%s' style='background-color: %s;'>%s</button>%n", label_name.toLowerCase(), IssueColors.rgb(label_name), label);
                            continue;
                        }
                        out.printf("<a class='pure-button button-%s' href=\"%s.html\" style='background-color: %s;'>%s</a>%n", label_name.toLowerCase(), label, IssueColors.rgb(label_name), label);
                    }
                }
                out.println("</p>");
                if (!isIndexFile) {
                    out.println("<ul id=\"log\">");
                    this.writeIssues(out);
                    out.println("</ul>");
                }
                out.println("</body></html>");
            }
        }

        private void writeIssues(PrintWriter out) {
            String FMT = "<li>%s</li>";
            for (Map.Entry it : this.writerIssues.entries()) {
                out.printf(FMT, it.getValue());
            }
        }
    }
}

