/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.vilkkubikerental;

import java.time.Instant;
import java.util.List;
import java.util.Map;
import org.opentripplanner.ext.vilkkubikerental.VilkkuBikeRentalDataSourceParameters;
import org.opentripplanner.routing.vehicle_rental.RentalVehicleType;
import org.opentripplanner.routing.vehicle_rental.VehicleRentalPlace;
import org.opentripplanner.routing.vehicle_rental.VehicleRentalStation;
import org.opentripplanner.transit.model.basic.NonLocalizedString;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.updater.GenericXmlDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VilkkuBikeRentalDataSource
extends GenericXmlDataSource<VehicleRentalPlace> {
    private static final Logger LOG = LoggerFactory.getLogger(VilkkuBikeRentalDataSource.class);
    public static final String DEFAULT_FEED_NAME = "vilkku";
    private static final String stationXpath = "//station";
    private static final List<String> REQUIRED_STATION_PROPERTIES = List.of("name", "externallyLockedBikes", "latitude", "longitude");
    private final String network;

    public VilkkuBikeRentalDataSource(VilkkuBikeRentalDataSourceParameters config) {
        super(config.getUrl(), stationXpath);
        this.network = config.network();
    }

    @Override
    protected VehicleRentalPlace parseElement(Map<String, String> attributes) {
        if (!this.checkProperties(attributes)) {
            return null;
        }
        VehicleRentalStation station = new VehicleRentalStation();
        station.id = this.id(attributes.get("name"));
        try {
            station.longitude = this.getCoordinate(attributes.get("longitude"));
            station.latitude = this.getCoordinate(attributes.get("latitude"));
        }
        catch (NumberFormatException e) {
            LOG.warn("Error parsing bike rental station location {}", (Object)station.id, (Object)e);
            return null;
        }
        station.name = new NonLocalizedString(attributes.get("name"));
        station.vehiclesAvailable = Integer.parseInt(attributes.get("externallyLockedBikes"));
        station.vehiclesDisabled = 0;
        station.spacesAvailable = Integer.MAX_VALUE;
        station.vehicleSpacesAvailable = Map.of(RentalVehicleType.getDefaultType(station.getNetwork()), station.spacesAvailable);
        station.spacesDisabled = 0;
        station.capacity = 0;
        station.isInstalled = true;
        station.isRenting = true;
        station.isReturning = true;
        station.lastReported = Instant.now();
        return station;
    }

    private Boolean checkProperty(Map<String, String> attributes, String property) {
        if (!attributes.containsKey("name")) {
            LOG.warn("Missing required property {} in Vilkku XML, cannot create bike rental station.", (Object)property);
            return false;
        }
        return true;
    }

    private boolean checkProperties(Map<String, String> attributes) {
        return REQUIRED_STATION_PROPERTIES.stream().allMatch(prop -> this.checkProperty(attributes, (String)prop));
    }

    private double getCoordinate(String coordinate) {
        if (coordinate.contains(",")) {
            return Double.parseDouble(coordinate.replace(",", "."));
        }
        return Double.parseDouble(coordinate);
    }

    private FeedScopedId id(String id) {
        return new FeedScopedId(this.getNetworkId(), id);
    }

    private String getNetworkId() {
        return this.network != null ? this.network : DEFAULT_FEED_NAME;
    }
}

