/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.vehicletostopheuristics;

import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import org.opentripplanner.routing.algorithm.astar.strategies.SkipEdgeStrategy;
import org.opentripplanner.routing.api.request.StreetMode;
import org.opentripplanner.routing.core.State;
import org.opentripplanner.routing.graph.Edge;
import org.opentripplanner.routing.graph.Vertex;
import org.opentripplanner.routing.vertextype.TransitStopVertex;
import org.opentripplanner.transit.model.basic.TransitMode;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.network.Route;
import org.opentripplanner.transit.model.site.RegularStop;

public class VehicleToStopSkipEdgeStrategy
implements SkipEdgeStrategy {
    public static final Set<StreetMode> applicableModes = Set.of(StreetMode.BIKE_TO_PARK, StreetMode.BIKE_RENTAL, StreetMode.CAR_TO_PARK, StreetMode.CAR_PICKUP, StreetMode.CAR_RENTAL, StreetMode.SCOOTER_RENTAL);
    private final Function<RegularStop, Set<Route>> getRoutesForStop;
    private final int maxScore;
    private final EnumSet<TransitMode> allowedModes;
    private double sumOfScores;
    private final Set<FeedScopedId> stopsCounted = new HashSet<FeedScopedId>();

    public VehicleToStopSkipEdgeStrategy(Function<RegularStop, Set<Route>> getRoutesForStop, Collection<TransitMode> allowedModes) {
        this.allowedModes = EnumSet.copyOf(allowedModes);
        this.maxScore = 300;
        this.getRoutesForStop = getRoutesForStop;
    }

    @Override
    public boolean shouldSkipEdge(State current, Edge edge) {
        if (current.getNonTransitMode().isWalking()) {
            TransitStopVertex stopVertex;
            Vertex vertex = current.getVertex();
            if (vertex instanceof TransitStopVertex && !this.stopsCounted.contains((stopVertex = (TransitStopVertex)vertex).getStop().getId())) {
                RegularStop stop = stopVertex.getStop();
                int score = this.getRoutesForStop.apply(stop).stream().map(Route::getMode).filter(this.allowedModes::contains).mapToInt(VehicleToStopSkipEdgeStrategy::score).sum();
                this.stopsCounted.add(stop.getId());
                this.sumOfScores += (double)score;
            }
            return false;
        }
        return this.sumOfScores >= (double)this.maxScore;
    }

    private static int score(TransitMode mode) {
        return switch (mode) {
            case TransitMode.RAIL, TransitMode.FERRY, TransitMode.SUBWAY -> 20;
            case TransitMode.BUS -> 1;
            default -> 2;
        };
    }
}

