/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.vehicleparking.kml;

import java.util.List;
import java.util.Locale;
import org.opentripplanner.ext.vehicleparking.kml.KmlUpdaterParameters;
import org.opentripplanner.routing.vehicle_parking.VehicleParking;
import org.opentripplanner.transit.model.basic.NonLocalizedString;
import org.opentripplanner.transit.model.basic.WgsCoordinate;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.updater.DataSource;
import org.opentripplanner.util.xml.XmlDataListDownloader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KmlBikeParkDataSource
implements DataSource<VehicleParking> {
    private static final Logger LOG = LoggerFactory.getLogger(KmlBikeParkDataSource.class);
    private final String url;
    private final String feedId;
    private final String namePrefix;
    private final boolean zip;
    private final XmlDataListDownloader<VehicleParking> xmlDownloader;
    private List<VehicleParking> bikeParks;

    public KmlBikeParkDataSource(KmlUpdaterParameters parameters) {
        this.url = parameters.getUrl();
        this.feedId = parameters.getFeedId();
        this.namePrefix = parameters.getNamePrefix();
        this.zip = parameters.isZip();
        this.xmlDownloader = new XmlDataListDownloader();
        this.xmlDownloader.setPath("//*[local-name()='kml']/*[local-name()='Document']/*[local-name()='Placemark']|//*[local-name()='kml']/*[local-name()='Document']/*[local-name()='Folder']/*[local-name()='Placemark']");
        this.xmlDownloader.setDataFactory(attributes -> {
            if (!attributes.containsKey("name")) {
                LOG.warn("Missing name in KML Placemark, cannot create bike park.");
                return null;
            }
            if (!attributes.containsKey("Point")) {
                LOG.warn("Missing Point geometry in KML Placemark, cannot create bike park.");
                return null;
            }
            String name = (this.namePrefix != null ? this.namePrefix : "") + ((String)attributes.get("name")).trim();
            String[] coords = ((String)attributes.get("Point")).trim().split(",");
            double x = Double.parseDouble(coords[0]);
            double y = Double.parseDouble(coords[1]);
            String id = String.format(Locale.ROOT, "%s[%.3f-%.3f]", name.replace(" ", "_"), x, y);
            NonLocalizedString localizedName = new NonLocalizedString(name);
            return VehicleParking.builder().name(localizedName).coordinate(new WgsCoordinate(y, x)).id(new FeedScopedId(this.feedId, id)).entrance(builder -> builder.entranceId(new FeedScopedId(this.feedId, id)).name(localizedName).coordinate(new WgsCoordinate(y, x)).walkAccessible(true)).build();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean update() {
        List<VehicleParking> newBikeParks = this.xmlDownloader.download(this.url, this.zip);
        if (newBikeParks != null) {
            KmlBikeParkDataSource kmlBikeParkDataSource = this;
            synchronized (kmlBikeParkDataSource) {
                this.bikeParks = newBikeParks;
            }
            return true;
        }
        return false;
    }

    @Override
    public synchronized List<VehicleParking> getUpdates() {
        return this.bikeParks;
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.url + ")";
    }
}

