/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.traveltime.geometry;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.locationtech.jts.algorithm.Area;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateArrays;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.opentripplanner.ext.traveltime.geometry.DelaunayEdge;
import org.opentripplanner.ext.traveltime.geometry.DelaunayTriangulation;
import org.opentripplanner.ext.traveltime.geometry.IsolineBuilder;
import org.opentripplanner.ext.traveltime.geometry.ZMetric;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelaunayIsolineBuilder<TZ>
implements IsolineBuilder<TZ> {
    private static final Logger LOG = LoggerFactory.getLogger(DelaunayIsolineBuilder.class);
    private final ZMetric<TZ> zMetric;
    private final DelaunayTriangulation<TZ> triangulation;
    private final GeometryFactory geometryFactory = new GeometryFactory();
    private final List<Geometry> debugGeom = new ArrayList<Geometry>();
    private boolean debug = false;

    public DelaunayIsolineBuilder(DelaunayTriangulation<TZ> triangulation, ZMetric<TZ> zMetric) {
        this.triangulation = triangulation;
        this.zMetric = zMetric;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    @Override
    public Geometry computeIsoline(TZ z0) {
        ArrayDeque processQ = new ArrayDeque(this.triangulation.edgesCount());
        for (DelaunayEdge e : this.triangulation.edges()) {
            e.setProcessed(false);
            processQ.add(e);
        }
        if (this.debug) {
            this.generateDebugGeometry(z0);
        }
        ArrayList<LinearRing> rings = new ArrayList<LinearRing>();
        while (!processQ.isEmpty()) {
            DelaunayEdge e;
            e = (DelaunayEdge)processQ.remove();
            if (e.isProcessed()) continue;
            e.setProcessed(true);
            int cut = this.zMetric.cut(e.getA().getZ(), e.getB().getZ(), z0);
            if (cut == 0) continue;
            ArrayList<Coordinate> polyPoints = new ArrayList<Coordinate>();
            boolean ccw = cut > 0;
            while (true) {
                boolean ok2;
                Coordinate cA = e.getA().getCoordinates();
                Coordinate cB = e.getB().getCoordinates();
                double k = this.zMetric.interpolate(e.getA().getZ(), e.getB().getZ(), z0);
                Coordinate cC = new Coordinate(cA.x * (1.0 - k) + cB.x * k, cA.y * (1.0 - k) + cB.y * k);
                polyPoints.add(cC);
                e.setProcessed(true);
                DelaunayEdge E1 = e.getEdge1(ccw);
                DelaunayEdge E2 = e.getEdge2(ccw);
                int cut1 = E1 == null ? 0 : this.zMetric.cut(E1.getA().getZ(), E1.getB().getZ(), z0);
                int cut2 = E2 == null ? 0 : this.zMetric.cut(E2.getA().getZ(), E2.getB().getZ(), z0);
                boolean ok1 = cut1 != 0 && !E1.isProcessed();
                boolean bl = ok2 = cut2 != 0 && !E2.isProcessed();
                if (ok1) {
                    e = E1;
                    ccw = cut1 > 0;
                    continue;
                }
                if (!ok2) break;
                e = E2;
                ccw = cut2 > 0;
            }
            polyPoints.add((Coordinate)polyPoints.get(0));
            if (polyPoints.size() <= 5) continue;
            LinearRing ring = this.geometryFactory.createLinearRing(CoordinateArrays.toCoordinateArray(polyPoints));
            rings.add(ring);
        }
        return this.punchHoles(rings);
    }

    private void generateDebugGeometry(TZ z0) {
        this.debug = false;
        for (DelaunayEdge<TZ> e : this.triangulation.edges()) {
            Coordinate cA = e.getA().getCoordinates();
            Coordinate cB = e.getB().getCoordinates();
            this.debugGeom.add((Geometry)this.geometryFactory.createLineString(new Coordinate[]{cA, cB}));
            if (this.zMetric.cut(e.getA().getZ(), e.getB().getZ(), z0) == 0) continue;
            double k = this.zMetric.interpolate(e.getA().getZ(), e.getB().getZ(), z0);
            Coordinate cC = new Coordinate(cA.x * (1.0 - k) + cB.x * k, cA.y * (1.0 - k) + cB.y * k);
            this.debugGeom.add((Geometry)this.geometryFactory.createPoint(cC));
        }
    }

    public final Geometry getDebugGeometry() {
        return this.geometryFactory.createGeometryCollection(GeometryFactory.toGeometryArray(this.debugGeom));
    }

    private MultiPolygon punchHoles(List<LinearRing> rings) {
        ArrayList<Polygon> shells = new ArrayList<Polygon>(rings.size());
        ArrayList<LinearRing> holes = new ArrayList<LinearRing>(rings.size() / 2);
        for (LinearRing linearRing : rings) {
            if (Area.ofRingSigned((CoordinateSequence)linearRing.getCoordinateSequence()) > 0.0) {
                holes.add(linearRing);
                continue;
            }
            shells.add(this.geometryFactory.createPolygon(linearRing));
        }
        shells.sort((o1, o2) -> o2.getNumPoints() - o1.getNumPoints());
        for (Polygon polygon : shells) {
            polygon.setUserData(new ArrayList());
        }
        int nHolesFailed = 0;
        block2: for (LinearRing hole : holes) {
            for (Polygon shell : shells) {
                if (!shell.contains((Geometry)hole)) continue;
                ((List)shell.getUserData()).add(hole);
                continue block2;
            }
            ++nHolesFailed;
        }
        if (nHolesFailed > 0) {
            LOG.error("Could not find a shell for {} holes.", (Object)nHolesFailed);
        }
        ArrayList<Polygon> arrayList = new ArrayList<Polygon>(shells.size());
        for (Polygon shell : shells) {
            List shellHoles = (List)shell.getUserData();
            arrayList.add(this.geometryFactory.createPolygon(shell.getExteriorRing(), GeometryFactory.toLinearRingArray((Collection)shellHoles)));
        }
        return this.geometryFactory.createMultiPolygon(GeometryFactory.toPolygonArray(arrayList));
    }
}

