/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.traveltime;

import org.locationtech.jts.geom.Coordinate;
import org.opentripplanner.ext.traveltime.SampleGridSPTVisitor;
import org.opentripplanner.ext.traveltime.TravelTimeRequest;
import org.opentripplanner.ext.traveltime.WTWD;
import org.opentripplanner.ext.traveltime.WTWDAccumulativeMetric;
import org.opentripplanner.ext.traveltime.geometry.AccumulativeGridSampler;
import org.opentripplanner.ext.traveltime.geometry.SparseMatrixZSampleGrid;
import org.opentripplanner.ext.traveltime.geometry.ZSampleGrid;
import org.opentripplanner.ext.traveltime.spt.SPTWalker;
import org.opentripplanner.routing.spt.ShortestPathTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SampleGridRenderer {
    private static final Logger LOG = LoggerFactory.getLogger(SampleGridRenderer.class);

    public static ZSampleGrid<WTWD> getSampleGrid(ShortestPathTree spt, TravelTimeRequest traveltimeRequest) {
        double offRoadDistanceMeters = traveltimeRequest.offRoadDistanceMeters;
        double offRoadWalkSpeedMps = 1.0;
        long t1 = System.currentTimeMillis();
        Coordinate coordinateOrigin = spt.getAllStates().iterator().next().getVertex().getCoordinate();
        double gridSizeMeters = traveltimeRequest.precisionMeters;
        double cosLat = Math.cos(Math.toRadians(coordinateOrigin.y));
        double dY = Math.toDegrees(gridSizeMeters / 6371010.0);
        double dX = dY / cosLat;
        SparseMatrixZSampleGrid<WTWD> sampleGrid = new SparseMatrixZSampleGrid<WTWD>(16, spt.getVertexCount(), dX, dY, coordinateOrigin);
        SampleGridRenderer.sampleSPT(spt, sampleGrid, gridSizeMeters, offRoadDistanceMeters, 1.0, (int)traveltimeRequest.maxCutoff.getSeconds(), cosLat);
        long t2 = System.currentTimeMillis();
        LOG.info("Computed sampling in {}msec", (Object)((int)(t2 - t1)));
        return sampleGrid;
    }

    public static void sampleSPT(ShortestPathTree spt, ZSampleGrid<WTWD> sampleGrid, double gridSizeMeters, double offRoadDistanceMeters, double offRoadWalkSpeedMps, int maxTimeSec, double cosLat) {
        WTWDAccumulativeMetric accMetric = new WTWDAccumulativeMetric(cosLat, offRoadDistanceMeters, offRoadWalkSpeedMps, gridSizeMeters);
        AccumulativeGridSampler<WTWD> gridSampler = new AccumulativeGridSampler<WTWD>(sampleGrid, accMetric);
        double walkerSplitDistanceMeters = gridSizeMeters * 0.5;
        SampleGridSPTVisitor visitor = new SampleGridSPTVisitor(maxTimeSec, gridSampler, offRoadWalkSpeedMps);
        new SPTWalker(spt).walk(visitor, walkerSplitDistanceMeters);
        gridSampler.close();
    }
}

