/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.traveltime;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.locationtech.jts.geom.Geometry;
import org.opentripplanner.ext.traveltime.IsochroneData;
import org.opentripplanner.ext.traveltime.IsolineMetric;
import org.opentripplanner.ext.traveltime.TravelTimeRequest;
import org.opentripplanner.ext.traveltime.WTWD;
import org.opentripplanner.ext.traveltime.geometry.DelaunayIsolineBuilder;
import org.opentripplanner.ext.traveltime.geometry.ZSampleGrid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsochroneRenderer {
    private static final Logger LOG = LoggerFactory.getLogger(IsochroneRenderer.class);

    static List<IsochroneData> renderIsochrones(ZSampleGrid<WTWD> sampleGrid, TravelTimeRequest traveltimeRequest) {
        long t0 = System.currentTimeMillis();
        IsolineMetric zMetric = new IsolineMetric();
        DelaunayIsolineBuilder<WTWD> isolineBuilder = new DelaunayIsolineBuilder<WTWD>(sampleGrid.delaunayTriangulate(), zMetric);
        isolineBuilder.setDebug(traveltimeRequest.includeDebugGeometry);
        ArrayList<IsochroneData> isochrones = new ArrayList<IsochroneData>();
        for (Duration cutoff : traveltimeRequest.cutoffs) {
            long cutoffSec = cutoff.toSeconds();
            WTWD z0 = new WTWD();
            z0.w = 1.0;
            z0.wTime = cutoffSec;
            z0.d = traveltimeRequest.offRoadDistanceMeters;
            Geometry geometry = isolineBuilder.computeIsoline(z0);
            Geometry debugGeometry = null;
            Objects.requireNonNull(traveltimeRequest);
            isochrones.add(new IsochroneData(cutoffSec, geometry, debugGeometry));
        }
        long t1 = System.currentTimeMillis();
        LOG.info("Computed {} isochrones in {}msec", (Object)isochrones.size(), (Object)((int)(t1 - t0)));
        return isochrones;
    }
}

