/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.transmodelapi.model.timetable;

import graphql.AssertException;
import graphql.Scalars;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import java.util.List;
import java.util.Optional;
import org.opentripplanner.ext.transmodelapi.model.EnumTypes;
import org.opentripplanner.ext.transmodelapi.support.GqlUtil;
import org.opentripplanner.routing.TripTimesShortHelper;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.model.timetable.TripOnServiceDate;
import org.opentripplanner.transit.service.TransitService;

public class DatedServiceJourneyType {
    private static final String NAME = "DatedServiceJourney";
    public static final GraphQLTypeReference REF = new GraphQLTypeReference("DatedServiceJourney");

    public static GraphQLObjectType create(GraphQLOutputType serviceJourneyType, GraphQLOutputType journeyPatternType, GraphQLType estimatedCallType, GraphQLType quayType, GqlUtil gqlUtil) {
        return GraphQLObjectType.newObject().name(NAME).description("A planned journey on a specific day").field(GqlUtil.newTransitIdField()).field(GraphQLFieldDefinition.newFieldDefinition().name("operatingDay").description("The date this service runs. The date used is based on the service date as opposed to calendar date.").type((GraphQLOutputType)gqlUtil.dateScalar).dataFetcher(environment -> Optional.of(DatedServiceJourneyType.tripOnServiceDate(environment)).map(TripOnServiceDate::getServiceDate).orElse(null))).field(GraphQLFieldDefinition.newFieldDefinition().name("serviceJourney").description("The service journey this Dated Service Journey is based on").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)serviceJourneyType)).dataFetcher(environment -> DatedServiceJourneyType.tripOnServiceDate(environment).getTrip())).field(GraphQLFieldDefinition.newFieldDefinition().name("tripAlteration").description("Alterations specified on the Trip in the planned data").type((GraphQLOutputType)EnumTypes.SERVICE_ALTERATION).dataFetcher(environment -> DatedServiceJourneyType.tripOnServiceDate(environment).getTripAlteration())).field(GraphQLFieldDefinition.newFieldDefinition().name("replacementFor").description("List of the dated service journeys this dated service journeys replaces").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)new GraphQLNonNull((GraphQLType)REF)))).dataFetcher(environment -> DatedServiceJourneyType.tripOnServiceDate(environment).getReplacementFor())).field(GraphQLFieldDefinition.newFieldDefinition().name("journeyPattern").description("JourneyPattern for the dated service journey.").type(journeyPatternType).dataFetcher(DatedServiceJourneyType::tripPattern).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("quays").description("Quays visited by the dated service journey.").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)new GraphQLNonNull(quayType)))).argument(GraphQLArgument.newArgument().name("first").description("Only fetch the first n quays on the service journey").type((GraphQLInputType)Scalars.GraphQLInt).build()).argument(GraphQLArgument.newArgument().name("last").description("Only fetch the last n quays on the service journey").type((GraphQLInputType)Scalars.GraphQLInt).build()).dataFetcher(environment -> {
            Integer first = (Integer)environment.getArgument("first");
            Integer last = (Integer)environment.getArgument("last");
            TripPattern tripPattern = DatedServiceJourneyType.tripPattern(environment);
            if (tripPattern == null) {
                return List.of();
            }
            List<StopLocation> stops = tripPattern.getStops();
            if (first != null && last != null) {
                throw new AssertException("Both first and last can't be defined simultaneously.");
            }
            if (first != null) {
                if (first > stops.size()) {
                    return stops.subList(0, first);
                }
            } else if (last != null && last > stops.size()) {
                return stops.subList(stops.size() - last, stops.size());
            }
            return stops;
        }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("estimatedCalls").type((GraphQLOutputType)new GraphQLList(estimatedCallType)).withDirective(gqlUtil.timingData).description("Returns scheduled passingTimes for this dated service journey, updated with realtime-updates (if available). ").dataFetcher(environment -> {
            TripOnServiceDate tripOnServiceDate = DatedServiceJourneyType.tripOnServiceDate(environment);
            return TripTimesShortHelper.getTripTimesShort(GqlUtil.getTransitService(environment), tripOnServiceDate.getTrip(), tripOnServiceDate.getServiceDate());
        }).build()).build();
    }

    private static TripPattern tripPattern(DataFetchingEnvironment env) {
        TransitService transitService = GqlUtil.getTransitService(env);
        TripOnServiceDate tripOnServiceDate = DatedServiceJourneyType.tripOnServiceDate(env);
        return transitService.getPatternForTrip(tripOnServiceDate.getTrip(), tripOnServiceDate.getServiceDate());
    }

    private static TripOnServiceDate tripOnServiceDate(DataFetchingEnvironment environment) {
        return (TripOnServiceDate)environment.getSource();
    }
}

