/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.transmodelapi.model.timetable;

import graphql.Scalars;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import org.opentripplanner.ext.transmodelapi.mapping.TransitIdMapper;
import org.opentripplanner.ext.transmodelapi.model.EnumTypes;
import org.opentripplanner.ext.transmodelapi.support.GqlUtil;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.timetable.TripOnServiceDate;

public class DatedServiceJourneyQuery {
    public static GraphQLFieldDefinition createGetById(GraphQLOutputType datedServiceJourneyType) {
        return GraphQLFieldDefinition.newFieldDefinition().name("datedServiceJourney").type(datedServiceJourneyType).description("Get a single dated service journey based on its id").argument(GraphQLArgument.newArgument().name("id").type((GraphQLInputType)Scalars.GraphQLString)).dataFetcher(environment -> {
            FeedScopedId id = TransitIdMapper.mapIDToDomain((String)environment.getArgument("id"));
            return GqlUtil.getTransitService(environment).getTripOnServiceDateById(id);
        }).build();
    }

    public static GraphQLFieldDefinition createQuery(GraphQLOutputType datedServiceJourneyType, GqlUtil gqlUtil) {
        return GraphQLFieldDefinition.newFieldDefinition().name("datedServiceJourneys").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)new GraphQLNonNull((GraphQLType)datedServiceJourneyType)))).description("Get all dated service journeys, matching the filters").argument(GraphQLArgument.newArgument().name("lines").type((GraphQLInputType)new GraphQLList((GraphQLType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLString)))).argument(GraphQLArgument.newArgument().name("serviceJourneys").type((GraphQLInputType)new GraphQLList((GraphQLType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLString)))).argument(GraphQLArgument.newArgument().name("privateCodes").type((GraphQLInputType)new GraphQLList((GraphQLType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLString)))).argument(GraphQLArgument.newArgument().name("operatingDays").type((GraphQLInputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)new GraphQLNonNull((GraphQLType)gqlUtil.dateScalar))))).argument(GraphQLArgument.newArgument().name("alterations").type((GraphQLInputType)new GraphQLList((GraphQLType)new GraphQLNonNull((GraphQLType)EnumTypes.SERVICE_ALTERATION)))).argument(GraphQLArgument.newArgument().name("authorities").type((GraphQLInputType)new GraphQLList((GraphQLType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLString)))).argument(GraphQLArgument.newArgument().name("replacementFor").description("Get all DatedServiceJourneys, which are replacing any of the given DatedServiceJourneys ids").type((GraphQLInputType)new GraphQLList((GraphQLType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLString)))).dataFetcher(environment -> {
            Stream<TripOnServiceDate> stream = GqlUtil.getTransitService(environment).getAllTripOnServiceDates().stream();
            List<FeedScopedId> lines = TransitIdMapper.mapIDsToDomainNullSafe((Collection)environment.getArgument("lines"));
            List<FeedScopedId> serviceJourneys = TransitIdMapper.mapIDsToDomainNullSafe((Collection)environment.getArgument("serviceJourneys"));
            List privateCodes = (List)environment.getArgument("privateCodes");
            List operatingDays = (List)environment.getArgument("operatingDays");
            List alterations = (List)environment.getArgument("alterations");
            List<FeedScopedId> authorities = TransitIdMapper.mapIDsToDomainNullSafe((Collection)environment.getArgument("authorities"));
            List<FeedScopedId> replacementFor = TransitIdMapper.mapIDsToDomainNullSafe((Collection)environment.getArgument("replacementFor"));
            if (!lines.isEmpty()) {
                stream = stream.filter(tripOnServiceDate -> lines.contains(tripOnServiceDate.getTrip().getRoute().getId()));
            }
            if (!serviceJourneys.isEmpty()) {
                stream = stream.filter(tripOnServiceDate -> serviceJourneys.contains(tripOnServiceDate.getTrip().getId()));
            }
            if (privateCodes != null && !privateCodes.isEmpty()) {
                stream = stream.filter(tripOnServiceDate -> privateCodes.contains(tripOnServiceDate.getTrip().getNetexInternalPlanningCode()));
            }
            List days = operatingDays.stream().toList();
            stream = stream.filter(tripOnServiceDate -> days.contains(tripOnServiceDate.getServiceDate()));
            if (alterations != null && !alterations.isEmpty()) {
                stream = stream.filter(tripOnServiceDate -> alterations.contains((Object)tripOnServiceDate.getTripAlteration()));
            }
            if (!authorities.isEmpty()) {
                stream = stream.filter(tripOnServiceDate -> authorities.contains(tripOnServiceDate.getTrip().getRoute().getAgency().getId()));
            }
            if (!replacementFor.isEmpty()) {
                stream = stream.filter(tripOnServiceDate -> !tripOnServiceDate.getReplacementFor().isEmpty() && tripOnServiceDate.getReplacementFor().stream().anyMatch(replacement -> replacementFor.contains(replacement.getId())));
            }
            return stream.toList();
        }).build();
    }
}

