/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.transmodelapi.model.timetable;

import graphql.Scalars;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import org.opentripplanner.ext.transmodelapi.model.EnumTypes;
import org.opentripplanner.ext.transmodelapi.support.GqlUtil;
import org.opentripplanner.model.BookingInfo;
import org.opentripplanner.model.BookingTime;
import org.opentripplanner.transit.model.organization.ContactInfo;

public class BookingArrangementType {
    public static GraphQLObjectType create(GqlUtil gqlUtil) {
        GraphQLObjectType contactType = GraphQLObjectType.newObject().name("Contact").field(GraphQLFieldDefinition.newFieldDefinition().name("contactPerson").description("Name of person to contact").type((GraphQLOutputType)Scalars.GraphQLString).dataFetcher(environment -> BookingArrangementType.contactInfo(environment).getContactPerson()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("email").description("Email adress for contact").type((GraphQLOutputType)Scalars.GraphQLString).dataFetcher(environment -> BookingArrangementType.contactInfo(environment).geteMail()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("url").description("Url for contact").type((GraphQLOutputType)Scalars.GraphQLString).dataFetcher(environment -> BookingArrangementType.contactInfo(environment).getBookingUrl()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("phone").description("Phone number for contact").type((GraphQLOutputType)Scalars.GraphQLString).dataFetcher(environment -> BookingArrangementType.contactInfo(environment).getPhoneNumber()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("furtherDetails").description("Textual description of how to get in contact").type((GraphQLOutputType)Scalars.GraphQLString).dataFetcher(environment -> BookingArrangementType.contactInfo(environment).getAdditionalDetails()).build()).build();
        return GraphQLObjectType.newObject().name("BookingArrangement").field(GraphQLFieldDefinition.newFieldDefinition().name("bookingMethods").description("How should service be booked?").type((GraphQLOutputType)new GraphQLList((GraphQLType)EnumTypes.BOOKING_METHOD)).dataFetcher(environment -> BookingArrangementType.bookingInfo(environment).bookingMethods()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("latestBookingTime").description("Latest time the service can be booked. ISO 8601 timestamp").type((GraphQLOutputType)gqlUtil.localTimeScalar).dataFetcher(environment -> {
            BookingTime latestBookingTime = BookingArrangementType.bookingInfo(environment).getLatestBookingTime();
            return latestBookingTime == null ? null : latestBookingTime.getTime();
        }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("latestBookingDay").description("How many days prior to the travel the service needs to be booked").type((GraphQLOutputType)Scalars.GraphQLInt).dataFetcher(environment -> {
            BookingTime latestBookingTime = BookingArrangementType.bookingInfo(environment).getLatestBookingTime();
            return latestBookingTime == null ? null : Integer.valueOf(latestBookingTime.getDaysPrior());
        }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("bookWhen").description("Time constraints for booking").type((GraphQLOutputType)EnumTypes.PURCHASE_WHEN).dataFetcher(environment -> {
            BookingInfo bookingInfo = BookingArrangementType.bookingInfo(environment);
            if (bookingInfo.getMinimumBookingNotice() != null) {
                return null;
            }
            BookingTime latestBookingTime = bookingInfo.getLatestBookingTime();
            BookingTime earliestBookingTime = bookingInfo.getEarliestBookingTime();
            if (earliestBookingTime == null) {
                if (latestBookingTime == null) {
                    return "timeOfTravelOnly";
                }
                if (latestBookingTime.getDaysPrior() == 1) {
                    return "untilPreviousDay";
                }
                if (latestBookingTime.getDaysPrior() == 0) {
                    return "advanceAndDayOfTravel";
                }
                return "other";
            }
            if (earliestBookingTime.getDaysPrior() == 0 && latestBookingTime.getDaysPrior() == 0) {
                return "dayOfTravelOnly";
            }
            return "other";
        }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("minimumBookingPeriod").description("Minimum period in advance service can be booked as a ISO 8601 duration").type((GraphQLOutputType)Scalars.GraphQLString).dataFetcher(environment -> BookingArrangementType.bookingInfo(environment).getMinimumBookingNotice()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("bookingNote").description("Textual description of booking arrangement for service").type((GraphQLOutputType)Scalars.GraphQLString).dataFetcher(environment -> BookingArrangementType.bookingInfo(environment).getMessage()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("bookingContact").description("Who should ticket be contacted for booking").type((GraphQLOutputType)contactType).dataFetcher(environment -> BookingArrangementType.bookingInfo(environment).getContactInfo()).build()).build();
    }

    private static ContactInfo contactInfo(DataFetchingEnvironment environment) {
        return (ContactInfo)environment.getSource();
    }

    private static BookingInfo bookingInfo(DataFetchingEnvironment environment) {
        return (BookingInfo)environment.getSource();
    }
}

