/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.transmodelapi.model.plan;

import graphql.Scalars;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import java.util.Locale;
import org.opentripplanner.ext.transmodelapi.TransmodelGraphQLUtils;
import org.opentripplanner.ext.transmodelapi.model.EnumTypes;
import org.opentripplanner.model.plan.WalkStep;

public class PathGuidanceType {
    public static GraphQLObjectType create() {
        return GraphQLObjectType.newObject().name("PathGuidance").description("A series of turn by turn instructions used for walking, biking and driving.").field(GraphQLFieldDefinition.newFieldDefinition().name("distance").description("The distance in meters that this step takes.").type((GraphQLOutputType)Scalars.GraphQLFloat).dataFetcher(environment -> ((WalkStep)environment.getSource()).getDistance()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("relativeDirection").description("The relative direction of this step.").type((GraphQLOutputType)EnumTypes.RELATIVE_DIRECTION).dataFetcher(environment -> ((WalkStep)environment.getSource()).getRelativeDirection()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("streetName").description("The name of the street.").type((GraphQLOutputType)Scalars.GraphQLString).dataFetcher(environment -> {
            Locale locale = TransmodelGraphQLUtils.getLocale(environment);
            return ((WalkStep)environment.getSource()).getStreetName().toString(locale);
        }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("heading").description("The absolute direction of this step.").type((GraphQLOutputType)EnumTypes.ABSOLUTE_DIRECTION).dataFetcher(environment -> ((WalkStep)environment.getSource()).getAbsoluteDirection()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("exit").description("When exiting a highway or traffic circle, the exit name/number.").type((GraphQLOutputType)Scalars.GraphQLString).dataFetcher(environment -> ((WalkStep)environment.getSource()).getExit()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("stayOn").description("Indicates whether or not a street changes direction at an intersection.").type((GraphQLOutputType)Scalars.GraphQLBoolean).dataFetcher(environment -> ((WalkStep)environment.getSource()).getStayOn()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("area").description("This step is on an open area, such as a plaza or train platform, and thus the directions should say something like \"cross\"").type((GraphQLOutputType)Scalars.GraphQLBoolean).dataFetcher(environment -> ((WalkStep)environment.getSource()).getArea()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("bogusName").description("The name of this street was generated by the system, so we should only display it once, and generally just display right/left directions").type((GraphQLOutputType)Scalars.GraphQLBoolean).dataFetcher(environment -> ((WalkStep)environment.getSource()).getBogusName()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("latitude").description("The latitude of the step.").type((GraphQLOutputType)Scalars.GraphQLFloat).dataFetcher(environment -> ((WalkStep)environment.getSource()).getStartLocation().latitude()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("longitude").description("The longitude of the step.").type((GraphQLOutputType)Scalars.GraphQLFloat).dataFetcher(environment -> ((WalkStep)environment.getSource()).getStartLocation().longitude()).build()).build();
    }
}

