/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.transmodelapi.mapping;

import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.geom.Geometry;
import org.opentripplanner.ext.transmodelapi.model.util.EncodedPolylineBeanWithStops;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.util.PolylineEncoder;
import org.opentripplanner.util.model.EncodedPolyline;

public class GeometryMapper {
    public static List<EncodedPolylineBeanWithStops> mapStopToStopGeometries(TripPattern tripPattern) {
        ArrayList<EncodedPolylineBeanWithStops> stopToStopGeometries = new ArrayList<EncodedPolylineBeanWithStops>();
        for (int i = 0; i < tripPattern.numberOfStops() - 1; ++i) {
            StopLocation startLocation = tripPattern.getStop(i);
            StopLocation endLocation = tripPattern.getStop(i + 1);
            EncodedPolyline geometry = PolylineEncoder.encodeGeometry((Geometry)tripPattern.getHopGeometry(i));
            EncodedPolylineBeanWithStops stopToStopGeometry = new EncodedPolylineBeanWithStops(startLocation, endLocation, geometry);
            stopToStopGeometries.add(stopToStopGeometry);
        }
        return stopToStopGeometries;
    }
}

