/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.transferanalyzer.annotations;

import org.opentripplanner.graph_builder.DataImportIssue;
import org.opentripplanner.transit.model.site.RegularStop;

public class TransferCouldNotBeRouted
implements DataImportIssue {
    private static final String FMT = "Connection between stop %s and stop %s could not be routed. Euclidean distance is %.0f.";
    private static final String HTMLFMT = "Connection between stop <a href=\"http://www.openstreetmap.org/?mlat=%s&mlon=%s\">\"%s\" (%s)</a> and stop <a href=\"http://www.openstreetmap.org/?mlat=%s&mlon=%s\">\"%s\" (%s)</a> could not be routed. Euclidean distance is %.0f.";
    private final RegularStop origin;
    private final RegularStop destination;
    private final double directDistance;

    public TransferCouldNotBeRouted(RegularStop origin, RegularStop destination, double directDistance) {
        this.origin = origin;
        this.destination = destination;
        this.directDistance = directDistance;
    }

    @Override
    public String getMessage() {
        return String.format(FMT, this.origin, this.destination, this.directDistance);
    }

    @Override
    public String getHTMLMessage() {
        return String.format(HTMLFMT, this.origin.getLat(), this.origin.getLon(), this.origin.getName(), this.origin.getId(), this.destination.getLat(), this.destination.getLon(), this.destination.getName(), this.destination.getId(), this.directDistance);
    }
}

