/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.siri.updater;

import java.util.List;
import org.apache.commons.lang3.BooleanUtils;
import org.opentripplanner.ext.siri.SiriFuzzyTripMatcher;
import org.opentripplanner.ext.siri.SiriTimetableSnapshotSource;
import org.opentripplanner.ext.siri.updater.SiriVMHttpTripUpdateSource;
import org.opentripplanner.ext.siri.updater.SiriVMUpdaterParameters;
import org.opentripplanner.ext.siri.updater.VehicleMonitoringSource;
import org.opentripplanner.transit.service.DefaultTransitService;
import org.opentripplanner.transit.service.TransitModel;
import org.opentripplanner.updater.PollingGraphUpdater;
import org.opentripplanner.updater.WriteToGraphCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.org.siri.siri20.ServiceDelivery;
import uk.org.siri.siri20.Siri;

public class SiriVMUpdater
extends PollingGraphUpdater {
    private static final Logger LOG = LoggerFactory.getLogger(SiriVMUpdater.class);
    private final VehicleMonitoringSource updateSource;
    private final String feedId;
    protected WriteToGraphCallback saveResultOnGraph;
    private final SiriFuzzyTripMatcher siriFuzzyTripMatcher;
    private final SiriTimetableSnapshotSource snapshotSource;

    public SiriVMUpdater(SiriTimetableSnapshotSource snapshotSource, SiriVMUpdaterParameters config, TransitModel transitModel) {
        super(config);
        this.feedId = config.getFeedId();
        this.updateSource = new SiriVMHttpTripUpdateSource(config.sourceParameters());
        this.snapshotSource = snapshotSource;
        this.blockReadinessUntilInitialized = config.blockReadinessUntilInitialized();
        this.siriFuzzyTripMatcher = SiriFuzzyTripMatcher.of(new DefaultTransitService(transitModel));
        LOG.info("Creating stop time updater (SIRI VM) running every {} seconds : {}", (Object)this.pollingPeriodSeconds(), (Object)this.updateSource);
    }

    @Override
    public void setGraphUpdaterManager(WriteToGraphCallback saveResultOnGraph) {
        this.saveResultOnGraph = saveResultOnGraph;
    }

    @Override
    public void runPolling() {
        boolean moreData = false;
        do {
            Siri updates;
            if ((updates = this.updateSource.getUpdates()) == null) continue;
            boolean fullDataset = this.updateSource.getFullDatasetValueOfLastUpdates();
            ServiceDelivery serviceDelivery = updates.getServiceDelivery();
            moreData = BooleanUtils.isTrue((Boolean)serviceDelivery.isMoreData());
            boolean markPrimed = !moreData;
            List vmds = serviceDelivery.getVehicleMonitoringDeliveries();
            if (vmds == null) continue;
            this.saveResultOnGraph.execute((graph, transitModel) -> {
                this.snapshotSource.applyVehicleMonitoring(transitModel, this.siriFuzzyTripMatcher, this.feedId, fullDataset, vmds);
                if (markPrimed) {
                    this.primed = true;
                }
            });
        } while (moreData);
    }

    public String toString() {
        String s = this.updateSource == null ? "NONE" : this.updateSource.toString();
        return "Polling SIRI VM updater with update source = " + s;
    }
}

